package de.duehl.basics.text.handling;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class IntegerHandlingTest {

    @Test
    public void integer0ToString() {
        int input = 0;
        String actual = IntegerHandling.intToString(input);
        String expected = "0";
        assertEquals(expected, actual);
    }

    @Test
    public void integerMinus13ToString() {
        int input = -13;
        String actual = IntegerHandling.intToString(input);
        String expected = "-13";
        assertEquals(expected, actual);
    }

    @Test
    public void integer2001ToString() {
        int input = 2001;
        String actual = IntegerHandling.intToString(input);
        String expected = "2001";
        assertEquals(expected, actual);
    }

    @Test
    public void integerMaxIntToString() {
        int input = Integer.MAX_VALUE;
        String actual = IntegerHandling.intToString(input);
        String expected = "2147483647";
        assertEquals(expected, actual);
    }

    @Test
    public void integerMinIntToString() {
        int input = Integer.MIN_VALUE;
        String actual = IntegerHandling.intToString(input);
        String expected = "-2147483648";
        assertEquals(expected, actual);
    }

    @Test
    public void string0ToInteger() {
        String input = "0";
        int actual = IntegerHandling.stringToInt(input);
        int expected = 0;
        assertEquals(expected, actual);
    }

    @Test
    public void stringMinus13ToInteger() {
        String input = "-13";
        int actual = IntegerHandling.stringToInt(input);
        int expected = -13;
        assertEquals(expected, actual);
    }

    @Test
    public void string2001ToInteger() {
        String input = "2001";
        int actual = IntegerHandling.stringToInt(input);
        int expected = 2001;
        assertEquals(expected, actual);
    }

    @Test
    public void stringMaxIntToInteger() {
        String input = "2147483647";
        int actual = IntegerHandling.stringToInt(input);
        int expected = Integer.MAX_VALUE;
        assertEquals(expected, actual);
    }

    @Test
    public void stringMinIntToInteger() {
        String input = "-2147483648";
        int actual = IntegerHandling.stringToInt(input);
        int expected = Integer.MIN_VALUE;
        assertEquals(expected, actual);
    }

}
