package de.duehl.swing.data;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;

/**
 * Diese Klasse eine feste Uhrzeit mit zweistelligen Stunden und zweistelligen Minuten dar.
 *
 * @version 1.01     2017-04-19
 * @author Christian Dühl
 */

public class MinuteHour {

    private final String minute;
    private final String hour;

    public MinuteHour(String text) {
        if (text.length() != 5) {
            throw new IllegalArgumentException("Der Text muss fünf Zeichen lang sein, denn er "
                    + "stellt eine Uhrzeit dar im Format 'HH:MM'! Übergebener Text: '" + text
                    + "'.");
        }

        List<String> parts = Text.splitByColon(text);
        if (parts.size() != 2) {
            throw new IllegalArgumentException("Der Text muss sich am Semikolon in zwei Teile "
                    + "teilen lassen, denn er stellt eine Uhrzeit dar im Format 'HH:MM'! "
                    + "Übergebener Text: '" + text + "'.");
        }

        hour = parts.get(0);
        minute = parts.get(1);
        if (hour.length() != 2) {
            throw new IllegalArgumentException("Die Stunden müssen zwei Stellen lang sein, denn "
                    + "der Text stellt eine Uhrzeit dar im Format 'HH:MM'! "
                    + "Übergebener Text: '" + text + "'.");
        }
        if (minute.length() != 2) {
            throw new IllegalArgumentException("Die Minuten müssen zwei Stellen lang sein, denn "
                    + "der Text stellt eine Uhrzeit dar im Format 'HH:MM'! "
                    + "Übergebener Text: '" + text + "'.");
        }
    }

    public String getMinute() {
        return minute;
    }

    public String getHour() {
        return hour;
    }

    public int getHoursAsInteger() {
        return NumberString.twoDigitStringToInteger(hour);
    }

    public int getMinuteAsInteger() {
        return NumberString.twoDigitStringToInteger(minute);
    }

    @Override
    public String toString() {
        return hour + ":" + minute;
    }

}
