package de.duehl.swing.ui.colors;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;

/**
 * Diese Klasse stellt eine benannte Farbe dar. Sie beinhaltet einen Namen,
 * einen Hexadezimalwert und die Farbe als Swing-Color.
 *
 * @version 1.01     2014-07-31
 * @author Christian Dühl
 */

public class NamedColor {

    /** Name der Farbe. */
    private String name;

    /** Hexadezimaler Wert der Farbe in Stringform ("FF0000"). */
    private String hexValue;

    /** Farbe als Swing-Farbe. */
    private Color color;

    /**
     * Konstruktor.
     *
     * @param name
     *            Name der Farbe.
     * @param hexValue
     *            Hexadezimaler Wert der Farbe in Stringform ("FF0000").
     */
    public NamedColor(String name, String hexValue) {
        this.name = name;
        this.hexValue = hexValue;
        color = ColorTranslator.hex2Swing(hexValue);
    }

    /** Getter für den Namen der Farbe. */
    public String getName() {
        return name;
    }

    /** Getter für den hexadezimalen Wert der Farbe in Stringform ("FF0000"). */
    public String getHexValue() {
        return hexValue;
    }

    /** Getter für die Farbe als Swing-Farbe. */
    public Color getColor() {
        return color;
    }

}
