package de.duehl.swing.ui.components.selections.datetime;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;

import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

import de.duehl.swing.data.DailyWeeklyNot;
import de.duehl.swing.ui.GuiTools;

/**
 * Diese Klasse ermöglicht die Auswahl täglich, wöchentlich oder gar nicht. Für täglich
 * gibt es eine Uhrzeit einzustellen, für wöchentlich eine Uhrzeit und einen Wochentag.
 *
 * @version 1.01     2017-03-27
 * @author Christian Dühl
 */

public class DailyWeeklyNotSelector {

    private final WeekdaySelection weeklyWeekdaySelection;
    private final QuarterlyTimeSelection weeklyTimeSelection;
    private final QuarterlyTimeSelection dailyTimeSelection;

    private JRadioButton dailyRadioButton;
    private JRadioButton weeklyRadioButton;
    private JRadioButton notRadioButton;

    private final JPanel panel;

    public DailyWeeklyNotSelector() {
        GuiTools.setNiceLayoutManager();

        weeklyWeekdaySelection = new WeekdaySelection();
        weeklyTimeSelection = new QuarterlyTimeSelection();
        dailyTimeSelection = new QuarterlyTimeSelection();

        initRadioButtons();

        panel = createPanel();
    }

    public void initValues(DailyWeeklyNot dailyWeeklyOrNot) {
        if (dailyWeeklyOrNot.isDaily()) {
            dailyRadioButton.setSelected(true);
        }
        if (dailyWeeklyOrNot.isWeekly()) {
            weeklyRadioButton.setSelected(true);
        }
        if (dailyWeeklyOrNot.isNot()) {
            notRadioButton.setSelected(true);
        }

        dailyTimeSelection.setTime(dailyWeeklyOrNot.getDailyTime());
        weeklyWeekdaySelection.setText(dailyWeeklyOrNot.getWeeklyWeekdayAsGermanName());
        weeklyTimeSelection.setTime(dailyWeeklyOrNot.getWeeklyTime());
    }

    private void initRadioButtons() {
        dailyRadioButton = new JRadioButton("Tägliche Sicherung");
        weeklyRadioButton = new JRadioButton("Wöchentliche Sicherung");
        notRadioButton = new JRadioButton("Keine automatische Sicherung");

        dailyRadioButton.setBorder(new EmptyBorder(3, 0, 10, 0));
        weeklyRadioButton.setBorder(new EmptyBorder(3, 0, 10, 0));
        notRadioButton.setBorder(new EmptyBorder(3, 0, 10, 0));

        ButtonGroup group = new ButtonGroup();
        group.add(dailyRadioButton);
        group.add(weeklyRadioButton);
        group.add(notRadioButton);

        dailyRadioButton.setSelected(true);
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        //panel.setLayout(new VerticalLayout(5, VerticalLayout.BOTH));
        panel.setLayout(new GridLayout(0, 3, 2, 2));

        panel.add(createDailyPart());
        panel.add(createWeeklyPart());
        panel.add(createNotPart());

        return panel;
    }

    private Component createDailyPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        GuiTools.createTitle(panel);

        panel.add(dailyRadioButton, BorderLayout.NORTH);
        panel.add(createDailyTimePart(),BorderLayout.CENTER);

        return panel;
    }

    private Component createDailyTimePart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(new JLabel("Zeit für das tägliche Backup:"), BorderLayout.NORTH);
        panel.add(dailyTimeSelection.getPanel());

        return panel;
    }

    private Component createWeeklyPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        GuiTools.createTitle(panel);

        panel.add(weeklyRadioButton, BorderLayout.NORTH);
        panel.add(createWeeklyDayAndTimePart(),BorderLayout.CENTER);

        return panel;
    }

    private Component createWeeklyDayAndTimePart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(createWeeklyTimePart(), BorderLayout.NORTH);
        panel.add(createWeeklyDayPart(),BorderLayout.CENTER);

        return panel;
    }

    private Component createWeeklyTimePart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(new JLabel("Zeit für das wöchentliche Backup:"), BorderLayout.NORTH);
        panel.add(weeklyTimeSelection.getPanel());

        return panel;
    }

    private Component createWeeklyDayPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(new JLabel("Tag für das wöchentliche Backup:"), BorderLayout.NORTH);
        panel.add(weeklyWeekdaySelection.getPanel());

        return panel;
    }

    private Component createNotPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        GuiTools.createTitle(panel);

        panel.add(notRadioButton, BorderLayout.NORTH);

        return panel;
    }

    public Component getPanel() {
        return panel;
    }

    /** Getter für die durch den Benutzer getroffenen Einstellungen. */
    public DailyWeeklyNot getUserSelection() {
        DailyWeeklyNot result = new DailyWeeklyNot();
        fillUserSelectionInResult(result);
        return result;
    }

    /** Schreibt die durch den Benutzer getroffenen Einstellungen in das übergebene Objekt. */
    private void fillUserSelectionInResult(DailyWeeklyNot result) {
        result.isDaily();
        if (dailyRadioButton.isSelected()) {
            result.setDaily();
        }
        if (weeklyRadioButton.isSelected()) {
            result.setWeekly();
        }
        if (notRadioButton.isSelected()) {
            result.setNot();
        }

        result.setDailyTime(dailyTimeSelection.getTime());
        result.setWeeklyWeekday(weeklyWeekdaySelection.getWeekday());
        result.setWeeklyTime(weeklyTimeSelection.getTime());
    }

}
