package de.duehl.swing.ui.elements.navigator;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für ein Objekt, das auf eine vom Benutzer eingegebene Elementnummer
 * zwischen 1 und der Maximalzahl der Elemente reagiert.
 *
 * @version 1.02     2020-01-17
 * @author Christian Dühl
 */

public interface ReactOnUserElementNumberSelection {

    /**
     * Reagiert auf eine vom Benutzer eingegebene Elementnummer zwischen 1 und der Maximalzahl der
     * Elemente.
     *
     * @param elementNumber
     *            Nummer des neu anzuzeigenden Elements (1-basierend).
     */
    void reactOnUserElementNumberSelection(int elementNumber);

}
