package de.duehl.swing.ui.elements.pictures;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für ein Objekt, dass auf das Scrollen am Mausrad reagiert.
 *
 * @version 1.01     2024-02-07
 * @author Christian Dühl
 */

public interface MouseWheelReactor {

    /**
     * Wird aufgerufen, wenn das Mausrad nach oben bewegt wird.
     *
     * @param units
     *            Anzahl der Notches, um die das Mausrad bewegt wurde.
     */
    void mouseWheelUp(int units);

    /**
     * Wird aufgerufen, wenn das Mausrad nach unten bewegt wird.
     *
     * @param units
     *            Anzahl der Notches, um die das Mausrad bewegt wurde.
     */
    void mouseWheelDown(int units);

}
