package de.duehl.swing.ui.listener;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import de.duehl.swing.logic.Quitter;

/**
 * Diese Klasse steuert das Verhalten, wenn auf x geklickt wird.
 *
 * @version 1.01     2013-04-09
 * @author Christian Dühl
 */

public class ClosingWindowListener implements WindowListener {

    private final Quitter quitter;

    public ClosingWindowListener(Quitter quitter) {
        this.quitter = quitter;
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        quitter.quit();
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

}
