package de.duehl.swing.ui.tabs.elements;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;

import de.duehl.swing.ui.tabs.Tabulator;

/**
 * Diese Klasse enthält alle Komponenten, die zu einem Reiter gehören.
 *
 * @version 1.01     2017-11-22
 * @author Christian Dühl
 */

public class TabElements<T extends Component> {

    /** Titel des Reiters. */
    private final String title;

    /** Objekt das oben im Reiter des Tabulators angezeigt wird. */
    private final Tabulator tabulator;

    /** Der Inhalt des Reiters. */
    private final T shownComponent;

    /**
     * Konstruktor.
     *
     * @param title
     *            Titel des Reiters.
     * @param tabulator
     *            Objekt das oben im Reiter des Tabulators angezeigt wird.
     * @param shownComponent
     *            Der Inhalt des Reiters.
     */
    public TabElements(String title, Tabulator tabulator, T shownComponent) {
        this.title = title;
        this.tabulator = tabulator;
        this.shownComponent = shownComponent;
    }

    /** Getter für den Titel des Reiters. */
    public String getTitle() {
        return title;
    }

    /** Getter für das Objekt das oben im Reiter des Tabulators angezeigt wird. */
    public Tabulator getTabulator() {
        return tabulator;
    }

    /** Getter für den Inhalt des Reiters. */
    public T getShownComponent() {
        return shownComponent;
    }

    @Override
    public String toString() {
        return "TabElements [title=" + title + ", tabulator=" + tabulator + ", shownComponent="
                + shownComponent + "]";
    }

}
