package de.duehl.swing.ui.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.painted.FirstButton;
import de.duehl.swing.ui.buttons.painted.LastButton;
import de.duehl.swing.ui.buttons.painted.NextButton;
import de.duehl.swing.ui.buttons.painted.PreviousButton;
import de.duehl.swing.ui.layout.ExtendedFlowLayout;
import de.duehl.swing.ui.layout.VerticalLayout;

/**
 * Diese Klasse testet einige selbstgezeichnete Buttons.
 *
 * @version 1.01     2015-12-16
 * @author Christian Dühl
 */

public class FirstPreviousNextLastTest {

    private static final Dimension BUTTON_DIMENSION = new Dimension(50, 50);

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new FirstPreviousNextLastTest();
    }

    /** Konstruktor. */
    public FirstPreviousNextLastTest() {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                createAndShowGUI();
            }
        });
    }

    /** Erstellt die grafische Oberfläche und zeigt sie an. */
    private void createAndShowGUI() {
        GuiTools.setNiceLayoutManager();

        JFrame frame = new JFrame(
                "First-, Previous-, Next- und Last-Button Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        frame.add(createHorizontalButtons(), BorderLayout.NORTH);
        frame.add(createVerticalButtons(), BorderLayout.SOUTH);

        frame.setPreferredSize(new Dimension(400, 500));
        frame.pack();
        frame.setVisible(true);
    }

    /** Erstellt ein Panel mit einer horizontalen Anordnung. */
    private Component createHorizontalButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new ExtendedFlowLayout());

        panel.add(createFirstButton(true));
        panel.add(createPreviousButton(true));
        panel.add(createNextButton(true));
        panel.add(createLastButton(true));

        return panel;
    }

    /** Erstellt ein Panel mit einer vertikalen Anordnung. */
    private Component createVerticalButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalLayout(15, VerticalLayout.CENTER));

        panel.add(createFirstButton(false));
        panel.add(createPreviousButton(false));
        panel.add(createNextButton(false));
        panel.add(createLastButton(false));

        return panel;
    }

    private JButton createFirstButton(boolean horizontal) {
        FirstButton button = new FirstButton();
        button.setHorizontal(horizontal);
        button.setPreferredSize(BUTTON_DIMENSION);
        return button;
    }

    private JButton createPreviousButton(boolean horizontal) {
        PreviousButton button = new PreviousButton();
        button.setHorizontal(horizontal);
        button.setPreferredSize(BUTTON_DIMENSION);
        return button;
    }

    private JButton createNextButton(boolean horizontal) {
        NextButton button = new NextButton();
        button.setHorizontal(horizontal);
        button.setPreferredSize(BUTTON_DIMENSION);
        return button;
    }

    private JButton createLastButton(boolean horizontal) {
        LastButton button = new LastButton();
        button.setHorizontal(horizontal);
        button.setPreferredSize(BUTTON_DIMENSION);
        return button;
    }

}
