package de.duehl.swing.ui.start.timedate;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.basics.datetime.DateAndTime;
import de.duehl.swing.ui.components.selections.datetime.SimpleDateAndTimeSelection;

public class SimpleDateAndTimeSelectionTest {

    private final SimpleDateAndTimeSelection dateAndTimeSelection = new SimpleDateAndTimeSelection();

    public SimpleDateAndTimeSelectionTest() {
        //dateAndTimeSelection.initWithNow();
        dateAndTimeSelection.initWithSmoothTimeInAbout10Minutes();
        SwingUtilities.invokeLater(this::createFrame);
    }

    private void createFrame() {
        JFrame frame= new JFrame();
        frame.setTitle("Testprogramm zum Wählen eines Datums und einer Uhrzeit.");

        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        frame.add(dateAndTimeSelection.getPanel(), BorderLayout.CENTER);
        frame.add(createPrintButton(), BorderLayout.SOUTH);

        frame.pack();
        frame.setVisible(true);
    }

    private Component createPrintButton() {
        JButton button = new JButton("Print");
        button.addActionListener(e -> print());
        return button;
    }

    private void print() {
        System.out.println("Gewählt roh: Datum: '" + dateAndTimeSelection.getDate() + "' Zeit: '"
                + dateAndTimeSelection.getTime() + "'.");

        if (dateAndTimeSelection.checkValidity()) {
            DateAndTime dateAndTime = dateAndTimeSelection.getDateAndTime();
            System.out.println("Aufbereitet als Objekt: " + dateAndTime);
        }
        else {
            System.out.println("Eingaben nicht valide!");
        }
    }

    public static void main(String[] args) {
        new SimpleDateAndTimeSelectionTest();
    }

}
