package de.duehl.threads.debug;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.debug.DebugHelper;

/**
 * Diese Klasse regelt die Debugausgaben. Ggf. könnte man mal über Logging nachdenken.
 *
 * @version 1.01     2016-12-08
 * @author Christian Dühl
 */

public class Debug {

    private static final boolean DEBUG = false;

    public static void say(String message) {
        if (DEBUG) {
            DebugHelper.sayWithClassAndMethodAndTime(message);
        }
    }

    /*
     * Zur Verwendung einfach
     *     import static de.duehl.threads.Debug.say;
     * importieren und dann say(...) benutzen.
     */

}
