package de.duehl.vocabulary.japanese.common.website.update;

import static de.duehl.vocabulary.japanese.common.website.VocaluaryTrainerWebsiteConstants.*;

import java.awt.Image;
import java.awt.Point;

import de.duehl.vocabulary.japanese.common.ui.dialogs.DialogWithCopyableUrl;

/**
 * Diese Klasse stellt Hilfsmethoden rund um Updates des Programms, der Vokabularien und der
 * Gruppen von eigenen Listen zur Verfügung.
 *
 * @version 1.01     2024-12-07
 * @author Christian Dühl
 */

public class UpdateTools {

    /**
     * Informiert den Benutzer über einen Fehler bei der Update-Überprüfung.
     *
     * @param description
     *            Beschreibung dessen, zu dem eine neue Version vorliegt, welche aber nicht
     *            abgerufen werden konnte (z.B. "des Programms", "der eigenen Listen" oder
     *            dergleichen).
     * @param parentLocation
     *            Die Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     * @param programImage
     *            Das anzuzeigende ProgrammIcon.
     */
    public static void informUserAboutDownloadFailure(String description, Point parentLocation,
            Image programImage) {
        String title = "Die aktuelle Version " + description + " konnte nicht abgerufen werden";
        String message = "Die aktuelle Version " + description + " konnte leider nicht abgerufen "
                + "werden.";
        String beforeUrl = "Bitte besuchen sie die Seite";
        String url = SHORT_VOCBULARY_TRAINER_WEBPAGE_URL;
        String afterUrl = "und prüfen die aktuelle Version dort selbst.";
        DialogWithCopyableUrl dialog = new DialogWithCopyableUrl(title, message,
                beforeUrl, url, afterUrl, parentLocation, programImage);
        dialog.setVisible(true);
    }

}
