package de.duehl.vocabulary.japanese.logic.symbol.kana.html.data;

import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.vocabulary.japanese.data.symbol.Kana;

/**
 * Diese Klasse steht für eine Struktur von Hiragana- oder Katakana-Zeichen für die Erzeugung einer
 * Übersicht in HTML.
 *
 * @version 1.01     2024-10-02
 * @author Christian Dühl
 */

public class KanaStructure {

    private List<Kana> kanaAIUEO;
    private List<Kana> kanaKaKiKuKeKo;
    private List<Kana> kanaSaShiSuSeSo;
    private List<Kana> kanaTaChiTsuTeTo;
    private List<Kana> kanaNaNiNuNeNo;
    private List<Kana> kanaHaHiFuHeHo;
    private List<Kana> kanaMaMiMuMeMo;
    private List<Kana> kanaYaYuYo;
    private List<Kana> kanaRaRiRuReRo;
    private List<Kana> kanaWaWo;
    private Kana kanaN;

    private List<Kana> kanaGaGiGuGeGo;
    private List<Kana> kanaZaJiZuZeZo;
    private List<Kana> kanaDaJiZuDeDo;
    private List<Kana> kanaBaBiBuBeBo;
    private List<Kana> kanaPaPiPuPePo;

    private List<Kana> kanaKyaKyuKyo;
    private List<Kana> kanaShaShuSho;
    private List<Kana> kanaChaChuCho;
    private List<Kana> kanaNyaNyuNyo;
    private List<Kana> kanaHyaHyuHyo;
    private List<Kana> kanaMyaMyuMyo;
    private List<Kana> kanaRyaRyuRyo;

    private List<Kana> kanaGyaGyuGyo;
    private List<Kana> kanaJaJuJo1;
    private List<Kana> kanaJaJuJo2;
    private List<Kana> kanaByaByuByo;
    private List<Kana> kanaPyaPyuPyo;

    private List<Kana> kanaLehnworte;

    private Kana kanaKleinesTsu;
    private List<Kana> kanaKleinesYaYuYo;

    public void fillAIUEO(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaAIUEO = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillKaKiKuKeKo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaKaKiKuKeKo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillSaShiSuSeSo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaSaShiSuSeSo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillTaChiTsuTeTo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaTaChiTsuTeTo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillNaNiNuNeNo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaNaNiNuNeNo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillHaHiFuHeHo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaHaHiFuHeHo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillMaMiMuMeMo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaMaMiMuMeMo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillYaYuYo(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaYaYuYo = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillRaRiRuReRo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaRaRiRuReRo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillWaWo(Kana kanaA, Kana kanaO) {
        kanaWaWo = CollectionsHelper.buildListFrom(kanaA, kanaO);
    }

    public void fillN(Kana kanaN) {
        this.kanaN = kanaN;
    }

    public void fillGaGiGuGeGo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaGaGiGuGeGo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillZaJiZuZeZo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaZaJiZuZeZo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillDaJiZuDeDo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaDaJiZuDeDo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillBaBiBuBeBo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaBaBiBuBeBo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillPaPiPuPePo(Kana kanaA, Kana kanaI, Kana kanaU, Kana kanaE, Kana kanaO) {
        kanaPaPiPuPePo = CollectionsHelper.buildListFrom(kanaA, kanaI, kanaU, kanaE, kanaO);
    }

    public void fillKanaLehnworte(List<Kana> kanaLehnworte) {
        this.kanaLehnworte = kanaLehnworte;
    }

    public void fillKyaKyuKyo(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaKyaKyuKyo = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillShaShuSho(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaShaShuSho = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillChaChuCho(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaChaChuCho = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillNyaNyuNyo(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaNyaNyuNyo = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillHyaHyuHyo(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaHyaHyuHyo = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillMyaMyuMyo(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaMyaMyuMyo = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillRyaRyuRyo(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaRyaRyuRyo = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillGyaGyuGyo(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaGyaGyuGyo = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillJaJuJo1(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaJaJuJo1 = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillJaJuJo2(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaJaJuJo2 = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillByaByuByo(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaByaByuByo = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillPyaPyuPyo(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaPyaPyuPyo = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public void fillKleinesTsu(Kana kanaKleinesTsu) {
        this.kanaKleinesTsu = kanaKleinesTsu;
    }

    public void fillKleinesYaYuYoGo(Kana kanaA, Kana kanaU, Kana kanaO) {
        kanaKleinesYaYuYo = CollectionsHelper.buildListFrom(kanaA, kanaU, kanaO);
    }

    public List<Kana> getKanaAIUEO() {
        return kanaAIUEO;
    }

    public List<Kana> getKanaKaKiKuKeKo() {
        return kanaKaKiKuKeKo;
    }

    public List<Kana> getKanaSaShiSuSeSo() {
        return kanaSaShiSuSeSo;
    }

    public List<Kana> getKanaTaChiTsuTeTo() {
        return kanaTaChiTsuTeTo;
    }

    public List<Kana> getKanaNaNiNuNeNo() {
        return kanaNaNiNuNeNo;
    }

    public List<Kana> getKanaHaHiFuHeHo() {
        return kanaHaHiFuHeHo;
    }

    public List<Kana> getKanaMaMiMuMeMo() {
        return kanaMaMiMuMeMo;
    }

    public List<Kana> getKanaYaYuYo() {
        return kanaYaYuYo;
    }

    public List<Kana> getKanaRaRiRuReRo() {
        return kanaRaRiRuReRo;
    }

    public List<Kana> getKanaWaWo() {
        return kanaWaWo;
    }

    public Kana getKanaN() {
        return kanaN;
    }

    public List<Kana> getKanaGaGiGuGeGo() {
        return kanaGaGiGuGeGo;
    }

    public List<Kana> getKanaZaJiZuZeZo() {
        return kanaZaJiZuZeZo;
    }

    public List<Kana> getKanaDaJiZuDeDo() {
        return kanaDaJiZuDeDo;
    }

    public List<Kana> getKanaBaBiBuBeBo() {
        return kanaBaBiBuBeBo;
    }

    public List<Kana> getKanaPaPiPuPePo() {
        return kanaPaPiPuPePo;
    }

    public List<Kana> getKanaLehnworte() {
        return kanaLehnworte;
    }

    public List<Kana> getKanaKyaKyuKyo() {
        return kanaKyaKyuKyo;
    }

    public List<Kana> getKanaShaShuSho() {
        return kanaShaShuSho;
    }

    public List<Kana> getKanaChaChuCho() {
        return kanaChaChuCho;
    }

    public List<Kana> getKanaNyaNyuNyo() {
        return kanaNyaNyuNyo;
    }

    public List<Kana> getKanaHyaHyuHyo() {
        return kanaHyaHyuHyo;
    }

    public List<Kana> getKanaMyaMyuMyo() {
        return kanaMyaMyuMyo;
    }

    public List<Kana> getKanaRyaRyuRyo() {
        return kanaRyaRyuRyo;
    }

    public List<Kana> getKanaGyaGyuGyo() {
        return kanaGyaGyuGyo;
    }

    public List<Kana> getKanaJaJuJo1() {
        return kanaJaJuJo1;
    }

    public List<Kana> getKanaJaJuJo2() {
        return kanaJaJuJo2;
    }

    public List<Kana> getKanaByaByuByo() {
        return kanaByaByuByo;
    }

    public List<Kana> getKanaPyaPyuPyo() {
        return kanaPyaPyuPyo;
    }

    public Kana getKanaKleinesTsu() {
        return kanaKleinesTsu;
    }

    public List<Kana> getKanaKleinesYaYuYo() {
        return kanaKleinesYaYuYo;
    }

}
