package de.duehl.vocabulary.japanese.ui.creation.menu;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;

/**
 * Diese Klasse erzeugt das Grammatik-Menü der graphischen Oberfläche des Vokabel-Trainers.
 *
 * @version 1.01     2025-06-11
 * @author Christian Dühl
 */

public class GrammarMenuCreation implements SingleMenuCreation {

    /** Verbindung zur grafischen Oberfläche. */
    private final VocabularyTrainerGui gui;

    /**
     * Konstruktor.
     *
     * @param gui
     *            Verbindung zur grafischen Oberfläche.
     */
    public GrammarMenuCreation(VocabularyTrainerGui gui) {
        this.gui = gui;
    }

    /** Erzeugt das Grammatik-Menü. */
    @Override
    public JMenu createTheMenu() {
        JMenu menu = new JMenu("Grammatik");
        menu.setMnemonic('g');

        menu.add(createShowVerbsInWoerterbuchformAsListMenuItem());
        menu.add(createShowAdjectivesInPositivePresenceAsListMenuItem());

        //menu.addSeparator();

        return menu;
    }

    private JMenuItem createShowVerbsInWoerterbuchformAsListMenuItem() {
        return new MyMenuItem("Verben in Wörterbnuchform als Liste anzeigen ...")
                .mnemonic('v')
                .accelerator(KeyEvent.VK_W, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showVerbsInWoerterbuchformAsList());
    }

    private JMenuItem createShowAdjectivesInPositivePresenceAsListMenuItem() {
        return new MyMenuItem("Adjektive in Grundform (positive Gegenwart) als Liste anzeigen ...")
                .mnemonic('a')
                .accelerator(KeyEvent.VK_G, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showAdjectivesInPositivePresenceAsList());
    }

}
