package de.duehl.vocabulary.japanese.ui.dialog.detail.addtolist;

import java.awt.Component;

import javax.swing.JButton;

import de.duehl.vocabulary.japanese.data.Vocable;

/**
 * Diese Klasse stellt einen Button bereit, um die angezeigte Vokabel zu einer eigenen Liste
 * hinzuzufügen.
 *
 * @version 1.01     2025-07-14
 * @author Christian Dühl
 */

class VocableToOwnListAdderButtonCreator {

    /** Die Vokabel. */
    private final Vocable vocable;

    /** Fügt eine Vokabel zu einer eigenen Liste hinzu. */
    private final VocableToOwnListAdder vocableToOwnListAdder;

    /**
     * Konstruktor.
     *
     * @param vocable
     *            Die Vokabel.
     * @param vocableToOwnListAdder
     *            Fügt eine Vokabel zu einer eigenen Liste hinzu.
     */
    public VocableToOwnListAdderButtonCreator(Vocable vocable,
            VocableToOwnListAdder vocableToOwnListAdder) {
        this.vocable = vocable;
        this.vocableToOwnListAdder = vocableToOwnListAdder;
    }

    public Component createAddVocableToListButton() {
        JButton button = new JButton("Vokabel zu eigener Liste hinzufügen.");
        button.addActionListener(e -> vocableToOwnListAdder.addVocableToList(vocable));
        return button;
    }

}
