/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.collections;

import de.duehl.basics.exceptions.EmptyStackException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Stack<E> {
    private final List<E> stackElements = new ArrayList();

    public boolean isEmpty() {
        return this.stackElements.isEmpty();
    }

    public boolean hasElements() {
        return !this.isEmpty();
    }

    public void clear() {
        this.stackElements.clear();
    }

    public void push(E e) {
        this.stackElements.add(e);
    }

    public E pop() {
        if (this.isEmpty()) {
            throw new EmptyStackException("Der Stapel ist leer!");
        }
        int n = this.stackElements.size() - 1;
        E e = this.stackElements.get(n);
        this.stackElements.remove(n);
        return e;
    }

    public int size() {
        return this.stackElements.size();
    }

    public List<E> getElementsAsList() {
        ArrayList<E> arrayList = new ArrayList<E>();
        arrayList.addAll(this.stackElements);
        return arrayList;
    }

    public void takeAllElementsFrom(Stack<E> stack) {
        stack.reverse();
        this.takeAllReverseElementsFrom(stack);
    }

    public void takeAllReverseElementsFrom(Stack<E> stack) {
        while (stack.hasElements()) {
            this.push(stack.pop());
        }
    }

    void reverse() {
        Collections.reverse(this.stackElements);
    }

    public String toString() {
        return "Stack [stackElements=" + this.stackElements + "]";
    }
}

