/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.date;

import de.duehl.basics.autodetect.AutoDetectionHelper;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.date.data.IndexAndDate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateFinder {
    private static final String MATCHING_DATE_REGEX = "(\\d{1,2}\\.\\d{1,2}\\.\\d{4})";
    private static final Pattern DATE_PATTERN = Pattern.compile("(\\d{1,2}\\.\\d{1,2}\\.\\d{4})");
    private static final Pattern COMPLICATED_DATE_PATTERN = Pattern.compile("(\\d{2}\\.\\d{2}\\.) ?(?:/|und) ?\\d{2}\\.\\d{2}\\.(\\d{4})");
    private static final String MATCHING_DATE_WITH_GERMAN_MONTH_NAMES_REGEX = "(" + ImmutualDate.DATE_WITH_GERMAN_MONTH_NAMES_REGEX + ")";
    private static final Pattern DATE_WITH_GERMAN_MONTH_NAMES_PATTERN = Pattern.compile(MATCHING_DATE_WITH_GERMAN_MONTH_NAMES_REGEX);
    public static final String DATE_REPLACE_FRONT_PART = "date";
    public static final String DATE_REPLACE_REGEX = "<<date:(\\d+)>>";
    private String text;
    private List<IndexAndDate> foundDates;
    private List<String> dates;

    public DateFinder(String string) {
        this.text = string;
    }

    public void find() {
        this.init();
        this.findComplicatedDates();
        this.findNormalDates();
        this.findDatesWithGermanMonthNames();
    }

    private void init() {
        this.foundDates = new ArrayList<IndexAndDate>();
        this.dates = new ArrayList<String>();
    }

    private void findComplicatedDates() {
        Matcher matcher = COMPLICATED_DATE_PATTERN.matcher(this.text);
        while (matcher.find()) {
            int n = matcher.start();
            String string = matcher.group();
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = string2 + string3;
            ImmutualDate immutualDate = new ImmutualDate(string4);
            this.dates.add(immutualDate.toString());
            int n2 = this.dates.size();
            this.replaceText(n, string, n2);
            this.foundDates.add(new IndexAndDate(n, immutualDate));
            matcher = COMPLICATED_DATE_PATTERN.matcher(this.text);
        }
    }

    private void findNormalDates() {
        Matcher matcher = DATE_PATTERN.matcher(this.text);
        while (matcher.find()) {
            int n = matcher.start();
            String string = matcher.group();
            ImmutualDate immutualDate = new ImmutualDate(string);
            this.dates.add(immutualDate.toString());
            int n2 = this.dates.size();
            this.replaceText(n, string, n2);
            this.foundDates.add(new IndexAndDate(n, immutualDate));
            matcher = DATE_PATTERN.matcher(this.text);
        }
    }

    private void findDatesWithGermanMonthNames() {
        Matcher matcher = DATE_WITH_GERMAN_MONTH_NAMES_PATTERN.matcher(this.text);
        while (matcher.find()) {
            int n = matcher.start();
            String string = matcher.group();
            ImmutualDate immutualDate = new ImmutualDate(string);
            this.dates.add(immutualDate.toString());
            int n2 = this.dates.size();
            this.replaceText(n, string, n2);
            this.foundDates.add(new IndexAndDate(n, immutualDate));
            matcher = DATE_WITH_GERMAN_MONTH_NAMES_PATTERN.matcher(this.text);
        }
    }

    private void replaceText(int n, String string, int n2) {
        String string2 = DateFinder.generateDateReplacement(n2);
        int n3 = n + string.length();
        String string3 = this.text.substring(0, n);
        String string4 = this.text.substring(n3);
        this.text = string3 + string2 + string4;
    }

    public String getText() {
        return this.text;
    }

    List<IndexAndDate> getFoundDates() {
        return this.foundDates;
    }

    public List<String> getDates() {
        return this.dates;
    }

    public static final String generateDateReplacement(int n) {
        return AutoDetectionHelper.createEntity(DATE_REPLACE_FRONT_PART, n);
    }
}

