/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.date;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.date.Weekday;
import de.duehl.basics.text.NumberString;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateHelper {
    private static final Pattern DDMMYYYY_PATTERN = Pattern.compile("(\\d{2})(\\d{2})(\\d{4})");
    private static final Pattern DD_DOT_MM_DOT_YYYY_PATTERN = Pattern.compile("(\\d{2})\\.(\\d{2})\\.(\\d{4})");
    private static final Pattern ANY_DATE_PATTERN = Pattern.compile(ImmutualDate.ANY_DATE_REGEX);
    private static final Pattern ANY_FULL_DATE_PATTERN = Pattern.compile(ImmutualDate.ANY_FULL_DATE_REGEX);

    public static ImmutualDate actualDate() {
        Calendar calendar = Calendar.getInstance();
        return DateHelper.calendarToDate(calendar);
    }

    public static String actualDateAsString() {
        Calendar calendar = Calendar.getInstance();
        ImmutualDate immutualDate = DateHelper.calendarToDate(calendar);
        return immutualDate.toString();
    }

    public static ImmutualDate calendarToDate(Calendar calendar) {
        int n = calendar.get(5);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(1);
        return new ImmutualDate(n, n2, n3);
    }

    public static boolean weekDayIsToday(Weekday weekday) {
        ImmutualDate immutualDate = new ImmutualDate();
        Weekday weekday2 = immutualDate.dayOfTheWeek();
        return weekday2 == weekday;
    }

    public static ImmutualDate getDateFromYYYYMMDD(String string) {
        if (!NumberString.isDigitSequence(string) || string.length() != 8) {
            throw new IllegalArgumentException("Die Eingabe '" + string + "' besteht nicht aus acht Ziffern.");
        }
        return new ImmutualDate(string);
    }

    public static ImmutualDate getDateFromDDMMYYYY(String string) {
        if (!NumberString.isDigitSequence(string) || string.length() != 8) {
            throw new IllegalArgumentException("Die Eingabe '" + string + "' besteht nicht aus acht Ziffern.");
        }
        Matcher matcher = DDMMYYYY_PATTERN.matcher(string);
        boolean bl = matcher.matches();
        if (bl) {
            int n = Integer.parseInt(matcher.group(1));
            int n2 = Integer.parseInt(matcher.group(2));
            int n3 = Integer.parseInt(matcher.group(3));
            return new ImmutualDate(n, n2, n3);
        }
        return new ImmutualDate(0, 0, 0);
    }

    public static boolean isInDdDotMmDotYyyyFormat(String string) {
        Matcher matcher = DD_DOT_MM_DOT_YYYY_PATTERN.matcher(string);
        boolean bl = matcher.matches();
        return bl;
    }

    public static void sortFromOldToNew(List<ImmutualDate> list) {
        Collections.sort(list, new Comparator<ImmutualDate>(){

            @Override
            public int compare(ImmutualDate immutualDate, ImmutualDate immutualDate2) {
                return immutualDate.compareTo(immutualDate2);
            }
        });
    }

    public static void sortFromNewToOld(List<ImmutualDate> list) {
        Collections.sort(list, new Comparator<ImmutualDate>(){

            @Override
            public int compare(ImmutualDate immutualDate, ImmutualDate immutualDate2) {
                return immutualDate2.compareTo(immutualDate);
            }
        });
    }

    public static List<ImmutualDate> getRange(ImmutualDate immutualDate, ImmutualDate immutualDate2) {
        if (immutualDate.after(immutualDate2)) {
            throw new IllegalArgumentException("Das fr\u00fcheste Datum " + immutualDate + " liegt nach dem sp\u00e4testen Datum " + immutualDate2 + "!");
        }
        ArrayList<ImmutualDate> arrayList = new ArrayList<ImmutualDate>();
        ImmutualDate immutualDate3 = immutualDate;
        while (!immutualDate3.after(immutualDate2)) {
            arrayList.add(immutualDate3);
            immutualDate3 = immutualDate3.addDays(1);
        }
        return arrayList;
    }

    public static List<ImmutualDate> getDatesOfActualMonth() {
        return DateHelper.getDatesOfMonthWithDate(new ImmutualDate());
    }

    public static List<ImmutualDate> getDatesOfMonthWithDate(ImmutualDate immutualDate) {
        ImmutualDate immutualDate2;
        ArrayList<ImmutualDate> arrayList = new ArrayList<ImmutualDate>();
        ImmutualDate immutualDate3 = immutualDate2 = new ImmutualDate(1, immutualDate.getMonth(), immutualDate.getYear());
        while (immutualDate3.getMonth() == immutualDate.getMonth()) {
            arrayList.add(immutualDate3);
            immutualDate3 = immutualDate3.addDays(1);
        }
        return arrayList;
    }

    public static List<ImmutualDate> getDatesOfActualWeek() {
        return DateHelper.getDatesOfWeekWithDate(new ImmutualDate());
    }

    public static List<ImmutualDate> getDatesOfWeekWithDate(ImmutualDate immutualDate) {
        ArrayList<ImmutualDate> arrayList = new ArrayList<ImmutualDate>();
        ImmutualDate immutualDate2 = immutualDate.dayOfTheWeek() == Weekday.MONDAY ? immutualDate : immutualDate.getWeekdayBefore(Weekday.MONDAY);
        ImmutualDate immutualDate3 = immutualDate2;
        while (immutualDate3.dayOfTheWeek() != Weekday.MONDAY || immutualDate3.equals(immutualDate2)) {
            arrayList.add(immutualDate3);
            immutualDate3 = immutualDate3.addDays(1);
        }
        return arrayList;
    }

    public static List<ImmutualDate> keepOnlyWorkDays(List<ImmutualDate> list) {
        ArrayList<ImmutualDate> arrayList = new ArrayList<ImmutualDate>();
        for (ImmutualDate immutualDate : list) {
            if (!immutualDate.isWorkDay()) continue;
            arrayList.add(immutualDate);
        }
        return arrayList;
    }

    public static String determineNewestDate(String ... stringArray) {
        ArrayList<ImmutualDate> arrayList = new ArrayList<ImmutualDate>();
        for (String string : stringArray) {
            ImmutualDate immutualDate = new ImmutualDate(string);
            arrayList.add(immutualDate);
        }
        DateHelper.sortFromNewToOld(arrayList);
        return ((ImmutualDate)arrayList.get(0)).toString();
    }

    public static String createCorrectDate(String string) {
        ImmutualDate immutualDate = new ImmutualDate(string);
        return immutualDate.toString();
    }

    public static String insertDateDotsDDMMYYYY(String string) {
        if (!NumberString.isDigitSequence(string) || string.length() != 8) {
            return string;
        }
        String string2 = string.substring(0, 2);
        String string3 = string.substring(2, 4);
        String string4 = string.substring(4);
        return string2 + "." + string3 + "." + string4;
    }

    public static String removeDateDotsDDMMYYYY(String string) {
        if (string.length() != 10) {
            return string;
        }
        return string.replace(".", "");
    }

    public static boolean conainesAnyDate(String string) {
        Matcher matcher = ANY_DATE_PATTERN.matcher(string);
        return matcher.find();
    }

    public static boolean conainesAnyFullDate(String string) {
        Matcher matcher = ANY_FULL_DATE_PATTERN.matcher(string);
        return matcher.find();
    }
}

