/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import java.util.ArrayList;
import java.util.List;

public class HeaderAndDataFromTabSeparatedFileReader {
    private final String filename;
    private final Charset charset;
    private List<String> titles;
    private List<List<String>> listOfDataSets;
    private boolean fileMayContainOnlyHeaderLine;

    public HeaderAndDataFromTabSeparatedFileReader(String string) {
        this(string, Charset.ISO_8859_1);
    }

    public HeaderAndDataFromTabSeparatedFileReader(String string, Charset charset) {
        this.filename = string;
        this.charset = charset;
        this.fileMayContainOnlyHeaderLine = false;
        this.listOfDataSets = new ArrayList<List<String>>();
    }

    public void allowFileMayContainOnlyHeaderLine() {
        this.fileMayContainOnlyHeaderLine = true;
    }

    public void readAndCheck() {
        List<List<String>> list = this.readFile(this.filename);
        if (list.isEmpty()) {
            throw new RuntimeException("Die Datei ist leer: " + this.filename);
        }
        this.titles = list.get(0);
        this.listOfDataSets.clear();
        for (int i = 1; i < list.size(); ++i) {
            this.listOfDataSets.add(list.get(i));
        }
        this.checkDataLinesNotEmpty();
    }

    private List<List<String>> readFile(String string) {
        List<List<String>> list = FileHelper.readFileToListOfFieldLines(string, this.charset);
        if (list.isEmpty()) {
            if (!this.fileMayContainOnlyHeaderLine) {
                throw new RuntimeException("Leere Datei\n\t" + string);
            }
        } else {
            this.checkAllLinesHaveEqualNumberOfFields(list, string);
        }
        return list;
    }

    private void checkAllLinesHaveEqualNumberOfFields(List<List<String>> list, String string) {
        int n = list.get(0).size();
        for (int i = 1; i < list.size(); ++i) {
            int n2 = list.get(i).size();
            if (n2 == n) continue;
            throw new RuntimeException("Abweichende Zeilenl\u00e4nge in Zeile " + (i + 1) + " in der Datei\n\t" + string);
        }
    }

    private void checkDataLinesNotEmpty() {
        if (this.listOfDataSets.isEmpty() && !this.fileMayContainOnlyHeaderLine) {
            throw new RuntimeException("Die Datei\n\t" + this.filename + "\nenth\u00e4lt keine Daten!");
        }
    }

    protected String getFilename() {
        return this.filename;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public List<List<String>> getListOfDataSets() {
        return this.listOfDataSets;
    }

    public int getSizeOfDataLines() {
        return this.listOfDataSets.size();
    }
}

