/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile.dictionary;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.textfile.dictionary.DictionaryEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Dictionary
implements Iterable<DictionaryEntry> {
    private final List<DictionaryEntry> dictionaryEntries = new ArrayList<DictionaryEntry>();

    public void addDictionaryEntry(DictionaryEntry dictionaryEntry) {
        this.dictionaryEntries.add(dictionaryEntry);
    }

    @Override
    public Iterator<DictionaryEntry> iterator() {
        return this.dictionaryEntries.iterator();
    }

    public List<DictionaryEntry> getDictionaryEntries() {
        return this.dictionaryEntries;
    }

    public String createDescription(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(":\n");
        stringBuilder.append("\n");
        stringBuilder.append(this.createDescription(4));
        return stringBuilder.toString();
    }

    public String createDescription() {
        return this.createDescription(0);
    }

    private String createDescription(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("\n");
            }
            stringBuilder.append(dictionaryEntry.createDescription(n));
        }
        return stringBuilder.toString();
    }

    public boolean containsEntryWithMainWord(String string) {
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            if (!string.equals(dictionaryEntry.getMainWord())) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntryWithMainWordOrAlternative(String string) {
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            if (!dictionaryEntry.contains(string)) continue;
            return true;
        }
        return false;
    }

    public boolean textContainsMainWordOrAlternative(String string) {
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            if (!dictionaryEntry.textContainsMainWordOrAlternative(string)) continue;
            return true;
        }
        return false;
    }

    public DictionaryEntry getEntryWithMainWord(String string) {
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            if (!string.equals(dictionaryEntry.getMainWord())) continue;
            return dictionaryEntry;
        }
        throw new RuntimeException("Es wurde kein W\u00f6rterbucheintrag mit dem Hauptwort '" + string + "' gefunden.");
    }

    public int size() {
        return this.dictionaryEntries.size();
    }

    public DictionaryEntry get(int n) {
        return this.dictionaryEntries.get(n);
    }

    public String getMainWordOfAlternative(String string) {
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            if (!dictionaryEntry.contains(string)) continue;
            return dictionaryEntry.getMainWord();
        }
        return string;
    }

    public String getMainWordOfAlternativeToEmptyIfNotFound(String string) {
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            if (!dictionaryEntry.contains(string)) continue;
            return dictionaryEntry.getMainWord();
        }
        return "";
    }

    public String getMainWordOfAlternativeWithError(String string, String string2) {
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            if (!dictionaryEntry.contains(string)) continue;
            return dictionaryEntry.getMainWord();
        }
        throw new RuntimeException(string2);
    }

    public void sortAlternatives() {
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            dictionaryEntry.sortAlternatives();
        }
    }

    public void sortAllAlternativesByLengthDescanding() {
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            dictionaryEntry.sortAllAlternativesByLengthDescanding();
        }
    }

    public List<List<String>> toListOfLists() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            arrayList.add(dictionaryEntry.getAsFlatList());
        }
        return arrayList;
    }

    public List<String> toFlatList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            arrayList.add(dictionaryEntry.getMainWord());
            arrayList.addAll(dictionaryEntry.getAlternatives());
        }
        return arrayList;
    }

    public List<String> toDisjunctFlatListSortedByLengthDescanding() {
        List<String> list = this.toFlatList();
        CollectionsHelper.makeListDisjunct(list);
        CollectionsHelper.sortStringListByLengthDescanding(list);
        return list;
    }

    public Map<String, List<String>> createMapFromDictionary() {
        boolean bl = false;
        return this.createMapFromDictionaryInternal(bl);
    }

    public Map<String, List<String>> createMapFromDictionaryMultipleMainWordsAreError() {
        boolean bl = true;
        return this.createMapFromDictionaryInternal(bl);
    }

    private Map<String, List<String>> createMapFromDictionaryInternal(boolean bl) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            String string = dictionaryEntry.getMainWord();
            if (hashMap.containsKey(string) && bl) {
                throw new RuntimeException("Doppelter Schl\u00fcssel '" + string + "' in W\u00f6rterbuch");
            }
            hashMap.put(string, dictionaryEntry.getAsFlatList());
        }
        return hashMap;
    }

    public List<String> getMainWords() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            String string = dictionaryEntry.getMainWord();
            arrayList.add(string);
        }
        return arrayList;
    }

    public void checkAllMaiwordsAndAlternativesAreUnique() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (DictionaryEntry dictionaryEntry : this.dictionaryEntries) {
            String string = dictionaryEntry.getMainWord();
            if (arrayList.contains(string)) {
                arrayList2.add(string);
            }
            arrayList.add(string);
            for (String string2 : dictionaryEntry.getAlternatives()) {
                if (arrayList.contains(string2)) {
                    arrayList2.add(string2);
                }
                arrayList.add(string2);
            }
        }
        if (!arrayList2.isEmpty()) {
            throw new RuntimeException("Die folgenden Eintr\u00e4ge kommen mehr als einmal im Dictionary vor:\n" + CollectionsHelper.listListNice(arrayList2));
        }
    }

    public int hashCode() {
        return Objects.hash(this.dictionaryEntries);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Dictionary dictionary = (Dictionary)object;
        return Objects.equals(this.dictionaryEntries, dictionary.dictionaryEntries);
    }

    public String toString() {
        return "Dictionary [dictionaryEntries=" + this.dictionaryEntries + "]";
    }
}

