/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.zip;

import de.duehl.basics.datetime.DateAndTime;
import de.duehl.basics.datetime.DateAndTimeHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.exceptions.ZippingException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

abstract class Zip {
    private final boolean withStartDirectory;
    private boolean changeCreationLastAccessAndModificationTime;
    private FileTime timeToSet;

    public Zip(boolean bl) {
        this.withStartDirectory = bl;
        this.changeCreationLastAccessAndModificationTime = false;
    }

    public void changeCreationLastAccessAndModificationTime(long l) {
        this.changeCreationLastAccessAndModificationTime(FileTime.from(l, TimeUnit.MILLISECONDS));
    }

    public void changeCreationLastAccessAndModificationTime(FileTime fileTime) {
        this.timeToSet = fileTime;
        this.changeCreationLastAccessAndModificationTime = true;
    }

    public void changeCreationLastAccessAndModificationTime(String string, String string2) {
        long l = DateAndTimeHelper.toEpoch(string, string2);
        this.changeCreationLastAccessAndModificationTime(l);
    }

    public void changeCreationLastAccessAndModificationTime(DateAndTime dateAndTime) {
        long l = dateAndTime.toEpoch();
        this.changeCreationLastAccessAndModificationTime(l);
    }

    protected void switchCreationLastAccessAndModificationTimeChangingOff() {
        this.changeCreationLastAccessAndModificationTime = false;
    }

    protected boolean isWithStartDirectory() {
        return this.withStartDirectory;
    }

    protected ZipOutputStream createArchive(String string) {
        try {
            return new ZipOutputStream(new FileOutputStream(string));
        }
        catch (IOException iOException) {
            throw new ZippingException("Archiv " + string + " kann nicht angelegt werden.");
        }
    }

    protected void closeArchive(ZipOutputStream zipOutputStream) {
        try {
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            throw new ZippingException("Kann Archiv nicht schlie\u00dfen!");
        }
    }

    protected void packFile(String string, ZipOutputStream zipOutputStream, File file) {
        this.packFile(string, zipOutputStream, file.getPath());
    }

    protected void packFile(String string, ZipOutputStream zipOutputStream, String string2) {
        String string3 = FileHelper.removeTrailingSlash(string);
        String string4 = this.determineFilenameForFileToPack(string3, string2);
        this.packFileInternal(zipOutputStream, string2, string4);
    }

    private String determineFilenameForFileToPack(String string, String string2) {
        if (!string2.startsWith(string)) {
            throw new ZippingException("Datei f\u00e4ngt nicht mit dem Basisverzeichnis an!\n\tVerzeichnis: " + string + "\n\tDatei      : " + string2);
        }
        if (this.isWithStartDirectory()) {
            int n = FileHelper.lastSlash(string);
            return string2.substring(n + 1);
        }
        return string2.substring(string.length());
    }

    private void packFileInternal(ZipOutputStream zipOutputStream, String string, String string2) {
        try {
            this.tryToPackFileInternal(zipOutputStream, string, string2);
        }
        catch (IOException | IllegalArgumentException exception) {
            throw new ZippingException("Die Datei " + string + " kann nicht ins Archiv gelegt werden.", exception);
        }
    }

    private void tryToPackFileInternal(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string2);
        zipOutputStream.putNextEntry(zipEntry);
        byte[] byArray = this.readFileToBuffer(string);
        zipOutputStream.write(byArray, 0, byArray.length);
        zipOutputStream.closeEntry();
        if (this.changeCreationLastAccessAndModificationTime) {
            zipEntry.setLastModifiedTime(this.timeToSet);
            zipEntry.setLastAccessTime(this.timeToSet);
            zipEntry.setCreationTime(this.timeToSet);
        } else {
            zipEntry.setTime(new File(string).lastModified());
        }
    }

    private byte[] readFileToBuffer(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        int n = bufferedInputStream.available();
        byte[] byArray = new byte[n];
        if (n > 0) {
            bufferedInputStream.read(byArray, 0, n);
            bufferedInputStream.close();
        }
        return byArray;
    }
}

