/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.logging;

import de.duehl.basics.logging.LogEntry;
import de.duehl.basics.logging.StructuredLogger;
import java.util.ArrayList;
import java.util.List;

public class MemoryLogger
extends StructuredLogger {
    private final List<LogEntry> logEntries = new ArrayList<LogEntry>();

    @Override
    public void log(String string) {
        this.log(string, 1);
    }

    @Override
    public synchronized void log(String string, int n) {
        super.log(string, n);
        LogEntry logEntry = this.getLastLogEntry();
        this.logEntries.add(logEntry);
    }

    @Override
    public String getLogFileName() {
        throw new RuntimeException("Der MemoryLogger schreibt in keine Datei!");
    }

    @Override
    public String getLogPath() {
        throw new RuntimeException("Der MemoryLogger schreibt in keine Datei!");
    }

    @Override
    public int getLastWrittenLineNumber() {
        return super.getLastWrittenLineNumber() + 1;
    }

    public List<LogEntry> getLogEntries() {
        ArrayList<LogEntry> arrayList = new ArrayList<LogEntry>();
        arrayList.addAll(this.logEntries);
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MemoryLogger\n");
        for (LogEntry logEntry : this.logEntries) {
            stringBuilder.append(logEntry.asLine()).append("\n");
        }
        return stringBuilder.toString();
    }
}

