/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.logging.eraser;

import de.duehl.basics.logging.Logger;
import de.duehl.basics.logging.eraser.StdOutLogger;
import java.io.File;
import java.io.FilenameFilter;

public class LogEraser {
    private final String path;
    private final String begin;
    private final String end;
    private final Logger logger;
    private int days;

    public LogEraser(String string, String string2, String string3) {
        this(string, string2, string3, new StdOutLogger());
    }

    public LogEraser(String string, String string2, String string3, Logger logger) {
        this.path = string;
        this.begin = string2;
        this.end = string3;
        this.logger = logger;
        this.days = 7;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int n) {
        this.days = n;
    }

    public void erase() {
        this.logger.log("Start erasing old files in '" + this.path + "' with beginning '" + this.begin + "' and end '" + this.end + "'.");
        File file = new File(this.path);
        long l = System.currentTimeMillis();
        long l2 = (long)this.days * 86400000L;
        int n = 0;
        for (File file2 : file.listFiles(this.createLogFilenameFilter())) {
            long l3 = l - file2.lastModified();
            if (l3 <= l2) continue;
            boolean bl = file2.delete();
            if (bl) {
                this.logger.log("Erasing file " + file2);
                ++n;
                continue;
            }
            this.logger.log("Can't erase file " + file2 + "!");
        }
        this.logger.log("End erasing old files in '" + this.path + "' with beginning '" + this.begin + "' and end '" + this.end + "'. Number of deleted files: " + n);
    }

    private FilenameFilter createLogFilenameFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return new File(file, string).isFile() && string.startsWith(LogEraser.this.begin) && string.endsWith(LogEraser.this.end);
            }
        };
    }

    public String toString() {
        return "LogEraser[path='" + this.path + "', begin='" + this.begin + "', end='" + this.end + "', logger='" + this.logger + "']";
    }
}

