/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BulletinBoardCode {
    private final Map<String, String> bbMap = this.buildBulletinBoardMap();
    private final Map<String, String> bbMapForJava = this.buildBulletinBoardMapForJava();
    private static Pattern findNormalListPattern = Pattern.compile("\\[list\\](.*?)\\[/list\\]", 42);
    private static Pattern findSpecialListPattern = Pattern.compile("\\[list=(.)\\](.*?)\\[/list\\]", 42);

    private Map<String, String> buildBulletinBoardMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("\\[b\\](.+?)\\[/b\\]", "<strong>$1</strong>");
        hashMap.put("\\[i\\](.+?)\\[/i\\]", "<span style='font-style:italic;'>$1</span>");
        hashMap.put("\\[u\\](.+?)\\[/u\\]", "<span style='text-decoration:underline;'>$1</span>");
        hashMap.put("\\[s\\](.+?)\\[/s\\]", "<span style=\"text-decoration:line-through\">$1</span>");
        hashMap.put("\\[c\\](.+?)\\[/c\\]", "<span style=\"font-family:monospace\">$1</span>");
        hashMap.put("\\[h1\\](.+?)\\[/h1\\]", "<h1>$1</h1>");
        hashMap.put("\\[h2\\](.+?)\\[/h2\\]", "<h2>$1</h2>");
        hashMap.put("\\[h3\\](.+?)\\[/h3\\]", "<h3>$1</h3>");
        hashMap.put("\\[h4\\](.+?)\\[/h4\\]", "<h4>$1</h4>");
        hashMap.put("\\[h5\\](.+?)\\[/h5\\]", "<h5>$1</h5>");
        hashMap.put("\\[h6\\](.+?)\\[/h6\\]", "<h6>$1</h6>");
        hashMap.put("\\[quote\\](.+?)\\[/quote\\]", "<blockquote>$1</blockquote>");
        hashMap.put("\\[p\\](.+?)\\[/p\\]", "<p>$1</p>");
        hashMap.put("\\[p=(.+?),(.+?)\\](.+?)\\[/p\\]", "<p style='text-indent:$1px;line-height:$2%;'>$3</p>");
        hashMap.put("\\[center\\](.+?)\\[/center\\]", "<div align='center'>$1</div>");
        hashMap.put("\\[align=(.+?)\\](.+?)\\[/align\\]", "<div align='$1'>$2</div>");
        hashMap.put("\\[color=(.+?)\\](.+?)\\[/color\\]", "<span style='color:$1;'>$2</span>");
        hashMap.put("\\[size=(.+?)\\](.+?)\\[/size\\]", "<span style='font-size:$1;'>$2</span>");
        hashMap.put("\\[img\\](.+?)\\[/img\\]", "<img src='$1' />");
        hashMap.put("\\[img=(.+?),(.+?)\\](.+?)\\[/img\\]", "<img width='$1' height='$2' src='$3' />");
        hashMap.put("\\[email\\](.+?)\\[/email\\]", "<a href='mailto:$1'>$1</a>");
        hashMap.put("\\[email=(.+?)\\](.+?)\\[/email\\]", "<a href='mailto:$1'>$2</a>");
        hashMap.put("\\[url\\](.+?)\\[/url\\]", "<a href='$1'>$1</a>");
        hashMap.put("\\[url=(.+?)\\](.+?)\\[/url\\]", "<a href='$1'>$2</a>");
        hashMap.put("\\[youtube\\](.+?)\\[/youtube\\]", "<object width='640' height='380'><param name='movie' value='http://www.youtube.com/v/$1'></param><embed src='http://www.youtube.com/v/$1' type='application/x-shockwave-flash' width='640' height='380'></embed></object>");
        hashMap.put("\\[video\\](.+?)\\[/video\\]", "<video src='$1' />");
        hashMap.put("\\[pre\\](.+?)\\[/pre\\]", "<pre>$1</pre>");
        return hashMap;
    }

    private Map<String, String> buildBulletinBoardMapForJava() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("\\[b\\](.+?)\\[/b\\]", "<b>$1</b>");
        hashMap.put("\\[i\\](.+?)\\[/i\\]", "<i>$1</i>");
        hashMap.put("\\[u\\](.+?)\\[/u\\]", "<u>$1</u>");
        hashMap.put("\\[s\\](.+?)\\[/s\\]", "<s>$1</s>");
        hashMap.put("\\[c\\](.+?)\\[/c\\]", "<span style=\"font-family:monospace\">$1</span>");
        hashMap.put("\\[h1\\](.+?)\\[/h1\\]", "<h1>$1</h1>");
        hashMap.put("\\[h2\\](.+?)\\[/h2\\]", "<h2>$1</h2>");
        hashMap.put("\\[h3\\](.+?)\\[/h3\\]", "<h3>$1</h3>");
        hashMap.put("\\[h4\\](.+?)\\[/h4\\]", "<h4>$1</h4>");
        hashMap.put("\\[h5\\](.+?)\\[/h5\\]", "<h5>$1</h5>");
        hashMap.put("\\[h6\\](.+?)\\[/h6\\]", "<h6>$1</h6>");
        hashMap.put("\\[quote\\](.+?)\\[/quote\\]", "<blockquote>$1</blockquote>");
        hashMap.put("\\[p\\](.+?)\\[/p\\]", "<p>$1</p>");
        hashMap.put("\\[p=(.+?),(.+?)\\](.+?)\\[/p\\]", "<p style='text-indent:$1px;line-height:$2%;'>$3</p>");
        hashMap.put("\\[center\\](.+?)\\[/center\\]", "<div align='center'>$1</div>");
        hashMap.put("\\[align=(.+?)\\](.+?)\\[/align\\]", "<div align='$1'>$2</div>");
        hashMap.put("\\[color=(.+?)\\](.+?)\\[/color\\]", "<span style='color:$1;'>$2</span>");
        hashMap.put("\\[size=(.+?)\\](.+?)\\[/size\\]", "<span style='font-size:$1;'>$2</span>");
        hashMap.put("\\[email\\](.+?)\\[/email\\]", "<a href='mailto:$1'>$1</a>");
        hashMap.put("\\[email=(.+?)\\](.+?)\\[/email\\]", "<a href='mailto:$1'>$2</a>");
        hashMap.put("\\[url\\](.+?)\\[/url\\]", "<a href='$1'>$1</a>");
        hashMap.put("\\[url=(.+?)\\](.+?)\\[/url\\]", "<a href='$1'>$2</a>");
        hashMap.put("\\[\\*\\]([^\\[\\]\\<\\>]+)\\]", "<li>$1</li>");
        hashMap.put("\\[pre\\](.+?)\\[/pre\\]", "<pre>$1</pre>");
        return hashMap;
    }

    public String toHtml(String string) {
        String string2 = this.replace(string, this.bbMap);
        return string2;
    }

    public String toHtmlForJava(String string) {
        String string2 = this.replace(string, this.bbMapForJava);
        return string2;
    }

    private String replace(String string, Map<String, String> map) {
        CharSequence charSequence;
        String string2;
        String string3 = string;
        for (String object2 : map.keySet()) {
            string2 = map.get(object2);
            string3 = string3.replaceAll(object2, string2);
        }
        Matcher matcher = findNormalListPattern.matcher(string3);
        while (matcher.find()) {
            String string4 = matcher.group();
            string2 = matcher.group(1);
            charSequence = new StringBuilder();
            string2 = string2.replaceAll("\\[\\*\\]([^\\[\\]]+)", "<li>$1</li>");
            string2 = string2.replace("^<br/>", "");
            string2 = string2.replace("<li> ", "<li>");
            string2 = string2.replace("<br/>", "");
            string2 = string2.replaceAll("\n(\\s*)</li>", "</li>\n$1");
            ((StringBuilder)charSequence).append("<ul>");
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append("</ul>");
            string3 = string3.replace(string4, ((StringBuilder)charSequence).toString());
        }
        Matcher matcher2 = findSpecialListPattern.matcher(string3);
        while (matcher2.find()) {
            string2 = matcher2.group();
            charSequence = matcher2.group(1);
            String string5 = matcher2.group(2);
            StringBuilder stringBuilder = new StringBuilder();
            string5 = string5.replaceAll("\\[\\*\\]([^\\[\\]]+)", "<li>$1</li>");
            string5 = string5.replace("<li> ", "<li>");
            string5 = string5.replace("<br/>", "");
            string5 = string5.replaceAll("\n(\\s*)</li>", "</li>\n$1");
            if ("i".equals(charSequence)) {
                stringBuilder.append("<ol type=\"i\">");
            } else if ("a".equals(charSequence)) {
                stringBuilder.append("<ol type=\"a\">");
            } else {
                stringBuilder.append("<ol>");
            }
            stringBuilder.append(string5);
            stringBuilder.append("</ol>");
            string3 = string3.replace(string2, stringBuilder.toString());
        }
        return string3;
    }
}

