/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.pictures;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;

public class PictureHelper {
    private static final List<String> PICTURE_EXTENSIONS = CollectionsHelper.buildListFrom(".png", ".gif", ".bmp", ".jpg", ".jpeg");

    public static List<String> determinePicturesInDirectory(String string) {
        List<String> list = FileHelper.findAllFilesInMainDirectoryNio2(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            String string3 = Text.toLowerCase(string2);
            if (!CollectionsHelper.inputEndsWithAnyListElement(string3, PICTURE_EXTENSIONS)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static BufferedImage loadImage(String string) {
        try {
            return ImageIO.read(new File(string));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Beim Laden des Bildes " + string + " trat ein Fehler auf.", iOException);
        }
    }

    public static void storeImage(String string, BufferedImage bufferedImage) {
        try {
            PictureHelper.tryToStoreImage(string, bufferedImage);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Fehler beim Speichern des Bildes " + string, iOException);
        }
    }

    private static void tryToStoreImage(String string, BufferedImage bufferedImage) throws IOException {
        String string2 = PictureHelper.determinePictureFormatName(string);
        File file = new File(string);
        ImageIO.write((RenderedImage)bufferedImage, string2, file);
    }

    public static String determinePictureFormatName(String string) {
        String string2 = FileHelper.determineExtension(string);
        if ("OHNE_EXTENSION".equals(string2)) {
            throw new RuntimeException("Keine Extension am Dateinamen erkannt.\n\tfilename = " + string + "\n");
        }
        string2 = string2.substring(1);
        if ((string2 = Text.toLowerCase(string2)).equals("jpeg")) {
            string2 = "jpg";
        }
        return string2;
    }

    public static BufferedImage deepImageCopy(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl = colorModel.isAlphaPremultiplied();
        WritableRaster writableRaster = bufferedImage.copyData(bufferedImage.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(colorModel, writableRaster, bl, null);
    }

    public static BufferedImage rotateImageByDegrees(BufferedImage bufferedImage, double d) {
        double d2 = Math.toRadians(d);
        return PictureHelper.rotateImageByRad(bufferedImage, d2);
    }

    public static BufferedImage rotateImageByRad(BufferedImage bufferedImage, double d) {
        double d2 = Math.abs(Math.sin(d));
        double d3 = Math.abs(Math.cos(d));
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = (int)Math.floor((double)n * d3 + (double)n2 * d2);
        int n4 = (int)Math.floor((double)n2 * d3 + (double)n * d2);
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate((n3 - n) / 2, (n4 - n2) / 2);
        int n5 = n / 2;
        int n6 = n2 / 2;
        affineTransform.rotate(d, n5, n6);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.drawRect(0, 0, n3 - 1, n4 - 1);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static Dimension getImageDimension(String string) {
        File file = new File(string);
        int n = file.getName().lastIndexOf(".");
        if (n == -1) {
            throw new RuntimeException("Der Dateinamen hat keine Erweiterung: " + string);
        }
        String string2 = file.getName().substring(n + 1);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string2);
        if (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            try {
                FileImageInputStream fileImageInputStream = new FileImageInputStream(file);
                imageReader.setInput(fileImageInputStream);
                int n2 = imageReader.getWidth(imageReader.getMinIndex());
                int n3 = imageReader.getHeight(imageReader.getMinIndex());
                Dimension dimension = new Dimension(n2, n3);
                return dimension;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Fehler beim Einlesen des Bildes: " + string, iOException);
            }
            finally {
                imageReader.dispose();
            }
        }
        throw new RuntimeException("Kein bekanntes Bildformat: " + string);
    }

    public static boolean hasLandscapeFormat(String string) {
        double d;
        Dimension dimension = PictureHelper.getImageDimension(string);
        double d2 = dimension.getWidth();
        return d2 > (d = dimension.getHeight());
    }

    public static BufferedImage createThumbnail(String string, int n, int n2) {
        try {
            return PictureHelper.tryToCreateThumbnail(string, n, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Es trat beim Erzeugen eines Miniaturbildes eine Ausnmane auf.", iOException);
        }
    }

    private static BufferedImage tryToCreateThumbnail(String string, int n, int n2) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        File file = new File(string);
        bufferedImage.createGraphics().drawImage(ImageIO.read(file).getScaledInstance(n, n2, 4), 0, 0, null);
        return bufferedImage;
    }

    public static BufferedImage createThumbnailWithAspectRatio(String string, int n) {
        Dimension dimension = PictureHelper.getImageDimension(string);
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = Math.max(n2, n3);
        double d = (double)n4 / (double)n;
        int n5 = (int)((double)n2 / d);
        int n6 = (int)((double)n3 / d);
        if (n5 > n) {
            n5 = n;
        }
        if (n6 > n) {
            n6 = n;
        }
        return PictureHelper.createThumbnail(string, n5, n6);
    }
}

