/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.system.starter;

import de.duehl.basics.datetime.Timestamp;
import de.duehl.basics.io.FineFileWriter;
import de.duehl.basics.logging.Logger;
import de.duehl.basics.logging.NoLogger;
import de.duehl.basics.logic.ErrorHandler;
import de.duehl.basics.system.starter.Starter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CmdStarter
extends Starter {
    private boolean verbose = false;
    private String outputText = "";
    private String errorText = "";

    public CmdStarter(ErrorHandler errorHandler) {
        this(new NoLogger(), errorHandler);
    }

    public CmdStarter(Logger logger, ErrorHandler errorHandler) {
        super(logger, errorHandler);
    }

    public void verbose() {
        this.verbose = true;
    }

    public String runAndWait(String string, String string2, String string3) {
        this.log("Start, program = " + string + ", log = " + string2 + ", errorLog = " + string3);
        String[] stringArray = this.createProgramStartParametersWithCmd(string);
        Process process = this.startProccessViaParams(stringArray);
        if (null == process) {
            return "";
        }
        this.waitForProcessAndWriteStreams(process, string2, string3);
        this.log("Ende, program = " + string + ", log = " + string2 + ", errorLog = " + string3);
        return this.paramsToString(stringArray);
    }

    public String runWaitAndStoreOutAndErrInStarter(String string) {
        this.log("Start, program = " + string);
        String[] stringArray = this.createProgramStartParametersWithCmd(string);
        Process process = this.startProccessViaParams(stringArray);
        if (null == process) {
            return "";
        }
        this.waitForProcessAndStoreOutAndErrInStarter(process);
        this.log("Ende, program = " + string);
        return this.paramsToString(stringArray);
    }

    public String runAndWaitWithoutCmd(String string, String string2, String string3) {
        this.log("Start, program = " + string + ", log = " + string2 + ", errorLog = " + string3);
        String[] stringArray = this.createProgramStartParametersWithoutCmd(string);
        Process process = this.startProccessViaParams(stringArray);
        if (null == process) {
            return "";
        }
        this.waitForProcessAndWriteStreams(process, string2, string3);
        this.log("Ende, program = " + string + ", log = " + string2 + ", errorLog = " + string3);
        return this.paramsToString(stringArray);
    }

    public String runAndForget(String string) {
        this.log("Start, program = " + string);
        String[] stringArray = this.createProgramStartParametersWithCmd(string);
        Process process = this.startProccessViaParams(stringArray);
        if (null == process) {
            return "";
        }
        this.log("Ende, program = " + string);
        return this.paramsToString(stringArray);
    }

    public Process startRun(String string) {
        this.log("Start, program = " + string);
        String[] stringArray = this.createProgramStartParametersWithCmd(string);
        Process process = this.startProccessViaParams(stringArray);
        this.log("Ende, program = " + string);
        return process;
    }

    public Process startRunWithoutCmd(String ... stringArray) {
        this.log("Start, params = " + stringArray);
        Process process = this.startProccessViaParams(stringArray);
        this.log("Ende, params = " + stringArray);
        return process;
    }

    private String[] createProgramStartParametersWithCmd(String string) {
        String[] stringArray = new String[]{"cmd", "/c", string};
        return stringArray;
    }

    private String[] createProgramStartParametersWithoutCmd(String string) {
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    private Process startProccessViaParams(String[] stringArray) {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        return this.startProccessViaBuilder(processBuilder);
    }

    private Process startProccessViaBuilder(ProcessBuilder processBuilder) {
        try {
            return processBuilder.start();
        }
        catch (IOException iOException) {
            this.error.error("Es trat ein Fehler bei der Ausf\u00fchrung des Cmd-Prozesses auf.", iOException);
            return null;
        }
    }

    public void waitForProcessAndWriteStreams(Process process, String string, String string2) {
        this.log("Start, process = " + process + ", log = " + string + ", errorLog = " + string2);
        this.waitForProcess(process);
        if (0 != process.exitValue()) {
            return;
        }
        this.writeOutputStream(process, string);
        this.say("CmdStarter#waitForProcess der Prozess '" + process + "' STDOUT ermittelt.");
        this.writeErrorStream(process, string2);
        this.say("CmdStarter#waitForProcess der Prozess '" + process + "' STDERR ermittelt.");
        this.log("Ende, process = " + process + ", log = " + string + ", errorLog = " + string2);
    }

    public void waitForProcessAndStoreOutAndErrInStarter(Process process) {
        this.log("Start, process = " + process);
        this.waitForProcess(process);
        if (0 != process.exitValue()) {
            return;
        }
        this.storeInputStream(process);
        this.say("CmdStarter#waitForProcess der Prozess '" + process + "' STDOUT ermittelt.");
        this.storeErrorStream(process);
        this.say("CmdStarter#waitForProcess der Prozess '" + process + "' STDERR ermittelt.");
        this.log("Ende, process = " + process);
    }

    public void waitForProcess(Process process) {
        this.log("Start, process = " + process);
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.say("CmdStarter#waitForProcess der Prozess '" + process + "' wurde beendet.");
        this.log("Ende, process = " + process);
    }

    private void writeOutputStream(Process process, String string) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        FineFileWriter fineFileWriter = new FineFileWriter(string);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                fineFileWriter.writeln(string2);
            }
        }
        catch (IOException iOException) {
            this.error.error("Es trat ein Fehler bei der Ausf\u00fchrung des Cmd-Prozesses beim Ermitteln des Outputs auf.", iOException);
        }
        fineFileWriter.close();
    }

    private void writeErrorStream(Process process, String string) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        FineFileWriter fineFileWriter = new FineFileWriter(string);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                fineFileWriter.writeln(string2);
            }
        }
        catch (IOException iOException) {
            this.error.error("Es trat ein Fehler bei der Ausf\u00fchrung des Cmd-Prozesses beim Ermitteln des Fehler-Outputs auf.", iOException);
        }
        fineFileWriter.close();
    }

    private void storeInputStream(Process process) {
        this.outputText = this.storeStreamAsText(process.getInputStream());
    }

    private void storeErrorStream(Process process) {
        this.errorText = this.storeStreamAsText(process.getErrorStream());
    }

    private String storeStreamAsText(InputStream inputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
        }
        catch (IOException iOException) {
            this.error.error("Es trat ein Fehler bei der Ausf\u00fchrung des Cmd-Prozesses beim Ermitteln des Stroms auf.", iOException);
        }
        return stringBuilder.toString();
    }

    private void say(String string) {
        if (this.verbose) {
            System.out.println(Timestamp.actualTime() + " " + string);
        }
    }

    public String getOutputText() {
        return this.outputText;
    }

    public String getErrorText() {
        return this.errorText;
    }
}

