/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.html;

import de.duehl.basics.text.html.generation.HtmlBuilder;
import java.util.List;

public class HtmlTableCreator {
    private static final boolean SHOW_EMPTY_TABLE_HEAD = false;
    private final List<List<String>> tableRowCellTexts;
    private HtmlBuilder html;
    private int numberOfRows;
    private int numberOfColumns;
    private boolean useColors;
    private List<String> colorHexcodes;
    private int nextColorIndex;

    public HtmlTableCreator(List<List<String>> list) {
        this.tableRowCellTexts = list;
        this.useColors = false;
    }

    public void setColorHexcodes(List<String> list) {
        this.useColors = true;
        this.colorHexcodes = list;
        this.nextColorIndex = 0;
    }

    public void create() {
        this.checkStartConstraints();
        this.init();
        this.createHtmlTable();
        this.finaliseHtml();
    }

    private void checkStartConstraints() {
        this.checkWeHaveTheSameAmountOfTextsInEachRow();
    }

    private void checkWeHaveTheSameAmountOfTextsInEachRow() {
        if (this.tableRowCellTexts.isEmpty()) {
            throw new RuntimeException("Die Liste der Texte der Zeilen ist leer.");
        }
        List<String> list = this.tableRowCellTexts.get(0);
        int n = list.size();
        for (int i = 0; i < this.tableRowCellTexts.size(); ++i) {
            List<String> list2 = this.tableRowCellTexts.get(i);
            int n2 = list2.size();
            if (n2 == n) continue;
            throw new RuntimeException("Zwei Zeilen haben unterschiedlich viele Texte: " + n + " in der ersten Zeile und " + n2 + " in der " + (i + 1) + ". Zeile.");
        }
    }

    private void init() {
        this.initHtml();
        this.initNumberOfRows();
        this.initNumberOfColumns();
    }

    private void initHtml() {
        this.html = new HtmlBuilder();
        this.html.appendHtml5HeadWithOwnCssUtf8("Die extrahierte Tabelle");
    }

    private void initNumberOfRows() {
        this.numberOfRows = this.tableRowCellTexts.size();
    }

    private void initNumberOfColumns() {
        List<String> list = this.tableRowCellTexts.get(0);
        this.numberOfColumns = list.size();
    }

    private void createHtmlTable() {
        this.html.appendOpeningTableWithBorderWidth(2);
        for (int i = 0; i < this.numberOfRows; ++i) {
            List<String> list = this.tableRowCellTexts.get(i);
            this.html.appendOpeningTr();
            for (int j = 0; j < this.numberOfColumns; ++j) {
                String string = list.get(j);
                this.appendCellText(string);
            }
            this.html.appendClosingTr();
        }
        this.html.appendClosingTable();
    }

    private void appendCellText(String string) {
        this.html.appendOpeningTd();
        if (this.useColors) {
            String string2 = this.colorHexcodes.get(this.nextColorIndex);
            this.html.append("<span style=\"font-family: monospace; color: #" + string2 + "\">" + string + "</span>");
            this.switchToNextColorIndex();
        } else {
            this.html.appendPTT(string);
        }
        this.html.appendClosingTd();
    }

    private void switchToNextColorIndex() {
        ++this.nextColorIndex;
        if (this.nextColorIndex >= this.colorHexcodes.size()) {
            this.nextColorIndex = 0;
        }
    }

    private void finaliseHtml() {
        this.html.appendFoot();
    }

    public String getHtml() {
        return this.html.toString();
    }
}

