/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.html;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.debug.Assure;
import de.duehl.basics.text.Text;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class UrlHelper {
    private static final String HTTP = "http";

    public static String addHttpToUrlIfMissing(String string) {
        if (!string.contains(HTTP)) {
            return "http://" + string;
        }
        return string;
    }

    public static String concatUrlAndAdditional(String string, String string2) {
        boolean bl;
        boolean bl2 = string.endsWith("/") || string.endsWith("\\");
        boolean bl3 = bl = string2.startsWith("/") || string2.startsWith("\\");
        if (bl2 && bl) {
            String string3 = string.substring(0, string.length() - 1);
            return string3 + string2;
        }
        if (bl2 || bl) {
            return string + string2;
        }
        return string + "/" + string2;
    }

    public static boolean isLinkInLLinklist(String string, List<String> list) {
        for (String string2 : list) {
            if (!UrlHelper.areLinksEqual(string, string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean areLinksEqual(String string, String string2) {
        if (!string.contains("?") || !string2.contains("?")) {
            String string3 = string.toLowerCase();
            String string4 = string2.toLowerCase();
            return string3.equals(string4);
        }
        String string5 = UrlHelper.safelyLowerUrl(string);
        String string6 = UrlHelper.safelyLowerUrl(string2);
        return string5.equals(string6);
    }

    static String safelyLowerUrl(String string) {
        if (string.contains("?")) {
            int n = string.indexOf("?");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n);
            return string2.toLowerCase() + string3;
        }
        return string.toLowerCase();
    }

    public static String normalizeUrl(String string) {
        String string2 = string;
        String string3 = "";
        while (!string2.equals(string3)) {
            string3 = string2;
            string2 = string2.replace("/../", "/");
            string2 = string2.replace("/./", "/");
        }
        return string2;
    }

    public static boolean urlEndsWithHtml(String string) {
        return string.toLowerCase().endsWith(".html") || string.toLowerCase().endsWith(".htm");
    }

    public static boolean urlEndsWithHtmlOrPhp(String string) {
        return UrlHelper.urlEndsWithHtml(string) || string.toLowerCase().endsWith(".php");
    }

    public static boolean urlContainsOtherUrl(String string, String string2) {
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        return string3.contains(string4);
    }

    public static String determineBaseUrl(String string) {
        String string2 = string.toLowerCase();
        String string3 = ".php";
        List<String> list = CollectionsHelper.buildListFrom(".html", ".htm", string3);
        int n = -1;
        for (String string4 : list) {
            int n2 = string2.indexOf(string4);
            if (n2 < 0) continue;
            int n3 = string2.length();
            int n4 = string3.length();
            if (string4.equals(string3) && n3 > n2 + n4 && "?".equals(string2.substring(n2 + n4, n2 + n4 + 1)) || n != -1 && n <= n2) continue;
            n = n2;
        }
        if (n >= 0) {
            return UrlHelper.cutToBaseUrl(string, n);
        }
        return string;
    }

    private static String cutToBaseUrl(String string, int n) {
        String string2 = string.substring(0, n);
        int n2 = string2.lastIndexOf("/");
        if (n2 == -1) {
            return string;
        }
        string2 = string2.substring(0, n2 + 1);
        return string2;
    }

    public static void openLinkInBrowser(String string) {
        try {
            URI uRI = new URI(string);
            Desktop.getDesktop().browse(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String removeUrlStart(String string) {
        String string2 = string;
        if (string2.startsWith("http://")) {
            string2 = string2.substring("http://".length());
        }
        if (string2.startsWith("https://")) {
            string2 = string2.substring("https://".length());
        }
        if (string2.startsWith("www.")) {
            string2 = string2.substring("www.".length());
        }
        return string2;
    }

    public static String url2dirname(String string) {
        String string2 = string;
        string2 = UrlHelper.removeUrlStart(string2);
        string2 = Text.removeTrailingSlash(string2);
        string2 = string2.replaceAll("[^-0-9A-Za-z .]", "_");
        string2 = string2.replaceAll("__+", "_");
        return string2;
    }

    public static boolean areUrlsEqualEnoughForFrames(String string, String string2) {
        String string3;
        String string4 = UrlHelper.removeUrlStart(string);
        if (string4.startsWith(string3 = UrlHelper.removeUrlStart(string2)) || string3.startsWith(string4)) {
            return true;
        }
        List<String> list = UrlHelper.determineEqualParts(string4, string3);
        if (list.isEmpty()) {
            return false;
        }
        CollectionsHelper.sortStringListByLengthDescanding(list);
        String string5 = list.get(0);
        int n = string4.length();
        int n2 = string3.length();
        int n3 = Math.min(n, n2);
        int n4 = string5.length();
        return n4 > 2 && n4 >= n3 / 2;
    }

    private static List<String> determineEqualParts(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (int i = 0; i < string.length() - 1; ++i) {
            for (int j = string.length(); j > i; --j) {
                String string3 = string.substring(i, j);
                Assure.notEmpty(string3);
                if (!string2.contains(string3)) continue;
                arrayList.add(string3);
                continue block0;
            }
        }
        return arrayList;
    }

    public static String createCompareUrl(String string) {
        String string2 = UrlHelper.removeUrlStart(string);
        string2 = UrlHelper.normalizeUrl(string2);
        return string2;
    }
}

