/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.xml.generation;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.xml.NamedXmlParameter;
import java.util.ArrayList;
import java.util.List;

public class XmlBuilder {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    private static final int INDENTAION_DEPTH = 4;
    private final StringBuilder builder = new StringBuilder();
    private int indentationLevel = 0;
    private int lengthAtLastIncrease = 0;

    public int length() {
        return this.builder.length();
    }

    public XmlBuilder increaseIndentationLevel() {
        ++this.indentationLevel;
        this.lengthAtLastIncrease = this.length();
        return this;
    }

    public XmlBuilder decreaseIndentationLevel() {
        --this.indentationLevel;
        return this;
    }

    public XmlBuilder setIndentationLevelToZero() {
        this.setIndentationLevel(0);
        return this;
    }

    protected XmlBuilder setIndentationLevel(int n) {
        this.indentationLevel = n;
        return this;
    }

    protected int getLengthAtLastIncrease() {
        return this.lengthAtLastIncrease;
    }

    protected final XmlBuilder appendSpaces() {
        String string = Text.multipleString(" ", this.indentationLevel * 4);
        this.builder.append(string);
        return this;
    }

    public XmlBuilder clear() {
        this.builder.setLength(0);
        this.indentationLevel = 0;
        return this;
    }

    public XmlBuilder append(String string) {
        this.builder.append(string);
        return this;
    }

    public XmlBuilder appendIndented(String string) {
        this.appendSpaces();
        this.append(string);
        return this;
    }

    public XmlBuilder appendMultipleLines(String ... stringArray) {
        List<String> list = CollectionsHelper.stringArrayToList(stringArray);
        return this.appendMultipleLines(list);
    }

    public XmlBuilder appendMultipleLines(List<String> list) {
        for (String string : list) {
            this.appendLn(string);
        }
        return this;
    }

    public XmlBuilder append(int n) {
        this.builder.append(Integer.toString(n));
        return this;
    }

    public XmlBuilder appendIndented(int n) {
        this.appendSpaces();
        this.append(n);
        return this;
    }

    public XmlBuilder appendLn(String string) {
        if (!string.isEmpty()) {
            this.appendIndented(string);
        }
        this.appendLineBreak();
        return this;
    }

    public XmlBuilder appendLineBreak() {
        this.append(Text.LINE_BREAK);
        return this;
    }

    public XmlBuilder appendEmptyLine() {
        this.appendLn("");
        return this;
    }

    public XmlBuilder appendOpeningTag(String string) {
        this.appendSpaces();
        this.appendPureOpeningTag(string);
        this.appendLineBreak();
        this.increaseIndentationLevel();
        return this;
    }

    public XmlBuilder appendOpeningTagWithParameters(String string, String ... stringArray) {
        List<String> list = CollectionsHelper.stringArrayToList(stringArray);
        return this.appendOpeningTagWithParameters(string, list);
    }

    public XmlBuilder appendOpeningTagWithParameters(String string, List<String> list) {
        this.appendSpaces();
        this.appendPureOpeningTagWithParameters(string, list);
        this.appendLineBreak();
        this.increaseIndentationLevel();
        return this;
    }

    private void appendPureOpeningTagWithParameters(String string, List<String> list) {
        this.append("<");
        this.append(string);
        for (String string2 : list) {
            this.append(" ").append(string2);
        }
        this.append(">");
    }

    public void appendPureOpeningTagWithParameters(String string, NamedXmlParameter ... namedXmlParameterArray) {
        List<String> list = this.namedXmlParametersToNormalParameters(namedXmlParameterArray);
        this.appendPureOpeningTagWithParameters(string, list);
    }

    public XmlBuilder appendClosingTag(String string) {
        this.decreaseIndentationLevel();
        this.appendSpaces();
        this.appendPureClosingTag(string);
        this.appendLineBreak();
        return this;
    }

    public XmlBuilder appendOpeningTagWithParameters(String string, NamedXmlParameter ... namedXmlParameterArray) {
        List<String> list = this.namedXmlParametersToNormalParameters(namedXmlParameterArray);
        this.appendOpeningTagWithParameters(string, list);
        return this;
    }

    private List<String> namedXmlParametersToNormalParameters(NamedXmlParameter ... namedXmlParameterArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (NamedXmlParameter namedXmlParameter : namedXmlParameterArray) {
            arrayList.add(namedXmlParameter.toString());
        }
        return arrayList;
    }

    public XmlBuilder appendInTag(String string, double d) {
        this.appendInTag(string, Double.toString(d));
        return this;
    }

    public XmlBuilder appendInTag(String string, int n) {
        this.appendInTag(string, Integer.toString(n));
        return this;
    }

    public XmlBuilder appendInTag(String string, String string2) {
        this.appendSpaces();
        this.appendPureOpeningTag(string);
        this.append(string2);
        this.appendPureClosingTag(string);
        this.appendLineBreak();
        return this;
    }

    private void appendPureOpeningTag(String string) {
        this.append("<");
        this.append(string);
        this.append(">");
    }

    private void appendPureClosingTag(String string) {
        this.append("</");
        this.append(string);
        this.append(">");
    }

    public XmlBuilder appendInTag(String string, String string2, NamedXmlParameter ... namedXmlParameterArray) {
        this.appendSpaces();
        this.appendPureOpeningTagWithParameters(string, namedXmlParameterArray);
        this.append(string2);
        this.appendPureClosingTag(string);
        this.appendLineBreak();
        return this;
    }

    public boolean isEmpty() {
        return 0 == this.length();
    }

    public String toString() {
        return this.builder.toString();
    }

    public XmlBuilder appendCommentLine(String string) {
        this.appendSpaces();
        this.appendComment(string);
        this.appendLineBreak();
        return this;
    }

    public XmlBuilder appendComment(String string) {
        this.appendCommentStart();
        this.append(string);
        this.apendCommentEnd();
        return this;
    }

    private void appendCommentStart() {
        this.builder.append("<!-- ");
    }

    private void apendCommentEnd() {
        this.builder.append(" -->");
    }

    protected int indexOf(String string) {
        return this.builder.indexOf(string);
    }

    protected void insert(int n, String string) {
        this.builder.insert(n, string);
    }

    public XmlBuilder appendXmlHeader() {
        this.appendLn(XML_HEADER);
        this.appendEmptyLine();
        return this;
    }
}

