/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.version;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.HtmlTool;
import de.duehl.basics.version.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChangesBetweenVersionsCutter {
    private static final Version NO_VERSION_FOUND = new Version("0.0.0.0", "NO VERSION FOUND");
    private static final String VERSION_STRING = "<h2>Version ";
    private static final String FROM_STRING = " vom ";
    private static final String H2_END_STRING = "</h2>";
    private final Version actualVersion;
    private final Version lastVersion;
    private final List<String> changesLines;
    private final Map<Version, Integer> versionsAtLines;
    private final List<Version> orderedKeyset;

    public ChangesBetweenVersionsCutter(Version version, Version version2, String string) {
        this.actualVersion = version;
        this.lastVersion = version2;
        this.changesLines = Text.splitByLineBreaks(string);
        this.versionsAtLines = new HashMap<Version, Integer>();
        this.orderedKeyset = new ArrayList<Version>();
    }

    public String detectChangesBetweenVersions() {
        this.emptyCollections();
        this.detectVersionsAndLines();
        this.createOrderedKeysetForVersionsAtLines();
        List<Version> list = this.determineNewestAndOldestVersionsBetweenVersions();
        String string = this.cutHtmlForVersions(list);
        return this.cutComments(string);
    }

    private void emptyCollections() {
        this.versionsAtLines.clear();
        this.orderedKeyset.clear();
    }

    private void detectVersionsAndLines() {
        for (int i = 0; i < this.changesLines.size(); ++i) {
            String string = this.changesLines.get(i);
            if (!this.lineIsVersionHeader(string)) continue;
            Version version = this.detectVersionFromVersionHeader(string);
            this.versionsAtLines.put(version, i);
        }
    }

    private boolean lineIsVersionHeader(String string) {
        return string.trim().startsWith(VERSION_STRING);
    }

    private Version detectVersionFromVersionHeader(String string) {
        int n = string.indexOf(VERSION_STRING);
        int n2 = string.indexOf(FROM_STRING);
        int n3 = string.indexOf(H2_END_STRING);
        if (n == -1 || n2 == -1 || n3 == -1 || n2 <= n || n3 <= n2) {
            return NO_VERSION_FOUND;
        }
        String string2 = string.substring(n + VERSION_STRING.length(), n2);
        String string3 = string.substring(n2 + FROM_STRING.length(), n3);
        return new Version(string2, string3);
    }

    private void createOrderedKeysetForVersionsAtLines() {
        this.orderedKeyset.addAll(this.versionsAtLines.keySet());
        Collections.sort(this.orderedKeyset, new Comparator<Version>(){

            @Override
            public int compare(Version version, Version version2) {
                int n = ChangesBetweenVersionsCutter.this.versionsAtLines.get(version);
                int n2 = ChangesBetweenVersionsCutter.this.versionsAtLines.get(version2);
                return n - n2;
            }
        });
    }

    private List<Version> determineNewestAndOldestVersionsBetweenVersions() {
        Version version = NO_VERSION_FOUND;
        Version version2 = NO_VERSION_FOUND;
        for (Version version3 : this.orderedKeyset) {
            if (!version3.isNewerThan(this.lastVersion) || version3.isNewerThan(this.actualVersion)) continue;
            if (version == NO_VERSION_FOUND || version3.isNewerThan(version)) {
                version = version3;
            }
            if (version2 != NO_VERSION_FOUND && !version2.isNewerThan(version3)) continue;
            version2 = version3;
        }
        if (version == NO_VERSION_FOUND || version2 == NO_VERSION_FOUND) {
            return new ArrayList<Version>();
        }
        return CollectionsHelper.buildListFrom(version2, version);
    }

    private String cutHtmlForVersions(List<Version> list) {
        if (list.isEmpty()) {
            return "";
        }
        Version version = list.get(0);
        Version version2 = list.get(1);
        return this.cutHtmlForVersions(version, version2);
    }

    private String cutHtmlForVersions(Version version, Version version2) {
        Object object;
        int n = this.versionsAtLines.get(version2);
        int n2 = this.versionsAtLines.get(version);
        int n3 = this.orderedKeyset.indexOf(version);
        if (this.orderedKeyset.size() > n3 + 1) {
            object = this.orderedKeyset.get(n3 + 1);
            int n4 = this.versionsAtLines.get(object);
            n2 = n4 - 1;
        } else {
            object = "</body>";
            int n5 = Text.searchFirstLineIndexContainig(this.changesLines, (String)object);
            n2 = n5 == -1 ? this.changesLines.size() - 1 : n5 - 1;
        }
        object = this.changesLines.subList(n, n2 + 1);
        return Text.joinWithLineBreak(object) + Text.LINE_BREAK;
    }

    private String cutComments(String string) {
        String string2 = string;
        string2 = HtmlTool.removeComments(string2);
        return string2;
    }
}

