/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.persistance;

import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class SwingSessionManagerHelper {
    public static final Point NOT_INITIALISED_POINT = new Point(-1, -1);
    public static final Dimension NOT_INITIALISED_DIMENSION = new Dimension(-1, -1);
    private static final String COLORS_SEPARATOR = "#-#";

    public static String createPointStorageString(Point point) {
        return Integer.toString(point.x) + "#" + Integer.toString(point.y);
    }

    public static Point createPointFromStorageString(String string) {
        List<String> list = Text.splitBy(string, "#");
        if (list.size() != 2) {
            return NOT_INITIALISED_POINT;
        }
        String string2 = list.get(0);
        String string3 = list.get(1);
        if (NumberString.isDigitSequence(string2) && NumberString.isDigitSequence(string3)) {
            int n = NumberString.parseInt(string2);
            int n2 = NumberString.parseInt(string3);
            return new Point(n, n2);
        }
        return NOT_INITIALISED_POINT;
    }

    public static String createDimensionStorageString(Dimension dimension) {
        return Integer.toString(dimension.width) + "#" + Integer.toString(dimension.height);
    }

    public static Dimension createDimensionFromStorageString(String string) {
        List<String> list = Text.splitBy(string, "#");
        if (list.size() != 2) {
            return NOT_INITIALISED_DIMENSION;
        }
        String string2 = list.get(0);
        String string3 = list.get(1);
        if (NumberString.isDigitSequence(string2) && NumberString.isDigitSequence(string3)) {
            int n = NumberString.parseInt(string2);
            int n2 = NumberString.parseInt(string3);
            return new Dimension(n, n2);
        }
        return NOT_INITIALISED_DIMENSION;
    }

    public static String createColorStorageString(Color color) {
        return Integer.toString(color.getRed()) + "#" + Integer.toString(color.getGreen()) + "#" + Integer.toString(color.getBlue()) + "#" + Integer.toString(color.getAlpha());
    }

    public static Color createColorFromStorageString(String string) {
        List<String> list = Text.splitBy(string, "#");
        if (list.size() != 4) {
            return Color.WHITE;
        }
        String string2 = list.get(0);
        String string3 = list.get(1);
        String string4 = list.get(2);
        String string5 = list.get(3);
        if (NumberString.isDigitSequence(string2) && NumberString.isDigitSequence(string3) && NumberString.isDigitSequence(string4) && NumberString.isDigitSequence(string5)) {
            int n = NumberString.parseInt(string2);
            int n2 = NumberString.parseInt(string3);
            int n3 = NumberString.parseInt(string4);
            int n4 = NumberString.parseInt(string5);
            return new Color(n, n2, n3, n4);
        }
        return Color.WHITE;
    }

    public static String createColorsStorageString(List<Color> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Color color : list) {
            String string = SwingSessionManagerHelper.createColorStorageString(color);
            arrayList.add(string);
        }
        return Text.join(COLORS_SEPARATOR, arrayList);
    }

    public static List<Color> createColorsListFromStorageString(String string) {
        List<String> list = Text.splitBy(string, COLORS_SEPARATOR);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (String string2 : list) {
            Color color = SwingSessionManagerHelper.createColorFromStorageString(string2);
            arrayList.add(color);
        }
        return arrayList;
    }
}

