/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.text.html;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.HtmlTool;
import de.duehl.basics.text.html.Text2HtmlBasics;
import de.duehl.basics.text.html.data.RegExpMatch;
import de.duehl.swing.text.html.characteristic.OpticalTextPartCharacteristic;
import de.duehl.swing.text.html.data.HiddenMarkedHtmlPart;
import de.duehl.swing.ui.colors.ColorTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Text2HtmlBase {
    private static final String PLACEHOLDER_START = "[[###-";
    private static final String PLACEHOLDER_END = "-###]]";
    private static final String WRONG_BACKGROUND_COLOR = "lightred";
    private static final String HIGHLIGHT_BACKGROUND_COLOR = "lightyellow";
    public static final int STANDARD_HTML_FONT_SIZE = 20;
    private String text;
    private String originalText;
    private int htmlFontSize;
    private boolean useMonospacedFont;
    private boolean expandHighlightedToWholeWord;
    private boolean encodeHtmlAmpLtAndGt;
    private boolean encodeHtmlWithoutSpaces;
    private boolean markChanges;
    private String changesMarkSemanticPart;
    private boolean allowNestedSpans;
    private boolean collectAndReinsertHiddenParts;
    private final List<HiddenMarkedHtmlPart> allCollectedHiddenParts;
    private boolean searchTextsAroundLineBreaks;

    protected Text2HtmlBase() {
        this(20);
    }

    protected Text2HtmlBase(int n) {
        this.htmlFontSize = n;
        this.expandHighlightedToWholeWord = false;
        this.markChanges = false;
        this.changesMarkSemanticPart = "";
        this.allowNestedSpans = false;
        this.collectAndReinsertHiddenParts = false;
        this.allCollectedHiddenParts = new ArrayList<HiddenMarkedHtmlPart>();
        this.searchTextsAroundLineBreaks = false;
    }

    public final void setText(String string) {
        this.text = string;
        this.originalText = string;
    }

    protected final void setOnlyText(String string) {
        this.text = string;
    }

    public final String getText() {
        return this.text;
    }

    public final String getOriginalText() {
        return this.originalText;
    }

    protected final boolean textContains(String string) {
        return this.text.contains(string);
    }

    protected final int textIndexOf(String string) {
        return this.text.indexOf(string);
    }

    protected final int textIndexOf(String string, int n) {
        return this.text.indexOf(string, n);
    }

    protected final void expandHighlightedToWholeWord() {
        this.expandHighlightedToWholeWord = true;
    }

    protected final void collectAndReinsertHiddenParts() {
        this.collectAndReinsertHiddenParts = true;
    }

    protected final void handleAmpLtAndGt() {
        this.text = HtmlTool.encodeHtmlAmpLtAndGt(this.text);
        this.encodeHtmlAmpLtAndGt = true;
    }

    protected final void encodeHtmlWithoutSpaces() {
        this.text = Text2HtmlBase.encodeHtmlWithoutSpaces(this.text);
        this.encodeHtmlWithoutSpaces = true;
    }

    public static final String encodeHtmlWithoutSpaces(String string) {
        String string2 = HtmlTool.encodeHtmlWithoutSpaces(string);
        string2 = string2.replace("&apos;", "'");
        return string2;
    }

    public final void setHtmlFontSize(int n) {
        this.htmlFontSize = n;
    }

    public final void useMonospacedFont() {
        this.useMonospacedFont = true;
    }

    public final void allowNestedSpans() {
        this.allowNestedSpans = true;
    }

    public final void searchTextsAroundLineBreaks() {
        this.searchTextsAroundLineBreaks = true;
    }

    @Deprecated
    protected final void colorBold(String string, String string2) {
        OpticalTextPartCharacteristic opticalTextPartCharacteristic = new OpticalTextPartCharacteristic();
        opticalTextPartCharacteristic.setBold(true);
        opticalTextPartCharacteristic.setForegroundHexColor(string2);
        this.replaceInTextWithCharacteristics(string, opticalTextPartCharacteristic);
    }

    @Deprecated
    protected final void colorBoldAndWrong(String string, String string2) {
        this.colorBoldWithBackground(string, string2, ColorTool.getHexColorByName(WRONG_BACKGROUND_COLOR));
    }

    @Deprecated
    private void colorBoldWithBackground(String string, String string2, String string3) {
        OpticalTextPartCharacteristic opticalTextPartCharacteristic = new OpticalTextPartCharacteristic();
        opticalTextPartCharacteristic.setBold(true);
        opticalTextPartCharacteristic.setForegroundHexColor(string2);
        opticalTextPartCharacteristic.setBackgroundHexColor(string3);
        opticalTextPartCharacteristic.setUseBackgroundColor(true);
        this.replaceInTextWithCharacteristics(string, opticalTextPartCharacteristic);
    }

    @Deprecated
    protected final void colorBoldAndHighlighted(String string, String string2) {
        this.colorBoldWithBackground(string, string2, ColorTool.getHexColorByName(HIGHLIGHT_BACKGROUND_COLOR));
    }

    @Deprecated
    protected final void colorItalic(String string, String string2) {
        OpticalTextPartCharacteristic opticalTextPartCharacteristic = new OpticalTextPartCharacteristic();
        opticalTextPartCharacteristic.setItalic(true);
        opticalTextPartCharacteristic.setForegroundHexColor(string2);
        this.replaceInTextWithCharacteristics(string, opticalTextPartCharacteristic);
    }

    protected final void replaceInTextWithCharacteristics(List<String> list, OpticalTextPartCharacteristic opticalTextPartCharacteristic) {
        for (String string : list) {
            this.replaceInTextWithCharacteristics(string, opticalTextPartCharacteristic);
        }
    }

    protected final void replaceInTextWithCharacteristics(String string, OpticalTextPartCharacteristic opticalTextPartCharacteristic) {
        String string2 = opticalTextPartCharacteristic.createOpeningSpan();
        this.colorWithHandlingOfFuzziness(string, string2);
    }

    private void colorWithHandlingOfFuzziness(String string, String string2) {
        for (String string3 : this.createFuzzyListOfSearchStrings(string)) {
            this.color(string3, string2);
        }
    }

    protected List<String> createFuzzyListOfSearchStrings(String string) {
        return CollectionsHelper.buildListFrom(string);
    }

    private void color(String string, String string2) {
        if (!string.isBlank()) {
            this.colorNotBlankSearchString(string, string2);
        }
    }

    private void colorNotBlankSearchString(String string, String string2) {
        if (this.expandHighlightedToWholeWord && Text.containsOnlyWordChars(string)) {
            List<String> list = Text.getDistinctWordsContaining(this.originalText, string);
            CollectionsHelper.sortStringListByLengthDescanding(list);
            list = this.postProccessHighlightWords(list);
            for (String string3 : list) {
                this.reallyColorNotBlankSearchString(string3, string2);
            }
        } else if (this.searchTextsAroundLineBreaks) {
            this.reallyColorNotBlankSearchStringWithLineBreaks(string, string2);
        } else {
            this.reallyColorNotBlankSearchString(string, string2);
        }
    }

    private List<String> postProccessHighlightWords(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = this.postProccessHighlightWord(string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String postProccessHighlightWord(String string) {
        if (this.encodeHtmlAmpLtAndGt) {
            return HtmlTool.encodeHtmlAmpLtAndGt(string);
        }
        if (this.encodeHtmlWithoutSpaces) {
            return Text2HtmlBase.encodeHtmlWithoutSpaces(string);
        }
        return string;
    }

    private void reallyColorNotBlankSearchStringWithLineBreaks(String string, String string2) {
        List<RegExpMatch> list = this.determineRegExpMatches(string);
        this.makeStartsAndEndsNotOverlapping(list);
        this.sortByStartDescanding(list);
        this.replaceTextForAllRegExpMatches(list, string2);
    }

    private List<RegExpMatch> determineRegExpMatches(String string) {
        ArrayList<RegExpMatch> arrayList = new ArrayList<RegExpMatch>();
        String string2 = this.createSearchRegex(string);
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(this.text);
        while (matcher.find()) {
            String string3;
            int n = matcher.start();
            int n2 = matcher.end();
            String string4 = this.text.substring(0, n);
            if (!this.canWeColor(string4, string3 = this.text.substring(n2))) continue;
            RegExpMatch regExpMatch = new RegExpMatch(n, n2, matcher.group());
            arrayList.add(regExpMatch);
        }
        return arrayList;
    }

    private String createSearchRegex(String string) {
        List<String> list = Text.splitByWhitespace(string);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string2 : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("(?:\\s|<br/>)+");
            }
            stringBuilder.append(Pattern.quote(string2));
        }
        return stringBuilder.toString();
    }

    private void makeStartsAndEndsNotOverlapping(List<RegExpMatch> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size() - 1; ++i) {
            RegExpMatch regExpMatch = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                RegExpMatch regExpMatch2 = list.get(j);
                if (!this.overlap(regExpMatch, regExpMatch2)) continue;
                arrayList.add(j);
            }
        }
        Collections.reverse(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            list.remove(n);
        }
    }

    private boolean overlap(RegExpMatch regExpMatch, RegExpMatch regExpMatch2) {
        int n = regExpMatch.getStart();
        int n2 = regExpMatch.getEnd();
        int n3 = regExpMatch2.getStart();
        int n4 = regExpMatch2.getEnd();
        if (n >= n3 && n <= n4) {
            return true;
        }
        if (n3 >= n && n3 <= n2) {
            return true;
        }
        if (n <= n3 && n2 >= n4) {
            return true;
        }
        return n3 <= n && n4 >= n2;
    }

    private void sortByStartDescanding(List<RegExpMatch> list) {
        Collections.sort(list, new Comparator<RegExpMatch>(){

            @Override
            public int compare(RegExpMatch regExpMatch, RegExpMatch regExpMatch2) {
                return regExpMatch2.getStart() - regExpMatch.getStart();
            }
        });
    }

    private void replaceTextForAllRegExpMatches(List<RegExpMatch> list, String string) {
        for (RegExpMatch regExpMatch : list) {
            this.replaceTextForRegExpMatch(regExpMatch, string);
        }
    }

    private void replaceTextForRegExpMatch(RegExpMatch regExpMatch, String string) {
        String string2 = this.text.substring(0, regExpMatch.getStart());
        String string3 = this.text.substring(regExpMatch.getEnd());
        String string4 = this.getStartMark() + string + regExpMatch.getMatchedPart() + "</span>" + this.getEndMark();
        this.text = string2 + string4 + string3;
    }

    private void reallyColorNotBlankSearchString(String string, String string2) {
        List<Integer> list = Text.findAllPositionsWithoutOverlapping(string, this.text);
        CollectionsHelper.sortDescanding(list);
        for (int n : list) {
            String string3;
            String string4 = this.text.substring(0, n);
            if (!this.canWeColor(string4, string3 = this.text.substring(n + string.length()))) continue;
            String string5 = this.getStartMark() + string2 + string + "</span>" + this.getEndMark();
            this.text = string4 + string5 + string3;
        }
    }

    private boolean canWeColor(String string, String string2) {
        if (Text.endsWithRegex(string, "color:.{0,2}")) {
            return false;
        }
        int n = string.lastIndexOf(PLACEHOLDER_START);
        int n2 = string.lastIndexOf(PLACEHOLDER_END);
        if (n > -1 && n > n2) {
            return false;
        }
        int n3 = string2.indexOf(PLACEHOLDER_START);
        int n4 = string2.indexOf(PLACEHOLDER_END);
        return n4 <= -1 || n4 >= n3;
    }

    private void reallyColorNotBlankSearchStringOld(String string, String string2) {
        String string3 = "(?s)(?<!color:.{0,2})(" + Pattern.quote(string) + ")";
        String string4 = this.getStartMark() + string2 + "$1</span>" + this.getEndMark();
        this.text = this.text.replaceAll(string3, string4);
    }

    protected final void replaceNumberWithDifferentSpacesInTextWithCharacteristics(String string, OpticalTextPartCharacteristic opticalTextPartCharacteristic) {
        String string2 = opticalTextPartCharacteristic.createOpeningSpan();
        for (String string3 : Text.searchNumberWithDifferentSpacesInText(string, this.getText())) {
            this.color(string3, string2);
        }
    }

    protected final void finalizeHtmlText() {
        if (this.collectAndReinsertHiddenParts) {
            this.reinsertHiddenMarkedParts(this.allCollectedHiddenParts);
        }
        if (!this.allowNestedSpans) {
            this.text = Text2HtmlBasics.removeNestedSpans(this.text);
        }
        this.text = Text2HtmlBasics.surroundTextWithFontSize(this.text, this.htmlFontSize);
        this.text = this.useMonospacedFont ? Text2HtmlBasics.surroundTextWithHtmlWithMonospacedFont(this.text) : Text2HtmlBasics.surroundTextWithHtml(this.text);
    }

    protected final List<HiddenMarkedHtmlPart> replaceInTextWithCharacteristicsAndHide(List<String> list, OpticalTextPartCharacteristic opticalTextPartCharacteristic, String string, String string2) {
        ArrayList<HiddenMarkedHtmlPart> arrayList = new ArrayList<HiddenMarkedHtmlPart>();
        int n = 0;
        for (String string3 : list) {
            this.startMarkChanges(string + "-" + ++n);
            this.replaceInTextWithCharacteristics(string3, opticalTextPartCharacteristic);
            List<HiddenMarkedHtmlPart> list2 = this.hideMarkedParts(string2 + "-" + n);
            arrayList.addAll(list2);
            this.endMarkChanges();
        }
        this.allCollectedHiddenParts.addAll(arrayList);
        return arrayList;
    }

    protected final List<HiddenMarkedHtmlPart> replaceInTextWithCharacteristicsAndHide(String string, OpticalTextPartCharacteristic opticalTextPartCharacteristic, String string2, String string3) {
        this.startMarkChanges(string2);
        this.replaceInTextWithCharacteristics(string, opticalTextPartCharacteristic);
        List<HiddenMarkedHtmlPart> list = this.hideMarkedParts(string3);
        this.endMarkChanges();
        this.allCollectedHiddenParts.addAll(list);
        return list;
    }

    protected final void startMarkChanges(String string) {
        this.markChanges = true;
        this.changesMarkSemanticPart = string;
    }

    protected final void endMarkChanges() {
        this.markChanges = false;
        this.changesMarkSemanticPart = "";
    }

    private final String getStartMark() {
        if (this.markChanges) {
            return "<!-- " + this.changesMarkSemanticPart + "-START -->";
        }
        return "";
    }

    private final String getEndMark() {
        if (this.markChanges) {
            return "<!-- " + this.changesMarkSemanticPart + "-END -->";
        }
        return "";
    }

    protected final List<HiddenMarkedHtmlPart> hideMarkedParts(String string) {
        ArrayList<HiddenMarkedHtmlPart> arrayList = new ArrayList<HiddenMarkedHtmlPart>();
        boolean bl = true;
        int n = 0;
        while (bl) {
            int n2 = this.text.indexOf(this.getStartMark());
            if (n2 == -1) {
                bl = false;
                continue;
            }
            int n3 = this.text.indexOf(this.getEndMark(), n2 + 1);
            if (n3 == -1) {
                bl = false;
                continue;
            }
            int n4 = n2 + this.getStartMark().length();
            int n5 = n3;
            int n6 = n2;
            int n7 = n3 + this.getEndMark().length();
            String string2 = this.text.substring(n4, n5);
            String string3 = PLACEHOLDER_START + string + "-" + ++n + PLACEHOLDER_END;
            this.text = Text.replaceInText(this.text, string3, n6, n7);
            HiddenMarkedHtmlPart hiddenMarkedHtmlPart = new HiddenMarkedHtmlPart(string2, string3);
            arrayList.add(hiddenMarkedHtmlPart);
        }
        return arrayList;
    }

    protected final void reinsertHiddenMarkedParts(List<HiddenMarkedHtmlPart> list) {
        for (HiddenMarkedHtmlPart hiddenMarkedHtmlPart : list) {
            String string = hiddenMarkedHtmlPart.getCutOut();
            String string2 = hiddenMarkedHtmlPart.getPlaceHolder();
            this.text = this.text.replace(string2, string);
        }
    }
}

