/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.colors;

import de.duehl.swing.ui.colors.ColorTranslator;
import de.duehl.swing.ui.colors.NamedColorListFabric;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class ColorTool {
    public static Color hexColorToJavaColor(String string) {
        return ColorTranslator.hex2Swing(string);
    }

    public static List<Color> hexColorListToJavaColorList(List<String> list) {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (String string : list) {
            Color color = ColorTool.hexColorToJavaColor(string);
            arrayList.add(color);
        }
        return arrayList;
    }

    public static String javaColorToHexColor(Color color) {
        return ColorTranslator.swing2Hex(color);
    }

    public static String rgbToHexColor(int n, int n2, int n3) {
        return ColorTranslator.rgbToHexColor(n, n2, n3);
    }

    public static Color anticolor(Color color) {
        int n = 255 - color.getRed();
        int n2 = 255 - color.getGreen();
        int n3 = 255 - color.getBlue();
        return new Color(n, n2, n3);
    }

    public static String anticolor(String string) {
        Color color = ColorTool.hexColorToJavaColor(string);
        Color color2 = ColorTool.anticolor(color);
        String string2 = ColorTool.javaColorToHexColor(color2);
        return string2;
    }

    public static Color calculateLighterColor(Color color) {
        return ColorTool.changeColor(color, 20);
    }

    public static Color calculateDarkerColor(Color color) {
        return ColorTool.changeColor(color, -20);
    }

    public static Color changeColor(Color color, int n) {
        return new Color(ColorTool.adjustRangeFrom0To255(color.getRed() + n), ColorTool.adjustRangeFrom0To255(color.getGreen() + n), ColorTool.adjustRangeFrom0To255(color.getBlue() + n));
    }

    private static int adjustRangeFrom0To255(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }

    public static Color changeColorMultiplicative(Color color, int n) {
        return new Color(ColorTool.adjustRangeFrom0To255Multiplicative(color.getRed(), n), ColorTool.adjustRangeFrom0To255Multiplicative(color.getGreen(), n), ColorTool.adjustRangeFrom0To255Multiplicative(color.getBlue(), n));
    }

    private static int adjustRangeFrom0To255Multiplicative(int n, int n2) {
        if (n2 >= 255) {
            return 255;
        }
        if (n2 < -255) {
            return 0;
        }
        double d = (double)n / 255.0;
        int n3 = 255 - Math.abs(n2);
        int n4 = (int)((double)n3 * d);
        if (n2 >= 0) {
            n4 += n2;
        }
        return n4;
    }

    public static String calculateLighterColor(String string) {
        return ColorTool.changeColor(string, 20);
    }

    public static String calculateDarkerColor(String string) {
        return ColorTool.changeColor(string, -20);
    }

    public static String changeColor(String string, int n) {
        Color color = ColorTool.hexColorToJavaColor(string);
        color = ColorTool.changeColor(color, n);
        return ColorTool.javaColorToHexColor(color);
    }

    public static Color orange() {
        return ColorTool.getColorByName("orange");
    }

    public static Color getColorByName(String string) {
        NamedColorListFabric namedColorListFabric = new NamedColorListFabric();
        return namedColorListFabric.getColorByName(string);
    }

    public static String getHexColorByName(String string) {
        NamedColorListFabric namedColorListFabric = new NamedColorListFabric();
        return namedColorListFabric.getHexColorByName(string);
    }
}

