/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections;

import de.duehl.basics.io.Charset;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CharsetSelection {
    private static final int VERTICAL_SPACE = 2;
    private ButtonGroup group = new ButtonGroup();
    private List<JRadioButton> charsetButtons = new ArrayList<JRadioButton>();
    private JPanel panel;

    public CharsetSelection(String string) {
        for (Charset charset : Charset.values()) {
            this.charsetButtons.add(new JRadioButton(charset.getCharsetAsString()));
        }
        this.select(Charset.UTF_8);
        this.panel = new JPanel();
        this.panel.setLayout(new VerticalLayout(2, 3));
        GuiTools.createTitle(string, this.panel);
        this.addToGroup();
        this.addToPanel();
    }

    private void addToGroup() {
        for (JRadioButton jRadioButton : this.charsetButtons) {
            this.group.add(jRadioButton);
        }
    }

    private void addToPanel() {
        for (JRadioButton jRadioButton : this.charsetButtons) {
            this.panel.add(jRadioButton);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void select(Charset charset) {
        String string = charset.getCharsetAsString();
        for (JRadioButton jRadioButton : this.charsetButtons) {
            String string2 = jRadioButton.getText();
            jRadioButton.setSelected(string2.equals(string));
        }
    }

    public Charset getSelected() {
        for (JRadioButton jRadioButton : this.charsetButtons) {
            if (!jRadioButton.isSelected()) continue;
            String string = jRadioButton.getText();
            return Charset.detectFromCharsetAsString(string);
        }
        throw new RuntimeException("Kein Button ausgew\u00e4hlt.");
    }

    public void setToolTipText(String string) {
        this.panel.setToolTipText(string);
        for (JRadioButton jRadioButton : this.charsetButtons) {
            jRadioButton.setToolTipText(string);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        for (JRadioButton jRadioButton : this.charsetButtons) {
            jRadioButton.addActionListener(actionListener);
        }
    }
}

