/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections.datetime;

import de.duehl.basics.datetime.DateAndTime;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.ImmutualTime;
import de.duehl.swing.ui.components.selections.StringSelection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;

public class SimpleDateAndTimeSelection {
    private static final Color IMPORTANT_FIELD_COLOR = new Color(255, 255, 180);
    private final StringSelection dateSelection = new StringSelection("Datum");
    private final StringSelection timeSelection = new StringSelection("Uhrzeit");
    private final JPanel panel;
    private String validityCheckFailedCause;

    public SimpleDateAndTimeSelection() {
        this.dateSelection.biggerText(7);
        this.dateSelection.setBackgroundColor(IMPORTANT_FIELD_COLOR);
        this.timeSelection.biggerText(7);
        this.timeSelection.setBackgroundColor(IMPORTANT_FIELD_COLOR);
        this.panel = this.createPanel();
    }

    public void addReturnListener(Runnable runnable) {
        this.dateSelection.addReturnListener(runnable);
        this.timeSelection.addReturnListener(runnable);
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.dateSelection.getPanel(), "North");
        jPanel.add((Component)this.timeSelection.getPanel(), "South");
        return jPanel;
    }

    public void initDate(String string) {
        this.dateSelection.setText(string);
    }

    public void initTime(String string) {
        this.timeSelection.setText(string);
    }

    public void initWithNow() {
        DateAndTime dateAndTime = new DateAndTime();
        this.initWithDateAndTime(dateAndTime);
    }

    public void initWithDateAndTime(DateAndTime dateAndTime) {
        String string = dateAndTime.getDate().toString();
        String string2 = dateAndTime.getTime().toString();
        this.initDate(string);
        this.initTime(string2);
    }

    public void initWithSmoothTimeInAbout10Minutes() {
        DateAndTime dateAndTime = new DateAndTime();
        int n = dateAndTime.getTime().getMinute();
        int n2 = 10 - n % 10;
        dateAndTime = n2 >= 5 ? dateAndTime.addMinutes(n2) : dateAndTime.addMinutes(n2 + 5);
        this.initWithDateAndTime(dateAndTime.setSecondsToZero());
    }

    public Component getPanel() {
        return this.panel;
    }

    public String getDate() {
        return this.dateSelection.getTrimmedText().strip();
    }

    public String getTime() {
        return this.timeSelection.getTrimmedText().strip();
    }

    public boolean checkValidity() {
        this.validityCheckFailedCause = "";
        String string = this.getDate();
        String string2 = this.getTime();
        ImmutualDate immutualDate = new ImmutualDate(string);
        if (!immutualDate.isValid()) {
            this.validityCheckFailedCause = "Datumswert nicht valide";
            return false;
        }
        try {
            new ImmutualTime(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.validityCheckFailedCause = illegalArgumentException.getMessage();
            return false;
        }
        return true;
    }

    public String getValidityCheckFailedCause() {
        return this.validityCheckFailedCause;
    }

    public DateAndTime getDateAndTime() {
        if (this.checkValidity()) {
            String string = this.getDate();
            String string2 = this.getTime();
            ImmutualDate immutualDate = new ImmutualDate(string);
            ImmutualTime immutualTime = new ImmutualTime(string2);
            return new DateAndTime(immutualDate, immutualTime);
        }
        throw new RuntimeException("Erst die Validit\u00e4t pr\u00fcfen! - " + this.validityCheckFailedCause);
    }
}

