/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.box;

import de.duehl.swing.ui.elements.box.BoxSelectionChangeObservable;
import de.duehl.swing.ui.elements.box.BoxSelectionChangeObserver;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;

public class ObservableComboBox<T>
implements BoxSelectionChangeObservable<T> {
    private final JComboBox<T> box = new JComboBox();
    private final ItemListener boxItemListener = this.createBoxItemListener();
    private final List<BoxSelectionChangeObserver<T>> observers = new ArrayList<BoxSelectionChangeObserver<T>>();

    public void setEditable(boolean bl) {
        this.box.setEditable(bl);
    }

    private ItemListener createBoxItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ObservableComboBox.this.reactOnBoxSelection();
                }
            }
        };
    }

    private void reactOnBoxSelection() {
        T t = this.getSelected();
        for (BoxSelectionChangeObserver<T> boxSelectionChangeObserver : this.observers) {
            boxSelectionChangeObserver.boxSelectionChanged(t);
        }
    }

    public T getSelected() {
        Object object = this.box.getSelectedItem();
        return (T)object;
    }

    @Override
    public void addBoxSelectionChangeObserver(BoxSelectionChangeObserver<T> boxSelectionChangeObserver) {
        this.observers.add(boxSelectionChangeObserver);
    }

    @Override
    public void deleteBoxSelectionChangeObserver(BoxSelectionChangeObserver<T> boxSelectionChangeObserver) {
        this.observers.remove(boxSelectionChangeObserver);
    }

    public void setValues(List<T> list) {
        this.box.removeItemListener(this.boxItemListener);
        this.box.removeAllItems();
        for (T t : list) {
            this.box.addItem(t);
        }
        this.box.addItemListener(this.boxItemListener);
    }

    public void showValue(T t) {
        this.box.removeItemListener(this.boxItemListener);
        this.box.setSelectedItem(t);
        this.box.addItemListener(this.boxItemListener);
    }

    public Component getBox() {
        return this.box;
    }

    public void validate() {
        this.box.validate();
    }

    public void setPreferredSize(Dimension dimension) {
        this.box.setPreferredSize(dimension);
    }
}

