/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.pictures;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PictureCache {
    private static final int DEFAULT_CACHE_SIZE = Integer.MAX_VALUE;
    private final int cacheSize;
    private final List<String> knownFilenames;
    private final Map<String, BufferedImage> imageByFilename;

    public PictureCache() {
        this(Integer.MAX_VALUE);
    }

    public PictureCache(int n) {
        this.cacheSize = n;
        this.knownFilenames = new ArrayList<String>();
        this.imageByFilename = new HashMap<String, BufferedImage>();
    }

    public boolean isFilenameKnown(String string) {
        return this.knownFilenames.contains(string);
    }

    public BufferedImage load(String string) {
        return this.imageByFilename.get(string);
    }

    public void store(String string, BufferedImage bufferedImage) {
        if (this.knownFilenames.size() > this.cacheSize) {
            this.removeOldestPictureFromCache();
        }
        this.knownFilenames.add(string);
        this.imageByFilename.put(string, bufferedImage);
    }

    private void removeOldestPictureFromCache() {
        String string = this.knownFilenames.remove(0);
        this.imageByFilename.remove(string);
    }
}

