/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.progress;

import de.duehl.basics.system.SystemTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.elements.progress.StandardColoredProgressPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MultipleProgressDialog
extends ModalDialogBase {
    private static final int DIALOG_WIDTH = 800;
    private final List<String> identifiers;
    private final Map<String, StandardColoredProgressPanel> progressPanelMap;

    public MultipleProgressDialog(String string, Point point, Image image) {
        super(point, image, string);
        this.addClosingWindowListener(() -> {});
        this.identifiers = new ArrayList<String>();
        this.progressPanelMap = new HashMap<String, StandardColoredProgressPanel>();
    }

    public MultipleProgressDialog addProgress(String string) {
        if (this.identifiers.contains(string) || this.progressPanelMap.containsKey(string)) {
            throw new IllegalArgumentException("Der Indentifier 'identifier' ist bereits bekannt.");
        }
        this.identifiers.add(string);
        StandardColoredProgressPanel standardColoredProgressPanel = new StandardColoredProgressPanel();
        this.progressPanelMap.put(string, standardColoredProgressPanel);
        return this;
    }

    private StandardColoredProgressPanel getProgressPanel(String string) {
        if (!this.progressPanelMap.containsKey(string)) {
            throw new IllegalArgumentException("Der Indentifier 'identifier' ist unbekannt.");
        }
        return this.progressPanelMap.get(string);
    }

    public MultipleProgressDialog setProgressTitle(String string, String string2) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.setProgressTitle(string2);
        return this;
    }

    public MultipleProgressDialog setCountPrefix(String string, String string2) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.setCountPrefix(string2);
        return this;
    }

    public MultipleProgressDialog setTimerPrefix(String string, String string2) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.setTimerPrefix(string2);
        return this;
    }

    public MultipleProgressDialog setActualElementPrefix(String string, String string2) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.setActualElementPrefix(string2);
        return this;
    }

    public MultipleProgressDialog setActualElementPrefixBeforeStart(String string, String string2) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.setActualElementPrefixBeforeStart(string2);
        return this;
    }

    public MultipleProgressDialog setActualElementWhenDone(String string, String string2) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.setActualElementWhenDone(string2);
        return this;
    }

    public MultipleProgressDialog createProgressPanel(String string) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.createProgressPanel();
        return this;
    }

    public void createUi() {
        SwingUtilities.invokeLater(() -> this.createUiInEdt());
    }

    private void createUiInEdt() {
        this.fillDialog();
        this.setVisible(true);
    }

    @Override
    protected void populateDialog() {
        this.add(this.createDummyLabelForDialogWidth(), "North");
        this.add(this.createProgressBarsPart(), "Center");
    }

    private Component createDummyLabelForDialogWidth() {
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(800, 0));
        return jLabel;
    }

    private Component createProgressBarsPart() {
        JPanel jPanel = new JPanel();
        int n = Math.min(4, this.identifiers.size());
        jPanel.setLayout(new GridLayout(n, 0, 3, 3));
        for (String string : this.identifiers) {
            StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
            jPanel.add(standardColoredProgressPanel.getComponent());
        }
        return jPanel;
    }

    public void initNumberOfTasksToDo(String string, int n) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.initNumberOfTasksToDo(n);
    }

    public void startingWithTask(String string) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.startingWithTask();
    }

    public void aboutToExceuteOneTaskSoon(String string, String string2) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.aboutToExceuteOneTaskSoon(string2);
    }

    public void oneTaskDone(String string, String string2) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.oneTaskDone(string2);
    }

    public void quit(String string) {
        StandardColoredProgressPanel standardColoredProgressPanel = this.getProgressPanel(string);
        standardColoredProgressPanel.quit();
    }

    public void closeUi(String string) {
        if (string.equals(this.identifiers.get(this.identifiers.size() - 1))) {
            SystemTools.sleep(250L);
            SwingUtilities.invokeLater(() -> this.closeUiInEdt());
        }
    }

    private void closeUiInEdt() {
        this.closeDialog();
    }
}

