/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor.syntax;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.debug.Assure;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.highlightingeditor.syntax.HighlightingTokens;
import de.duehl.swing.ui.highlightingeditor.syntax.HighlightingType;
import de.duehl.swing.ui.highlightingeditor.syntax.data.TokenWithPosition;
import de.duehl.swing.ui.highlightingeditor.syntax.data.TokenWithStyleAndPosition;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class SyntaxHighlighting {
    private static final String DEFAULT_STYLE = "default";
    private static final String KEYWORDS_STYLE = "keywords";
    private static final String SYMBOLS_STYLE = "symbols";
    private static final String OTHER_STYLE = "other";
    private static final Color TEXT_COLOR = Color.BLACK;
    private static final char HIDE_CHAR = '#';
    private final HighlightingTokens keywords;
    private final HighlightingTokens symbols;
    private final List<HighlightingTokens> other;
    private String text;
    private StyledDocument styledDocument;
    private boolean markInWordParts;

    public SyntaxHighlighting(HighlightingType highlightingType, HighlightingType highlightingType2) {
        this.keywords = new HighlightingTokens(highlightingType);
        this.symbols = new HighlightingTokens(highlightingType2);
        this.other = new ArrayList<HighlightingTokens>();
    }

    public void addKeyword(String string) {
        this.keywords.addToken(string);
    }

    public void addSymbol(String string) {
        this.symbols.addToken(string);
    }

    public void addOtherHighlightingTokens(HighlightingTokens highlightingTokens) {
        this.other.add(highlightingTokens);
    }

    public void initStyles(StyledDocument styledDocument) {
        try {
            this.tryToInitStyles(styledDocument);
        }
        catch (Exception exception) {
            throw new RuntimeException("Es trat ein Fehler beim Initialisieren der Stile auf.", exception);
        }
    }

    private void tryToInitStyles(StyledDocument styledDocument) {
        this.styledDocument = styledDocument;
        Style style = this.createDefaultStyle();
        this.createKeywordsStyle(style);
        this.createSymolsStyle(style);
        this.createOtherStyles(style);
    }

    private Style createDefaultStyle() {
        Style style = StyleContext.getDefaultStyleContext().getStyle(DEFAULT_STYLE);
        Style style2 = this.styledDocument.addStyle(DEFAULT_STYLE, style);
        StyleConstants.setForeground(style2, TEXT_COLOR);
        return style2;
    }

    private void createKeywordsStyle(Style style) {
        this.createOneStyle(style, KEYWORDS_STYLE, this.keywords.getHighlightingType());
    }

    private void createSymolsStyle(Style style) {
        this.createOneStyle(style, SYMBOLS_STYLE, this.symbols.getHighlightingType());
    }

    private void createOtherStyles(Style style) {
        int n = 0;
        for (HighlightingTokens highlightingTokens : this.other) {
            HighlightingType highlightingType = highlightingTokens.getHighlightingType();
            String string = this.createOtherStyleName(++n);
            this.createOneStyle(style, string, highlightingType);
        }
    }

    private String createOtherStyleName(int n) {
        return "other_" + n;
    }

    private void createOneStyle(Style style, String string, HighlightingType highlightingType) {
        Style style2 = this.styledDocument.addStyle(string, style);
        Color color = highlightingType.getColor();
        StyleConstants.setForeground(style2, color);
        boolean bl = highlightingType.isBold();
        StyleConstants.setBold(style2, bl);
    }

    public void highlightText(String string, StyledDocument styledDocument) {
        try {
            this.tryToHighlightText(string, styledDocument);
        }
        catch (Exception exception) {
            throw new RuntimeException("Es trat ein Fehler beim Initialisieren der Stile auf.", exception);
        }
    }

    private void tryToHighlightText(String string, StyledDocument styledDocument) {
        this.text = string;
        this.styledDocument = styledDocument;
        this.clearDocument();
        List<TokenWithStyleAndPosition> list = this.generateTextParts();
        Collections.sort(list);
        for (TokenWithStyleAndPosition tokenWithStyleAndPosition : list) {
            String string2 = tokenWithStyleAndPosition.getText();
            String string3 = tokenWithStyleAndPosition.getStyle();
            this.addTextPart(string2, string3);
        }
    }

    private void clearDocument() {
        try {
            this.styledDocument.remove(0, this.styledDocument.getLength());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private List<TokenWithStyleAndPosition> generateTextParts() {
        ArrayList<TokenWithStyleAndPosition> arrayList = new ArrayList<TokenWithStyleAndPosition>();
        arrayList.addAll(this.generateKeywordsTextParts());
        arrayList.addAll(this.generateSymbolsTextParts());
        arrayList.addAll(this.generateOtherTextParts());
        arrayList.addAll(this.generateRegularTextParts());
        return arrayList;
    }

    private List<TokenWithStyleAndPosition> generateKeywordsTextParts() {
        return this.generateTextParts(this.keywords, KEYWORDS_STYLE);
    }

    private List<TokenWithStyleAndPosition> generateSymbolsTextParts() {
        return this.generateTextParts(this.symbols, SYMBOLS_STYLE);
    }

    private List<TokenWithStyleAndPosition> generateOtherTextParts() {
        ArrayList<TokenWithStyleAndPosition> arrayList = new ArrayList<TokenWithStyleAndPosition>();
        int n = 0;
        for (HighlightingTokens highlightingTokens : this.other) {
            String string = this.createOtherStyleName(++n);
            arrayList.addAll(this.generateTextParts(highlightingTokens, string));
        }
        return arrayList;
    }

    private List<TokenWithStyleAndPosition> generateRegularTextParts() {
        ArrayList<TokenWithStyleAndPosition> arrayList = new ArrayList<TokenWithStyleAndPosition>();
        int n = 0;
        boolean bl = true;
        while (bl) {
            TokenWithStyleAndPosition tokenWithStyleAndPosition;
            String string;
            int n2 = this.text.indexOf(35, n);
            if (n2 == -1) {
                bl = false;
                string = this.text.substring(n);
                if (string.isEmpty()) continue;
                tokenWithStyleAndPosition = new TokenWithStyleAndPosition(string, DEFAULT_STYLE, n);
                arrayList.add(tokenWithStyleAndPosition);
                continue;
            }
            string = this.text.substring(n, n2);
            tokenWithStyleAndPosition = new TokenWithStyleAndPosition(string, DEFAULT_STYLE, n);
            arrayList.add(tokenWithStyleAndPosition);
            String string2 = Character.toString('#');
            while (n2 + 1 < this.text.length() && this.text.substring(n2 + 1, n2 + 2).equals(string2)) {
                ++n2;
            }
            n = n2 + 1;
        }
        return arrayList;
    }

    private List<TokenWithStyleAndPosition> generateTextParts(HighlightingTokens highlightingTokens, String string) {
        List<String> list = this.getSortedTokens(highlightingTokens);
        this.markInWordParts = highlightingTokens.isMarkInWordParts();
        List<TokenWithPosition> list2 = this.findTokensInText(list);
        return this.createFoundTokenListWithStyle(list2, string);
    }

    private List<String> getSortedTokens(HighlightingTokens highlightingTokens) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(highlightingTokens.getTokens());
        CollectionsHelper.sortStringListByLengthDescanding(arrayList);
        return arrayList;
    }

    private List<TokenWithPosition> findTokensInText(List<String> list) {
        ArrayList<TokenWithPosition> arrayList = new ArrayList<TokenWithPosition>();
        for (String string : list) {
            arrayList.addAll(this.findOneTokenInText(string));
        }
        return arrayList;
    }

    private List<TokenWithPosition> findOneTokenInText(String string) {
        ArrayList<TokenWithPosition> arrayList = new ArrayList<TokenWithPosition>();
        int n = 0;
        boolean bl = true;
        while (bl) {
            int n2 = this.text.indexOf(string, n);
            if (n2 == -1) {
                bl = false;
                continue;
            }
            if (this.markInWordParts || this.checkPossibleFoundToken(string, n2)) {
                TokenWithPosition tokenWithPosition = new TokenWithPosition(string, n2);
                arrayList.add(tokenWithPosition);
                this.hideOneFoundTokenFromText(tokenWithPosition);
            }
            n = n2 + string.length();
        }
        return arrayList;
    }

    private boolean checkPossibleFoundToken(String string, int n) {
        return this.checkPossibleFoundTokenFront(n) && this.checkPossibleFoundTokenRear(n + string.length());
    }

    private boolean checkPossibleFoundTokenFront(int n) {
        if (n == 0) {
            return true;
        }
        String string = this.text.substring(n - 1, n);
        return this.charIsValidForTokenSeparation(string);
    }

    private boolean checkPossibleFoundTokenRear(int n) {
        if (n == this.text.length()) {
            return true;
        }
        String string = this.text.substring(n, n + 1);
        return this.charIsValidForTokenSeparation(string);
    }

    private boolean charIsValidForTokenSeparation(String string) {
        return !string.matches("[0-9a-z\u00e4\u00f6\u00fc\u00dfA-Z\u00c4\u00d6\u00dc_]");
    }

    private List<TokenWithStyleAndPosition> createFoundTokenListWithStyle(List<TokenWithPosition> list, String string) {
        ArrayList<TokenWithStyleAndPosition> arrayList = new ArrayList<TokenWithStyleAndPosition>();
        for (TokenWithPosition tokenWithPosition : list) {
            arrayList.add(new TokenWithStyleAndPosition(tokenWithPosition, string));
        }
        return arrayList;
    }

    private void hideOneFoundTokenFromText(TokenWithPosition tokenWithPosition) {
        int n = this.text.length();
        String string = tokenWithPosition.getText();
        int n2 = tokenWithPosition.getTextPosition();
        int n3 = string.length();
        int n4 = n2 + n3;
        this.text = Text.replaceInTextWithEqualLengthCharacterSequence(this.text, '#', n2, n4);
        int n5 = this.text.length();
        Assure.isEqual(n, n5);
    }

    private void addTextPart(String string, String string2) {
        try {
            Style style = this.styledDocument.getStyle(string2);
            Assure.notNull("Der Stil '" + string2 + "' wurde nicht gefunden! Das zugeh\u00f6rige Objekt aus dem Dokument", style);
            String string3 = string.replaceAll("\r?\n", "\n");
            this.styledDocument.insertString(this.styledDocument.getLength(), string3, style);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

