/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.key;

import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.key.KeyDefinition;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class KeyboardShortCutDialog
extends ModalDialogBase {
    private static final boolean SHOW_OUTPUT_AREA = false;
    private static final boolean CLOSE_AFTER_PRESSED = true;
    private final JTextArea keyboardInputArea;
    private final JTextArea outputArea;
    private KeyDefinition keyboardShortCut;

    public KeyboardShortCutDialog(Point point, Image image) {
        super(point, image, "Eingabe eines Keyboard-ShortCuts");
        this.setMinimumSize(500, 1);
        this.keyboardInputArea = new JTextArea();
        this.outputArea = new JTextArea();
        this.keyboardShortCut = KeyDefinition.NO_KEY_DEFINIED;
        this.initFields();
        this.fillDialog();
        this.keyboardInputArea.requestFocusInWindow();
    }

    private void initFields() {
        this.keyboardInputArea.setRows(5);
        this.keyboardInputArea.setColumns(40);
        this.keyboardInputArea.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                int n2 = keyEvent.getModifiersEx();
                KeyboardShortCutDialog.this.keyboardShortCut = new KeyDefinition(n, n2);
                KeyboardShortCutDialog.this.outputArea.append("PRESSED: " + KeyboardShortCutDialog.this.keyboardShortCut.toReadableString() + "\n");
                KeyboardShortCutDialog.this.outputArea.setCaretPosition(KeyboardShortCutDialog.this.outputArea.getText().length());
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                int n2 = keyEvent.getModifiersEx();
                KeyDefinition keyDefinition = new KeyDefinition(n, n2);
                KeyboardShortCutDialog.this.outputArea.append("RELEASED: " + keyDefinition.toReadableString() + "\n");
                KeyboardShortCutDialog.this.outputArea.setCaretPosition(KeyboardShortCutDialog.this.outputArea.getText().length());
                KeyboardShortCutDialog.this.closeDialog();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                int n2 = keyEvent.getModifiersEx();
                KeyDefinition keyDefinition = new KeyDefinition(n, n2);
                KeyboardShortCutDialog.this.outputArea.append("TYPED: " + keyDefinition.toReadableString() + "\n");
                KeyboardShortCutDialog.this.outputArea.setCaretPosition(KeyboardShortCutDialog.this.outputArea.getText().length());
            }
        });
        this.outputArea.setRows(15);
        this.outputArea.setColumns(40);
        this.outputArea.setEditable(false);
        this.outputArea.setBackground(Color.LIGHT_GRAY);
    }

    private String getLocation(KeyEvent keyEvent) {
        String string = "";
        switch (keyEvent.getKeyLocation()) {
            case 1: {
                string = "STANDARD";
                break;
            }
            case 2: {
                string = "LEFT";
                break;
            }
            case 3: {
                string = "RIGHT";
                break;
            }
            case 4: {
                string = "NUMPAD";
            }
        }
        return string;
    }

    @Override
    protected void populateDialog() {
        this.add(new JScrollPane(this.keyboardInputArea), "North");
    }

    public KeyDefinition getSelectedKeyDefinition() {
        return this.keyboardShortCut;
    }
}

