/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.resources;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconLoader {
    private final Map<String, String> pictureByIdentifier;
    private final Class<?> clazz;
    private final String programmImageIdentifier;

    public IconLoader(Class<?> clazz, String string) {
        this.clazz = clazz;
        this.programmImageIdentifier = string;
        this.pictureByIdentifier = new HashMap<String, String>();
    }

    public void addPictureIdentifier(String string, String string2) {
        this.pictureByIdentifier.put(string, string2);
    }

    public Icon loadIcon(String string) {
        URL uRL = this.getResource(string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon;
    }

    public Image loadProgramIconImage() {
        return this.loadImage(this.programmImageIdentifier);
    }

    public Image loadImage(String string) {
        URL uRL = this.getResource(string);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(uRL);
        return image;
    }

    private URL getResource(String string) {
        if (!this.pictureByIdentifier.containsKey(string)) {
            throw new RuntimeException("Das K\u00fcrzel '" + string + "' ist nicht bekannt!");
        }
        String string2 = this.pictureByIdentifier.get(string);
        URL uRL = this.clazz.getResource(string2);
        if (null == uRL) {
            throw new RuntimeException("Zum K\u00fcrzel '" + string + "' ist der Dateiname '" + string2 + "' hinterlegt. Zu diesem wurde aber keine Resource gefunden!");
        }
        return uRL;
    }
}

