/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.text;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.text.TextualComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTextArea;

public class TextComponent
implements TextualComponent {
    private final JTextArea textComponent = new JTextArea();

    public TextComponent() {
        this.initComponent();
    }

    private void initComponent() {
        this.textComponent.setWrapStyleWord(true);
        this.textComponent.setLineWrap(true);
        this.textComponent.setEditable(false);
    }

    @Override
    public void setText(String string) {
        this.textComponent.setText(string);
    }

    @Override
    public void setCaretPosition(int n) {
        this.textComponent.setCaretPosition(n);
    }

    @Override
    public int getTextLength() {
        return this.textComponent.getText().length();
    }

    @Override
    public void repaint() {
        this.textComponent.repaint();
        this.textComponent.validate();
    }

    @Override
    public void setPreferredSize(int n, int n2) {
        this.textComponent.setPreferredSize(new Dimension(n, n2));
    }

    @Override
    public void setColors(Colorizer colorizer) {
        if (colorizer != null) {
            colorizer.setColors(this.textComponent);
        }
    }

    @Override
    public Component getComponent() {
        return this.textComponent;
    }

    public void useMonoscpacedText() {
        GuiTools.setMonospacedFont(this.textComponent, 14);
    }

    public void setFontSize(int n) {
        GuiTools.setFontSize(this.textComponent, n);
    }

    public void biggerFont(int n) {
        GuiTools.biggerFont(this.textComponent, n);
    }

    public void setEditable(boolean bl) {
        this.textComponent.setEditable(bl);
    }

    public void useNoWordWrap() {
        this.textComponent.setLineWrap(false);
    }

    public String getText() {
        return this.textComponent.getText();
    }

    public void setBackground(Color color) {
        this.textComponent.setOpaque(true);
        this.textComponent.setBackground(color);
    }

    public void ignorePageUpAndPageDown() {
        GuiTools.ignorePageUpAndPageDownInComponent(this.textComponent);
    }

    public void ignoreUpAndDown() {
        GuiTools.ignoreUpAndDownInComponent(this.textComponent);
    }

    public void ignoreCtrlPos1AndCtrlEnd() {
        GuiTools.ignoreCtrlPos1AndCtrlEndInComponent(this.textComponent);
    }

    public void setRows(int n) {
        this.textComponent.setRows(n);
    }

    public void setColumns(int n) {
        this.textComponent.setColumns(n);
    }
}

