/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.twosidecommander.ui.list;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.twosidecommander.ui.data.ListDisplayerClickReactor;
import de.duehl.twosidecommander.ui.list.data.ListElementMoveReactor;
import de.duehl.twosidecommander.ui.list.element.ListElementDisplayer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public abstract class ListDisplayer
implements ListElementMoveReactor {
    private static final Color BOTTOM_LINE_BACKGROUND_COLOR = new Color(230, 230, 230);
    private static final int LIST_ELEMENT_DISTANCE = 0;
    private static final int PAGE_DELTA = 25;
    private final JPanel panel = new JPanel();
    private final List<ListElementDisplayer> listElementDisplayers;
    private final JScrollPane listScroll = GuiTools.addNotHorizontalScrollingScrollPane(this.panel);
    private ListElementDisplayer activeListElementDisplayer;
    private final List<ListElementDisplayer> selectedListElementDisplayer;
    private ListElementDisplayer storedActiveElementDisplayer;
    private int storedActiveElementDisplayerIndex;
    private int storedScrollValue;
    private ListDisplayerClickReactor listDisplayerClickReactor;
    private LongTimeProcessInformer longTimeProcessInformer;
    private boolean active = false;
    private ListDisplayer listDisplayerOnTheOtherSide;
    private boolean listDisplayerOnTheOtherSideSet;
    private final JLabel bottomLineLabel = new JLabel();

    public ListDisplayer() {
        this.listElementDisplayers = new ArrayList<ListElementDisplayer>();
        this.selectedListElementDisplayer = new ArrayList<ListElementDisplayer>();
        this.init();
    }

    private void init() {
        this.initPanel();
        this.initScroll();
        this.initBottomLineLabel();
    }

    private void initPanel() {
        this.panel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createTitle(this.panel);
    }

    private void initScroll() {
    }

    private void initBottomLineLabel() {
        GuiTools.biggerFont(this.bottomLineLabel, 1);
        this.bottomLineLabel.setOpaque(true);
        this.bottomLineLabel.setBackground(BOTTOM_LINE_BACKGROUND_COLOR);
        this.bottomLineLabel.setBorder(BorderFactory.createEmptyBorder(2, 15, 2, 15));
    }

    public void setListDisplayerClickReactor(ListDisplayerClickReactor listDisplayerClickReactor) {
        this.listDisplayerClickReactor = listDisplayerClickReactor;
    }

    public void setLongTimeProcessInformer(LongTimeProcessInformer longTimeProcessInformer) {
        this.longTimeProcessInformer = longTimeProcessInformer;
    }

    public final synchronized void readAndShowList() {
        this.longTimeProcessInformer.startLongTimeProcess("Lese Liste neu ein");
        this.selectedListElementDisplayer.clear();
        this.panel.removeAll();
        this.listElementDisplayers.clear();
        List<ListElementDisplayer> list = this.createElementDisplyersToShow();
        for (ListElementDisplayer listElementDisplayer : list) {
            this.addElementToPanel(listElementDisplayer);
        }
        this.scrollToTop();
        if (!list.isEmpty()) {
            this.activeListElementDisplayer = list.get(0);
        }
        this.adjustBottomLineText();
        this.longTimeProcessInformer.endLongTimeProcess();
        this.repaintPanel();
    }

    protected abstract List<ListElementDisplayer> createElementDisplyersToShow();

    private void addElementToPanel(ListElementDisplayer listElementDisplayer2) {
        listElementDisplayer2.setListElementDisplayerClickReactor(listElementDisplayer -> this.clickedOnListElement(listElementDisplayer));
        listElementDisplayer2.setListElementDisplayerShiftClickReactor(listElementDisplayer -> this.shiftClickedOnListElement(listElementDisplayer));
        this.panel.add(listElementDisplayer2.getPanel());
        this.listElementDisplayers.add(listElementDisplayer2);
    }

    private void adjustBottomLineText() {
        Object object;
        int n = this.listElementDisplayers.size();
        int n2 = this.selectedListElementDisplayer.size();
        if (n2 > 0) {
            if (n == 1) {
                object = "ein Element von einem Element";
            } else {
                String string = NumberString.germanPlural(n2, "Elemente", "Element");
                object = NumberString.taupu(n2) + " " + string + " von " + NumberString.taupu(n) + " Elementen";
            }
        } else {
            String string = NumberString.germanPlural(n, "Elemente", "Element");
            object = NumberString.taupu(n) + " " + string;
        }
        this.bottomLineLabel.setText((String)object);
    }

    private void clickedOnListElement(ListElementDisplayer listElementDisplayer) {
        this.activeListElementDisplayer = listElementDisplayer;
        boolean bl = this.selectedListElementDisplayer.contains(listElementDisplayer);
        this.selectedListElementDisplayer.clear();
        if (bl) {
            this.selectedListElementDisplayer.add(this.activeListElementDisplayer);
        }
        this.adjustBottomLineText();
        this.listDisplayerClickReactor.clickedOnList(this);
    }

    private void shiftClickedOnListElement(ListElementDisplayer listElementDisplayer) {
        int n;
        int n2;
        int n3 = this.listElementDisplayers.indexOf(listElementDisplayer);
        if (n3 <= (n2 = this.listElementDisplayers.indexOf(this.activeListElementDisplayer))) {
            var4_4 = n3;
            n = n2;
        } else {
            var4_4 = n2;
            n = n3;
        }
        for (int i = var4_4; i <= n; ++i) {
            ListElementDisplayer listElementDisplayer2 = this.listElementDisplayers.get(i);
            if (this.selectedListElementDisplayer.contains(listElementDisplayer2)) {
                if (listElementDisplayer2.equals(this.activeListElementDisplayer)) continue;
                this.selectedListElementDisplayer.remove(listElementDisplayer2);
                continue;
            }
            this.selectedListElementDisplayer.add(listElementDisplayer2);
        }
        this.adjustBottomLineText();
        this.activeListElementDisplayer = listElementDisplayer;
        this.listDisplayerClickReactor.clickedOnList(this);
    }

    public void insertPressed() {
        if (this.selectedListElementDisplayer.contains(this.activeListElementDisplayer)) {
            this.selectedListElementDisplayer.remove(this.activeListElementDisplayer);
        } else {
            this.selectedListElementDisplayer.add(this.activeListElementDisplayer);
        }
        this.adjustBottomLineText();
        this.showCorrectHighlighting();
    }

    public void selectAll() {
        this.selectedListElementDisplayer.clear();
        this.selectedListElementDisplayer.addAll(this.listElementDisplayers);
        this.adjustBottomLineText();
        this.showCorrectHighlighting();
    }

    public void deselectAll() {
        this.selectedListElementDisplayer.clear();
        this.adjustBottomLineText();
        this.showCorrectHighlighting();
    }

    private void repaintPanel() {
        this.panel.repaint();
        this.panel.validate();
        this.panel.invalidate();
        this.listScroll.repaint();
        this.listScroll.validate();
        this.listScroll.invalidate();
    }

    private void scrollToTop() {
        GuiTools.scrollScrollbarToMinimumLater(this.listScroll);
    }

    public final Component getComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.listScroll, "Center");
        jPanel.add(this.createBottomLineLabelPart(), "South");
        return jPanel;
    }

    private Component createBottomLineLabelPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.bottomLineLabel, "Center");
        return jPanel;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public final void showCorrectHighlighting() {
        if (this.active) {
            this.showActiveHighlighting();
        } else {
            this.showInactiveHighlighting();
        }
    }

    private final void showActiveHighlighting() {
        for (ListElementDisplayer listElementDisplayer : this.listElementDisplayers) {
            if (this.selectedListElementDisplayer.contains(listElementDisplayer)) {
                if (listElementDisplayer.equals(this.activeListElementDisplayer)) {
                    listElementDisplayer.showSelectedAndHighlighted();
                    continue;
                }
                listElementDisplayer.showSelected();
                continue;
            }
            if (listElementDisplayer.equals(this.activeListElementDisplayer)) {
                listElementDisplayer.showHighlighted();
                continue;
            }
            listElementDisplayer.showNormal();
        }
        this.repaintPanel();
    }

    private final void showInactiveHighlighting() {
        for (ListElementDisplayer listElementDisplayer : this.listElementDisplayers) {
            listElementDisplayer.showNormal();
        }
        this.repaintPanel();
    }

    public void up() {
        int n = this.listElementDisplayers.indexOf(this.activeListElementDisplayer);
        if (n > 0) {
            this.activeListElementDisplayer = this.listElementDisplayers.get(--n);
            this.showCorrectHighlighting();
            this.scrollToActiveListElement();
        }
    }

    public void down() {
        int n = this.listElementDisplayers.indexOf(this.activeListElementDisplayer);
        if (n != -1 && n < this.listElementDisplayers.size() - 1) {
            this.activeListElementDisplayer = this.listElementDisplayers.get(++n);
            this.showCorrectHighlighting();
            this.scrollToActiveListElement();
        }
    }

    public void home() {
        this.activeListElementDisplayer = this.listElementDisplayers.get(0);
        this.showCorrectHighlighting();
        this.scrollToActiveListElement();
    }

    public void end() {
        this.activeListElementDisplayer = this.listElementDisplayers.get(this.listElementDisplayers.size() - 1);
        this.showCorrectHighlighting();
        this.scrollToActiveListElement();
    }

    public void pageUp() {
        int n = this.listElementDisplayers.indexOf(this.activeListElementDisplayer);
        if (n > 0) {
            if ((n -= 25) < 0) {
                n = 0;
            }
            this.activeListElementDisplayer = this.listElementDisplayers.get(n);
            this.showCorrectHighlighting();
            this.scrollToActiveListElement();
        }
    }

    public void pageDown() {
        int n = this.listElementDisplayers.indexOf(this.activeListElementDisplayer);
        if (n != -1 && n < this.listElementDisplayers.size() - 1) {
            if ((n += 25) > this.listElementDisplayers.size() - 1) {
                n = this.listElementDisplayers.size() - 1;
            }
            this.activeListElementDisplayer = this.listElementDisplayers.get(n);
            this.showCorrectHighlighting();
            this.scrollToActiveListElement();
        }
    }

    private void storeBeforeListMofications() {
        this.storedActiveElementDisplayer = this.activeListElementDisplayer;
        this.storedActiveElementDisplayerIndex = this.listElementDisplayers.indexOf(this.activeListElementDisplayer);
        this.storedScrollValue = this.listScroll.getVerticalScrollBar().getValue();
    }

    private void resetToStoredValuesAfterListModifications() {
        int n;
        int n2;
        if (this.listElementDisplayers.contains(this.storedActiveElementDisplayer)) {
            this.activeListElementDisplayer = this.storedActiveElementDisplayer;
        } else if (this.storedActiveElementDisplayerIndex == -1) {
            if (!this.listElementDisplayers.isEmpty()) {
                this.activeListElementDisplayer = this.listElementDisplayers.get(0);
            }
        } else if (this.listElementDisplayers.isEmpty()) {
            this.activeListElementDisplayer = null;
        } else {
            n2 = this.listElementDisplayers.size() - 1;
            n = Math.min(this.storedActiveElementDisplayerIndex, n2);
            this.activeListElementDisplayer = this.listElementDisplayers.get(n);
        }
        n2 = this.listScroll.getVerticalScrollBar().getMaximum();
        n = Math.min(this.storedScrollValue, n2);
        SwingUtilities.invokeLater(() -> this.listScroll.getVerticalScrollBar().setValue(n));
    }

    public ListElementDisplayer getActiveElementDisplayer() {
        return this.activeListElementDisplayer;
    }

    public List<ListElementDisplayer> getSelectedListElementDisplayer() {
        ArrayList<ListElementDisplayer> arrayList = new ArrayList<ListElementDisplayer>();
        for (ListElementDisplayer listElementDisplayer : this.listElementDisplayers) {
            if (!this.selectedListElementDisplayer.contains(listElementDisplayer)) continue;
            arrayList.add(listElementDisplayer);
        }
        return arrayList;
    }

    public abstract boolean canAppend(ListElementDisplayer var1);

    public void append(List<ListElementDisplayer> list) {
        this.storeBeforeListMofications();
        this.appendImplmentation(list);
        this.readListEtc();
    }

    protected abstract void appendImplmentation(List<ListElementDisplayer> var1);

    public void removeFromActiveList(List<ListElementDisplayer> list) {
        this.storeBeforeListMofications();
        this.removeImplmentation(list);
        this.readListEtc();
    }

    protected abstract void removeImplmentation(List<ListElementDisplayer> var1);

    public abstract String getListDescription();

    public final void showMoveButtonsOnListElements(boolean bl) {
        for (ListElementDisplayer listElementDisplayer : this.listElementDisplayers) {
            listElementDisplayer.showMoveButtonsOnListElements(bl);
        }
    }

    @Override
    public boolean canListElementMoveUp(ListElementDisplayer listElementDisplayer) {
        int n = this.listElementDisplayers.indexOf(listElementDisplayer);
        return n > 0;
    }

    @Override
    public boolean canListElementMoveDown(ListElementDisplayer listElementDisplayer) {
        int n = this.listElementDisplayers.indexOf(listElementDisplayer);
        return n != -1 && n < this.listElementDisplayers.size() - 1;
    }

    @Override
    public void moveListElementToFirst(ListElementDisplayer listElementDisplayer) {
        this.storeBeforeListMofications();
        this.moveListElementToFirstInImplementation(listElementDisplayer);
        this.readListEtc();
        this.rereadInactiveListeWhenActiveListIsChangedAndTheSameListShown();
    }

    protected abstract void moveListElementToFirstInImplementation(ListElementDisplayer var1);

    @Override
    public void moveListElementUp(ListElementDisplayer listElementDisplayer) {
        this.storeBeforeListMofications();
        this.moveListElementUpInImplementation(listElementDisplayer);
        this.readListEtc();
        this.rereadInactiveListeWhenActiveListIsChangedAndTheSameListShown();
    }

    protected abstract void moveListElementUpInImplementation(ListElementDisplayer var1);

    @Override
    public void moveListElementDown(ListElementDisplayer listElementDisplayer) {
        this.storeBeforeListMofications();
        this.moveListElementDownInImplementation(listElementDisplayer);
        this.readListEtc();
        this.rereadInactiveListeWhenActiveListIsChangedAndTheSameListShown();
    }

    protected abstract void moveListElementDownInImplementation(ListElementDisplayer var1);

    @Override
    public void moveListElementToLast(ListElementDisplayer listElementDisplayer) {
        this.storeBeforeListMofications();
        this.moveListElementToLastInImplementation(listElementDisplayer);
        this.readListEtc();
        this.rereadInactiveListeWhenActiveListIsChangedAndTheSameListShown();
    }

    protected abstract void moveListElementToLastInImplementation(ListElementDisplayer var1);

    private void readListEtc() {
        boolean bl = this.active && !this.listElementDisplayers.isEmpty() && this.listElementDisplayers.get(0).showsMoveButtons();
        this.readListEtc(bl);
    }

    private void readListEtc(boolean bl) {
        this.readAndShowList();
        this.showMoveButtonsOnListElements(bl);
        this.initButtonColorsAndEnabled();
        this.resetToStoredValuesAfterListModifications();
        this.showCorrectHighlighting();
    }

    public void setListDisplayerOnTheOtherSide(ListDisplayer listDisplayer) {
        this.listDisplayerOnTheOtherSide = listDisplayer;
        this.listDisplayerOnTheOtherSideSet = true;
    }

    private void rereadInactiveListeWhenActiveListIsChangedAndTheSameListShown() {
        if (this.active && this.listDisplayerOnTheOtherSideSet) {
            this.listDisplayerOnTheOtherSide.storeBeforeListMofications();
            this.listDisplayerOnTheOtherSide.readListEtc(false);
        }
    }

    public void initButtonColorsAndEnabled() {
        for (ListElementDisplayer listElementDisplayer : this.listElementDisplayers) {
            listElementDisplayer.setUpAndDownButtonColorsAndEnabled();
        }
    }

    private void scrollToActiveListElement() {
        Rectangle rectangle = this.calculateActiveListElementRectangle();
        this.panel.scrollRectToVisible(rectangle);
    }

    private Rectangle calculateActiveListElementRectangle() {
        int n = this.listElementDisplayers.indexOf(this.activeListElementDisplayer);
        if (n != -1) {
            Object object;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                object = this.listElementDisplayers.get(i);
                JPanel jPanel = ((ListElementDisplayer)object).getPanel();
                n2 += jPanel.getHeight();
            }
            ListElementDisplayer listElementDisplayer = this.listElementDisplayers.get(n);
            object = listElementDisplayer.getPanel();
            int n3 = ((JComponent)object).getWidth();
            int n4 = ((JComponent)object).getHeight();
            return new Rectangle(0, n2, n3, n4);
        }
        return new Rectangle(0, 0, 0, 0);
    }
}

