/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.persistence;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.text.TextViewer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GrammarTableHeaderPersistenceHelper {
    public static final String GRAMMAR_TABLE_HEADER_OUTER_DIVIDER = "##;##";
    public static final String GRAMMAR_TABLE_HEADER_INNER_DIVIDER = "#;#";

    public static String createGrammarTableHeaderPesistenceString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(GRAMMAR_TABLE_HEADER_OUTER_DIVIDER);
            }
            stringBuilder.append(string).append(GRAMMAR_TABLE_HEADER_INNER_DIVIDER).append(string2);
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> createGrammarTableHeaderMapFormPersistenceString(String string) {
        List<String> list = Text.splitBy(string, GRAMMAR_TABLE_HEADER_OUTER_DIVIDER);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : list) {
            List<String> list2 = Text.splitBy(string2, GRAMMAR_TABLE_HEADER_INNER_DIVIDER);
            if (list2.size() == 2) {
                String string3 = list2.get(0);
                String string4 = list2.get(1);
                hashMap.put(string3, string4);
                continue;
            }
            System.err.println("Ein Persistence-String der \u00dcberschrften von Grammatik-Tabellen lie\u00df sich nicht am Trenner aufteilen:\n\tgrammarTableHeadersPersistenceString = " + string + "\n\tGRAMMAR_TABLE_HEADER_INNER_DIVIDER   = #;#\n\tpart                                 = " + string2 + "\n\tinnerParts                           = " + list2 + "\n");
            hashMap.clear();
            break;
        }
        return hashMap;
    }

    public static void checkForChangedMyForms(Map<String, String> map, String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : CollectionsHelper.getSortedMapStringIndices(map)) {
            if (list.contains(object2)) continue;
            arrayList.add(object2);
        }
        if (!arrayList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u00c4nderung bei " + string + ":\n\nDie folgenden von mir vorgegebenen Formen haben sich ge\u00e4ndert.\nDaher m\u00fcssen die von Ihnen eingetragenen Titel f\u00fcr die Spalten\nder erzeugten Grammatik-Tabellen wieder angepasst werden.\n\n");
            for (String string2 : arrayList) {
                String string3 = map.get(string2);
                stringBuilder.append("    Alter Text von mir: " + string2 + "\n");
                stringBuilder.append("    Ihr Spalten-Titel : " + string3 + "\n\n");
            }
            stringBuilder.append("Aus diesem Text kann Ihr Spalten-Titel herauskopiert werden,\num ihn der ver\u00e4nderten grammatikalischen Form von mir wieder\nzuzuweisen.\nDie Titel f\u00fcr grammatikalische Tabellen kann man mit F5 in den\nOptionen vergeben.");
            String string4 = stringBuilder.toString();
            TextViewer textViewer = new TextViewer("Ver\u00e4nderte grammatikalische Begriffe bei " + string);
            textViewer.setText(string4);
            textViewer.useMonoscpacedText();
            textViewer.biggerFont(5);
            textViewer.setVisible(true);
        }
    }
}

