/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.data.symbol;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.data.symbol.Kana;
import de.duehl.vocabulary.japanese.data.symbol.KanaSubType;
import java.util.ArrayList;
import java.util.List;

public enum Hiragana {
    A("\u3042", "a", KanaSubType.STANDARD),
    I("\u3044", "i", KanaSubType.STANDARD),
    U("\u3046", "u", KanaSubType.STANDARD),
    E("\u3048", "e", KanaSubType.STANDARD),
    O("\u304a", "o", KanaSubType.STANDARD),
    KA("\u304b", "ka", KanaSubType.STANDARD),
    KI("\u304d", "ki", KanaSubType.STANDARD),
    KU("\u304f", "ku", KanaSubType.STANDARD),
    KE("\u3051", "ke", KanaSubType.STANDARD),
    KO("\u3053", "ko", KanaSubType.STANDARD),
    SA("\u3055", "sa", KanaSubType.STANDARD),
    SHI("\u3057", "shi", KanaSubType.STANDARD),
    SU("\u3059", "su", KanaSubType.STANDARD),
    SE("\u305b", "se", KanaSubType.STANDARD),
    SO("\u305d", "so", KanaSubType.STANDARD),
    TA("\u305f", "ta", KanaSubType.STANDARD),
    CHI("\u3061", "chi", KanaSubType.STANDARD),
    TSU("\u3064", "tsu", KanaSubType.STANDARD),
    TE("\u3066", "te", KanaSubType.STANDARD),
    TO("\u3068", "to", KanaSubType.STANDARD),
    NA("\u306a", "na", KanaSubType.STANDARD),
    NI("\u306b", "ni", KanaSubType.STANDARD),
    NU("\u306c", "nu", KanaSubType.STANDARD),
    NE("\u306d", "ne", KanaSubType.STANDARD),
    NO("\u306e", "no", KanaSubType.STANDARD),
    HA("\u306f", "ha", KanaSubType.STANDARD),
    HI("\u3072", "hi", KanaSubType.STANDARD),
    FU("\u3075", "fu", KanaSubType.STANDARD),
    HE("\u3078", "he", KanaSubType.STANDARD),
    HO("\u307b", "ho", KanaSubType.STANDARD),
    MA("\u307e", "ma", KanaSubType.STANDARD),
    MI("\u307f", "mi", KanaSubType.STANDARD),
    MU("\u3080", "mu", KanaSubType.STANDARD),
    ME("\u3081", "me", KanaSubType.STANDARD),
    MO("\u3082", "mo", KanaSubType.STANDARD),
    YA("\u3084", "ya", KanaSubType.STANDARD),
    YU("\u3086", "yu", KanaSubType.STANDARD),
    YO("\u3088", "yo", KanaSubType.STANDARD),
    SMALL_YA("\u3083", "kleines ya", KanaSubType.SMALL),
    SMALL_YU("\u3085", "kleines yu", KanaSubType.SMALL),
    SMALL_YO("\u3087", "kleines yo", KanaSubType.SMALL),
    RA("\u3089", "ra", KanaSubType.STANDARD),
    RI("\u308a", "ri", KanaSubType.STANDARD),
    RU("\u308b", "ru", KanaSubType.STANDARD),
    RE("\u308c", "re", KanaSubType.STANDARD),
    RO("\u308d", "ro", KanaSubType.STANDARD),
    WA("\u308f", "wa", KanaSubType.STANDARD),
    WO("\u3092", "wo", KanaSubType.STANDARD),
    N("\u3093", "n", KanaSubType.STANDARD),
    GA("\u304c", "ga", KanaSubType.WITH_DAKUTEN),
    GI("\u304e", "gi", KanaSubType.WITH_DAKUTEN),
    GU("\u3050", "gu", KanaSubType.WITH_DAKUTEN),
    GE("\u3052", "ge", KanaSubType.WITH_DAKUTEN),
    GO("\u3054", "go", KanaSubType.WITH_DAKUTEN),
    ZA("\u3056", "za", KanaSubType.WITH_DAKUTEN),
    JI1("\u3058", "ji", KanaSubType.WITH_DAKUTEN),
    ZU1("\u305a", "zu", KanaSubType.WITH_DAKUTEN),
    ZE("\u305c", "ze", KanaSubType.WITH_DAKUTEN),
    ZO("\u305e", "zo", KanaSubType.WITH_DAKUTEN),
    DA("\u3060", "da", KanaSubType.WITH_DAKUTEN),
    JI2("\u3062", "ji", KanaSubType.WITH_DAKUTEN),
    ZU2("\u3065", "zu", KanaSubType.WITH_DAKUTEN),
    DE("\u3067", "de", KanaSubType.WITH_DAKUTEN),
    DO("\u3069", "do", KanaSubType.WITH_DAKUTEN),
    BA("\u3070", "ba", KanaSubType.WITH_DAKUTEN),
    BI("\u3073", "bi", KanaSubType.WITH_DAKUTEN),
    BU("\u3076", "bu", KanaSubType.WITH_DAKUTEN),
    BE("\u3079", "be", KanaSubType.WITH_DAKUTEN),
    BO("\u307c", "bo", KanaSubType.WITH_DAKUTEN),
    PA("\u3071", "pa", KanaSubType.WITH_HANDAKUTEN),
    PI("\u3074", "pi", KanaSubType.WITH_HANDAKUTEN),
    PU("\u3077", "pu", KanaSubType.WITH_HANDAKUTEN),
    PE("\u307a", "pe", KanaSubType.WITH_HANDAKUTEN),
    PO("\u307d", "po", KanaSubType.WITH_HANDAKUTEN),
    KYA("\u304d\u3083", "kya", KanaSubType.COMPOUND),
    KYU("\u304d\u3085", "kyu", KanaSubType.COMPOUND),
    KYO("\u304d\u3087", "kyo", KanaSubType.COMPOUND),
    SHA("\u3057\u3083", "sha", KanaSubType.COMPOUND),
    SHU("\u3057\u3085", "shu", KanaSubType.COMPOUND),
    SHO("\u3057\u3087", "sho", KanaSubType.COMPOUND),
    CHA("\u3061\u3083", "cha", KanaSubType.COMPOUND),
    CHU("\u3061\u3085", "chu", KanaSubType.COMPOUND),
    CHO("\u3061\u3087", "cho", KanaSubType.COMPOUND),
    NYA("\u306b\u3083", "nya", KanaSubType.COMPOUND),
    NYU("\u306b\u3085", "nyu", KanaSubType.COMPOUND),
    NYO("\u306b\u3087", "nyo", KanaSubType.COMPOUND),
    HYA("\u3072\u3083", "hya", KanaSubType.COMPOUND),
    HYU("\u3072\u3085", "hyu", KanaSubType.COMPOUND),
    HYO("\u3072\u3087", "hyo", KanaSubType.COMPOUND),
    MYA("\u307f\u3083", "mya", KanaSubType.COMPOUND),
    MYU("\u307f\u3085", "myu", KanaSubType.COMPOUND),
    MYO("\u307f\u3087", "myo", KanaSubType.COMPOUND),
    RYA("\u308a\u3083", "rya", KanaSubType.COMPOUND),
    RYU("\u308a\u3085", "ryu", KanaSubType.COMPOUND),
    RYO("\u308a\u3087", "ryo", KanaSubType.COMPOUND),
    GYA("\u304e\u3083", "gya", KanaSubType.COMPOUND_WITH_DAKUTEN),
    GYU("\u304e\u3085", "gyu", KanaSubType.COMPOUND_WITH_DAKUTEN),
    GYO("\u304e\u3087", "gyo", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JA1("\u3058\u3083", "ja", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JU1("\u3058\u3085", "ju", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JO1("\u3058\u3087", "jo", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JA2("\u3062\u3083", "ja", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JU2("\u3062\u3085", "ju", KanaSubType.COMPOUND_WITH_DAKUTEN),
    JO2("\u3062\u3087", "jo", KanaSubType.COMPOUND_WITH_DAKUTEN),
    BYA("\u3073\u3083", "bya", KanaSubType.COMPOUND_WITH_DAKUTEN),
    BYU("\u3073\u3085", "byu", KanaSubType.COMPOUND_WITH_DAKUTEN),
    BYO("\u3073\u3087", "byo", KanaSubType.COMPOUND_WITH_DAKUTEN),
    PYA("\u3074\u3083", "pya", KanaSubType.COMPOUND_WITH_HANDAKUTEN),
    PYU("\u3074\u3085", "pyu", KanaSubType.COMPOUND_WITH_HANDAKUTEN),
    PYO("\u3074\u3087", "pyo", KanaSubType.COMPOUND_WITH_HANDAKUTEN),
    LEHNWORT_WI("\u3094\u3043", "wi", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_FA("\u3075\u3041", "fa", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_TI("\u3066\u3043", "ti", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_DU("\u3069\u3045", "du", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_WE("\u3046\u3047", "we", KanaSubType.FOR_FOREIGN_WORDS),
    LEHNWORT_FO("\u3075\u3049", "fo", KanaSubType.FOR_FOREIGN_WORDS),
    SMALL_TSU("\u3063", "kleines tsu", KanaSubType.SMALL);

    private final String character;
    private final String hepburn;
    private final KanaSubType subType;

    private Hiragana(String string2, String string3, KanaSubType kanaSubType) {
        this.character = string2;
        this.hepburn = string3;
        this.subType = kanaSubType;
    }

    public String getCharacter() {
        return this.character;
    }

    public String getHepburn() {
        return this.hepburn;
    }

    public KanaSubType getSubType() {
        return this.subType;
    }

    public Kana toKana() {
        Kana kana = new Kana(this.character, this.hepburn);
        return kana;
    }

    public static List<String> getAllHiraganaAsStringList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Hiragana hiragana : Hiragana.values()) {
            arrayList.add(hiragana.getCharacter());
        }
        return arrayList;
    }

    public static boolean containsHiragana(String string) {
        return Text.contains(string, Hiragana.getAllHiraganaAsStringList());
    }

    public static boolean containsOnlyHiragana(String string) {
        if (string.isEmpty()) {
            return false;
        }
        List<String> list = Hiragana.getAllHiraganaAsStringList();
        for (String string2 : Text.textToCharactersList(string)) {
            if (list.contains(string2)) continue;
            return false;
        }
        return true;
    }

    public static int firstIndexOfHiragana(String string) {
        List<String> list = Hiragana.getAllHiraganaAsStringList();
        List<String> list2 = Text.textToCharactersList(string);
        for (int i = 0; i < list2.size(); ++i) {
            String string2 = list2.get(i);
            if (!list.contains(string2)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfHiragana(String string) {
        List<String> list = Hiragana.getAllHiraganaAsStringList();
        List<String> list2 = Text.textToCharactersList(string);
        for (int i = list2.size() - 1; i >= 0; --i) {
            String string2 = list2.get(i);
            if (!list.contains(string2)) continue;
            return i;
        }
        return -1;
    }

    public static List<Hiragana> getKanasWithSubtypes(KanaSubType ... kanaSubTypeArray) {
        return Hiragana.getKanasWithSubtypes(CollectionsHelper.arrayToList(kanaSubTypeArray));
    }

    public static List<Hiragana> getKanasWithSubtypes(List<KanaSubType> list) {
        ArrayList<Hiragana> arrayList = new ArrayList<Hiragana>();
        for (Hiragana hiragana : Hiragana.values()) {
            KanaSubType kanaSubType = hiragana.getSubType();
            if (!list.contains((Object)kanaSubType)) continue;
            arrayList.add(hiragana);
        }
        return arrayList;
    }

    public static int getNumberOfKnownHiragana() {
        return Hiragana.values().length;
    }

    public static int getNumberOfKnownStandardHiragana() {
        List<Hiragana> list = Hiragana.getKanasWithSubtypes(KanaSubType.STANDARD);
        return list.size();
    }

    public static List<Hiragana> getAHiragana() {
        return CollectionsHelper.buildListFrom(A, I, U, E, O);
    }

    public static List<Hiragana> getKaHiragana() {
        return CollectionsHelper.buildListFrom(KA, KI, KU, KE, KO);
    }

    public static List<Hiragana> getGaHiragana() {
        return CollectionsHelper.buildListFrom(GA, GI, GU, GE, GO);
    }

    public static List<Hiragana> getSaHiragana() {
        return CollectionsHelper.buildListFrom(SA, SHI, SU, SE, SO);
    }

    public static List<Hiragana> getZaHiragana() {
        return CollectionsHelper.buildListFrom(ZA, JI1, ZU1, ZE, ZO);
    }

    public static List<Hiragana> getTaHiragana() {
        return CollectionsHelper.buildListFrom(TA, CHI, TSU, TE, TO);
    }

    public static List<Hiragana> getDaHiragana() {
        return CollectionsHelper.buildListFrom(DA, JI2, ZU2, DE, DO);
    }

    public static List<Hiragana> getNaHiragana() {
        return CollectionsHelper.buildListFrom(NA, NI, NU, NE, NO);
    }

    public static List<Hiragana> getHaHiragana() {
        return CollectionsHelper.buildListFrom(HA, HI, FU, HE, HO);
    }

    public static List<Hiragana> getBaHiragana() {
        return CollectionsHelper.buildListFrom(BA, BI, BU, BE, BO);
    }

    public static List<Hiragana> getPaHiragana() {
        return CollectionsHelper.buildListFrom(PA, PI, PU, PE, PO);
    }

    public static List<Hiragana> getMaHiragana() {
        return CollectionsHelper.buildListFrom(MA, MI, MU, ME, MO);
    }

    public static List<Hiragana> getYaHiragana() {
        return CollectionsHelper.buildListFrom(YA, YU, YO);
    }

    public static List<Hiragana> getRaHiragana() {
        return CollectionsHelper.buildListFrom(RA, RI, RU, RE, RO);
    }

    public static List<Hiragana> getHiraganaEndingWithI() {
        return CollectionsHelper.buildListFrom(I, KI, SHI, CHI, NU, HI, MI, RI, GI, JI1, JI2, BI, PI);
    }

    public static List<Hiragana> getHiraganaEndingWithE() {
        return CollectionsHelper.buildListFrom(E, KE, SE, TE, NE, HE, ME, RE, GE, ZE, DE, BE, PE);
    }
}

