/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.grammar;

import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import java.util.ArrayList;
import java.util.List;

public class AdjectivePositivePresenceFinder {
    public static final Vocable NO_POSITIVE_PRESENCE_FOUND = new Vocable();

    public static Vocable determinePositivePresence(Vocable vocable, List<Vocabulary> list) {
        List<String> list2 = Text.findTextsBetweenJapaneseQuotes(vocable.getComment());
        if (list2.isEmpty()) {
            return NO_POSITIVE_PRESENCE_FOUND;
        }
        String string = vocable.getKanji();
        if (string.isEmpty()) {
            return NO_POSITIVE_PRESENCE_FOUND;
        }
        String string2 = string.substring(0, 1);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : list2) {
            if (!string3.startsWith(string2)) continue;
            arrayList.add(string3);
        }
        boolean bl = vocable.isIAdjective();
        boolean bl2 = vocable.isNaAdjective();
        if (!bl && !bl2) {
            return NO_POSITIVE_PRESENCE_FOUND;
        }
        List<Vocable> list3 = AdjectivePositivePresenceFinder.createListOfOtherAdjectives(vocable, list);
        for (Vocable vocable2 : list3) {
            String string4;
            if (!vocable2.isAdjectivInPositivePresence() || (!bl || !vocable2.isIAdjective()) && (!bl2 || !vocable2.isNaAdjective()) || !arrayList.contains(string4 = vocable2.getKanji())) continue;
            return vocable2;
        }
        return NO_POSITIVE_PRESENCE_FOUND;
    }

    private static List<Vocable> createListOfOtherAdjectives(Vocable vocable, List<Vocabulary> list) {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocabulary vocabulary : list) {
            for (Vocable vocable2 : vocabulary.getVocables()) {
                if (vocable2.equals(vocable) || !vocable2.isAdjective()) continue;
                arrayList.add(vocable2);
            }
        }
        return arrayList;
    }
}

