/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.ownlists;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.data.OwnListPersistanceData;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.io.OwnListReader;
import de.duehl.vocabulary.japanese.io.OwnListWriter;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.data.OwnListInGuiRefresher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class OwnLists {
    private static final String LIST_NAMES_FILENAME = FileHelper.concatPathes(OwnList.OWN_LIST_DIRECTORY, "vokabellisten.nam");
    private final List<Vocabulary> vocabularies;
    private final Map<String, Vocable> keyToVocable;
    private final InternalDataRequester requester;
    private final Options options;
    private final VocabularyTrainerGui gui;
    private final List<OwnList> ownLists;
    private List<String> searchWords;
    private List<String> partsOfSpeach;
    private OwnListInGuiRefresher ownListInGuiRefresher;
    public static final OwnList NO_OWN_LIST_FOUND = new OwnList("###NOT-FOUND-NAME###", "###NOT-FOUND-KATEGORY###", "###NOT-FOUND-SUBKATEGORY###", new ArrayList<Vocable>());

    public OwnLists(List<Vocabulary> list, Map<String, Vocable> map, InternalDataRequester internalDataRequester, Options options, VocabularyTrainerGui vocabularyTrainerGui) {
        this.vocabularies = list;
        this.keyToVocable = map;
        this.requester = internalDataRequester;
        this.options = options;
        this.gui = vocabularyTrainerGui;
        OwnList.createOwnListDirectoryIfNotExisting();
        this.ownLists = new ArrayList<OwnList>();
        this.readStoredOwnLists();
        this.determineSearchWords();
        this.determinePartsOfSpeach();
    }

    private void readStoredOwnLists() {
        this.ownLists.clear();
        if (FileHelper.isFile(LIST_NAMES_FILENAME)) {
            List<String> list = OwnLists.readOwnListNames();
            this.ownLists.addAll(this.readStoredOwnLists(list));
        }
    }

    public static List<String> readOwnListNames() {
        return FileHelper.readFileToList(LIST_NAMES_FILENAME, Charset.UTF_8);
    }

    private List<OwnList> readStoredOwnLists(List<String> list) {
        ArrayList<OwnList> arrayList = new ArrayList<OwnList>();
        for (String string : list) {
            OwnList ownList = this.readOwnList(string);
            arrayList.add(ownList);
        }
        return arrayList;
    }

    private OwnList readOwnList(String string) {
        OwnListReader ownListReader = new OwnListReader(string, this.keyToVocable);
        ownListReader.read();
        return ownListReader.getOwnList();
    }

    private void determineSearchWords() {
        this.searchWords = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                for (String string : vocable.getSearchWords()) {
                    if (string.isBlank() || this.searchWords.contains(string)) continue;
                    this.searchWords.add(string);
                }
            }
        }
        CollectionsHelper.sortBetterAlphabethical(this.searchWords);
    }

    private void determinePartsOfSpeach() {
        this.partsOfSpeach = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                for (String string : vocable.getPartsOfSpeech()) {
                    if (string.isBlank() || this.partsOfSpeach.contains(string)) continue;
                    this.partsOfSpeach.add(string);
                }
            }
        }
        CollectionsHelper.sortBetterAlphabethical(this.partsOfSpeach);
    }

    public void setOwnListInGuiRefresher(OwnListInGuiRefresher ownListInGuiRefresher) {
        this.ownListInGuiRefresher = ownListInGuiRefresher;
    }

    public synchronized void storeOwnLists() {
        new Thread(() -> this.storeOwnListsInOwnThread()).start();
    }

    private synchronized void storeOwnListsInOwnThread() {
        this.storeNames();
        this.storeLists();
    }

    private void storeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OwnList ownList : this.ownLists) {
            String string = ownList.getName();
            arrayList.add(string);
        }
        FileHelper.writeLinesToFile(arrayList, LIST_NAMES_FILENAME, Charset.UTF_8);
    }

    private void storeLists() {
        for (OwnList ownList : this.ownLists) {
            this.storeList(ownList);
        }
    }

    private void storeList(OwnList ownList) {
        OwnListWriter ownListWriter = new OwnListWriter(ownList, this.requester);
        ownListWriter.write();
    }

    public List<OwnList> getOwnLists() {
        return this.ownLists;
    }

    public boolean nameCheckOk(String string) {
        String string2 = Text.createJavaVariableName(string);
        return !string.isBlank() && !string2.isBlank() && !this.isNameKnown(string);
    }

    private boolean isNameKnown(String string) {
        for (OwnList ownList : this.ownLists) {
            String string2 = ownList.getName();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public OwnList createNewList(String string) {
        OwnList ownList = new OwnList(string, "Default", "Default", new ArrayList<Vocable>());
        this.ownLists.add(ownList);
        this.storeList(ownList);
        return ownList;
    }

    public void deleteOwnList(OwnList ownList) {
        String string = NumberString.taupu(ownList.getVocables().size());
        String string2 = "Soll die Vokabelliste wirklich gel\u00f6scht werden?";
        String string3 = "Wollen sie wirklich die Liste '" + ownList.getName() + "' mit " + string + " Vokabeln entfernen?\n\nSie wird auch von der Festplatte gel\u00f6scht!\n\nDie Vokabeln verbleiben in den Vokabularien, aber die Zusammenstellung in\nForm dieser Vokabelliste wird beim Best\u00e4tigen des Dialogs entfernt.";
        boolean bl = GuiTools.askUser(string2, string3);
        if (bl) {
            this.reallyDeleteOwnList(ownList);
        }
    }

    private void reallyDeleteOwnList(OwnList ownList) {
        int n = this.ownLists.indexOf(ownList);
        this.ownLists.remove(n);
        String string = ownList.determineFilename();
        FileHelper.deleteFileIfExistent(string);
    }

    public void importOwnList() {
        String string = GuiTools.openFile(this.options.getLastUsedOwnListImportExportDirectory(), OwnList.createFileFilter());
        if (!string.isEmpty()) {
            if (FileHelper.isFile(string)) {
                this.importExistingFile(string);
            } else {
                GuiTools.informUser("Datei nicht gefunden", "Die Datei '" + string + "' wurde nicht gefunden.\nDer Import wurde abgebrochen.");
            }
        }
    }

    private void importExistingFile(String string) {
        String string2 = GuiTools.askUserToEnterAStringValue("Bitte geben die den Namen ein", "Bitte geben sie den Namen f\u00fcr die zu importierende Liste ein", OwnList.createJavaFormOfNameFromFilename(string));
        if (this.isNameUsed(string2)) {
            GuiTools.informUser("Der Name geh\u00f6rt zu einer Liste", "Der Name '" + string2 + "' geh\u00f6rt zu einer bereits vorhandenen Liste.\nDer Import wurde abgebrochen.");
        } else {
            this.storeLastUsedImportExportDirectoryIntoOptions(string);
            this.reallyImportFile(string, string2);
        }
    }

    private boolean isNameUsed(String string) {
        OwnList ownList = this.findByName(string);
        return !ownList.equals(NO_OWN_LIST_FOUND);
    }

    public OwnList findByName(String string) {
        for (OwnList ownList : this.ownLists) {
            String string2 = ownList.getName();
            if (!string.equals(string2)) continue;
            return ownList;
        }
        return NO_OWN_LIST_FOUND;
    }

    private void reallyImportFile(String string, String string2) {
        String string3 = OwnList.determineFilename(string2);
        FileHelper.copyFile(string, string3);
        OwnList ownList = this.readOwnList(string2);
        this.ownLists.add(ownList);
        this.storeOwnLists();
    }

    public void deleteOwnListsOfGroup(String string) {
        if (string.isEmpty()) {
            throw new RuntimeException("Leere Gruppenanf\u00e4nge sind nicht zul\u00e4ssig, sonst w\u00fcrden alle eigenen Listen entfernt!");
        }
        ArrayList<OwnList> arrayList = new ArrayList<OwnList>();
        for (OwnList ownList : this.ownLists) {
            String string2 = ownList.getName();
            if (!string2.startsWith(string)) continue;
            arrayList.add(ownList);
        }
        for (OwnList ownList : arrayList) {
            this.reallyDeleteOwnList(ownList);
        }
    }

    public void importOwnListFromGroup(String string, String string2) {
        this.deleteOwnListByName(string2);
        this.reallyImportFile(string, string2);
    }

    private void deleteOwnListByName(String string) {
        OwnList ownList = this.findByName(string);
        if (!ownList.equals(NO_OWN_LIST_FOUND)) {
            this.ownLists.remove(ownList);
            String string2 = OwnList.determineFilename(string);
            FileHelper.deleteFile(string2);
        }
    }

    public void exportList(OwnList ownList) {
        String string = GuiTools.saveFileAsWithTitle("Wohin soll die Vokabelliste '" + ownList.getName() + "' exportiert werden?", null, this.options.getLastUsedOwnListImportExportDirectory(), OwnList.createFileFilter(), FileHelper.getBareName(ownList.determineFilename()));
        if (!string.isBlank()) {
            boolean bl = false;
            bl = FileHelper.exists(string) ? GuiTools.askUser("Die Datei existiert bereits.", "Die Datei '" + string + "' existiert bereits, soll sie \u00fcberschriben werden?") : true;
            if (bl) {
                this.reallyExportList(ownList, string);
                this.gui.setMessageLater("Exportiert: " + FileHelper.getBareName(string));
            }
        }
    }

    private void reallyExportList(OwnList ownList, String string) {
        String string2 = ownList.determineFilename();
        this.reallyExportList(string2, string);
    }

    private void reallyExportList(String string, String string2) {
        FileHelper.copyFile(string, string2);
        this.storeLastUsedImportExportDirectoryIntoOptions(string2);
    }

    private void storeLastUsedImportExportDirectoryIntoOptions(String string) {
        String string2 = FileHelper.getDirName(string);
        this.options.setLastUsedOwnListImportExportDirectory(string2);
    }

    public void exportAllOwnLists() {
        String string = GuiTools.saveDirectory(this.options.getLastUsedOwnListImportExportDirectory(), "In welches Verzeichnis sollen die Vokabellisten exportiert werden?", this.gui.getWindowAsComponent());
        if (!string.isBlank()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(LIST_NAMES_FILENAME);
            for (OwnList object : this.ownLists) {
                arrayList.add(object.determineFilename());
            }
            ArrayList arrayList2 = new ArrayList();
            for (String string2 : arrayList) {
                boolean bl = this.exportInDirectory(string2, string);
                if (!bl) continue;
                arrayList2.add(string2);
            }
            this.gui.setMessageLater(arrayList2.size() + " Dateien exportiert.");
        }
    }

    private boolean exportInDirectory(String string, String string2) {
        String string3 = FileHelper.getBareName(string);
        String string4 = FileHelper.concatPathes(string2, string3);
        boolean bl = false;
        bl = FileHelper.exists(string4) ? GuiTools.askUser("Die Datei existiert bereits.", "Die Datei '" + string4 + "' existiert bereits, soll sie \u00fcberschriben werden?") : true;
        if (bl) {
            this.reallyExportList(string, string4);
        }
        return bl;
    }

    public void renameListFile(String string, String string2) {
        String string3 = OwnList.determineFilename(string);
        String string4 = OwnList.determineFilename(string2);
        if (FileHelper.exists(string3)) {
            FileHelper.moveFile(string3, string4);
        }
    }

    public void saveAsList(List<Vocable> list, String string) {
        String string2 = string.startsWith("Erweiterte Suche") ? Text.firstCharToLowerCase("Erweiterte Suche") : "abgefragte Listen";
        OwnList ownList = new OwnList(string, string2, "Default", list);
        this.ownLists.add(ownList);
        this.storeOwnLists();
    }

    public void saveOptions() {
        this.gui.saveOptions();
    }

    public List<String> getSearchWords() {
        return this.searchWords;
    }

    public List<String> getPartsOfSpeach() {
        return this.partsOfSpeach;
    }

    public String createNotExistingName(String string) {
        Object object = "MUSS ICH LEIDER INITIALISIEREN";
        int n = 0;
        boolean bl = true;
        while (bl) {
            object = string + ++n;
            bl = this.isNameKnown((String)object);
        }
        return object;
    }

    public void setOrderAndStoreOwnLists(List<OwnList> list) {
        this.checkListIntegrity(list);
        this.ownLists.clear();
        this.ownLists.addAll(list);
        this.storeOwnLists();
    }

    private void checkListIntegrity(List<OwnList> list) {
        try {
            this.tryToCheckListIntegrity(list);
        }
        catch (Exception exception) {
            throw new RuntimeException("Es gab ein Problem beim aktualisieren der eigenen Listen nach Umsortierung: " + exception.getMessage());
        }
    }

    private void tryToCheckListIntegrity(List<OwnList> list) {
        CollectionsHelper.checkSizes(this.ownLists, list);
        CollectionsHelper.checkAllElementsOfFirstAreInSecond(this.ownLists, list);
        CollectionsHelper.checkAllElementsOfFirstAreInSecond(list, this.ownLists);
    }

    public List<OwnList> getOwnListsWithVocable(Vocable vocable) {
        ArrayList<OwnList> arrayList = new ArrayList<OwnList>();
        for (OwnList ownList : this.ownLists) {
            if (!ownList.getVocables().contains(vocable)) continue;
            arrayList.add(ownList);
        }
        return arrayList;
    }

    public List<String> findNamesOfListsWithVocable(Vocable vocable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OwnList ownList : this.getOwnListsWithVocable(vocable)) {
            String string = ownList.getName();
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<OwnList> findOwnListsWithCategoryAndSubCategory(String string, String string2) {
        ArrayList<OwnList> arrayList = new ArrayList<OwnList>();
        for (OwnList ownList : this.ownLists) {
            if (!string.equals(ownList.getCategory()) || !string2.equals(ownList.getSubCategory())) continue;
            arrayList.add(ownList);
        }
        return arrayList;
    }

    public static void sortListsByName(List<OwnList> list) {
        Collections.sort(list, new Comparator<OwnList>(){

            @Override
            public int compare(OwnList ownList, OwnList ownList2) {
                String string = ownList.getName();
                String string2 = ownList2.getName();
                return string.compareTo(string2);
            }
        });
    }

    public boolean containsOwnList(OwnListPersistanceData ownListPersistanceData) {
        String string = ownListPersistanceData.getCategory();
        String string2 = ownListPersistanceData.getSubCategory();
        String string3 = ownListPersistanceData.getName();
        for (OwnList ownList : this.ownLists) {
            if (!string.equals(ownList.getCategory()) || !string2.equals(ownList.getSubCategory()) || !string3.equals(ownList.getName())) continue;
            return true;
        }
        return false;
    }

    public void setCorrectForegroundColorOfVocabularyBarsInGui() {
        this.ownListInGuiRefresher.setCorrectForegroundColorOfVocabularyBarsLater();
    }

    public void actualizeOwnListsPartInGui() {
        this.ownListInGuiRefresher.actualizeOwnListsPart();
    }
}

