/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.symbol.kana.test;

import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.data.SingleUserInputHiraganaCheckResult;

public class HiraganaTestChecker {
    private final Hiragana hiragana;
    private final String hepburn;
    private String errorDescription;
    private boolean ok;
    private SingleUserInputHiraganaCheckResult result;

    public HiraganaTestChecker(Hiragana hiragana, String string) {
        this.hiragana = hiragana;
        this.hepburn = string;
    }

    public void check() {
        this.init();
        this.checkHepburn();
        this.createCheckResult();
    }

    private void init() {
        this.ok = true;
        this.errorDescription = "";
    }

    private void checkHepburn() {
        String string = this.hiragana.getHepburn();
        if (this.hepburn.equals(string)) {
            this.ok = true;
        } else {
            this.ok = false;
            this.addToErrorDescription("Hepburn: falsche Eingabe.\n");
        }
    }

    private void addToErrorDescription(String string) {
        this.errorDescription = this.addToText(this.errorDescription, string);
    }

    private String addToText(String string, String string2) {
        if (string.isBlank()) {
            return string2;
        }
        return string + string2;
    }

    private void createCheckResult() {
        this.result = new SingleUserInputHiraganaCheckResult(this.hiragana);
        this.result.setOk(this.ok);
        this.result.setErrorDescription(this.errorDescription);
    }

    public SingleUserInputHiraganaCheckResult getResult() {
        return this.result;
    }
}

