/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic.steps;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.startup.logic.steps.StartupStep;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;
import java.util.ArrayList;
import java.util.List;

public class Step02CheckVocabelIntegrety
extends StartupStep {
    private final List<Vocabulary> vocabularies;
    private List<String> doubleVocablesKanaTransltionMessages;
    private List<String> doubleVocablesKanaKanjiMessages;
    private List<String> vocablesWithEqualKanaAndKanjiMessages;
    private static final String ICHIDAN_VERB = "Ichidan verb";
    private static final String IRU_ERU_VERB = "\u3044\u308b/\u3048\u308b-Verb";
    public static final String GODAN_VERB = "Godan verb";
    private static final String AUSNAHME_VERB = "Unregelm\u00e4\u00dfiges Verb";
    private static final String KOPULA = "Kopula";
    private static final String COPULA = "Copula";
    private static final String SURU_VERB_COMMENT = "Suru verb";
    private static final String SURU_VERB_SEARCH_WORD = "Suru-Verb";
    public static final String NIDAN_VERB = "Nidan verb";
    public static final String YODAN_VERB = "Yodan verb";

    public Step02CheckVocabelIntegrety(String string, Options options, SplashScreenable splashScreenable, StopWatch stopWatch, List<Vocabulary> list) {
        super(string, options, splashScreenable, stopWatch);
        this.vocabularies = list;
    }

    @Override
    protected void runInternalStep() {
        this.checkForVocablesWithoutKanaOrTranslation();
        this.checkIfSomeVocablesCombinationsAreUnique();
        this.checkDoubleTranslationAtSameVocabe();
        this.checkEOrUInVocableFieldAussprache();
        this.checkIchidanVerbs();
        this.checkVerbBaseFormsWithoutGodanIchidanKopulaAndSuruVerb();
    }

    private void checkForVocablesWithoutKanaOrTranslation() {
        this.appendMessage("Pr\u00fcfe auf Vokabeln ohne Kanja oder \u00dcbersetzung ...");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            arrayList.addAll(this.checkForVocablesWithoutKanaOrTranslation(vocabulary));
        }
        if (!arrayList.isEmpty()) {
            this.errorsInStep(Text.joinWithLineBreak(arrayList));
        }
    }

    private List<String> checkForVocablesWithoutKanaOrTranslation(Vocabulary vocabulary) {
        List<Vocable> list = vocabulary.getVocables();
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable object : list) {
            if (!this.hasNoKanaAndTranslation(object)) continue;
            arrayList.add(object);
        }
        ArrayList arrayList2 = new ArrayList();
        if (!arrayList.isEmpty()) {
            arrayList2.add(vocabulary.getDescription() + ": Die folgenden Variablen werden entfernt, weil sie nicht vollst\u00e4ndig genug sind:");
            for (Vocable vocable : arrayList) {
                arrayList2.add(vocable.toNiceString(4));
                arrayList2.add("");
            }
        }
        return arrayList2;
    }

    private boolean hasNoKanaAndTranslation(Vocable vocable) {
        return vocable.getKana().isBlank() || vocable.getTranslations().isEmpty() || vocable.getTranslations().get(0).isBlank();
    }

    private void checkIfSomeVocablesCombinationsAreUnique() {
        this.appendMessage("Pr\u00fcfe die Vokabeln auf g\u00fcltigen Schl\u00fcssel aus Kana + erste \u00dcbersetzung ...");
        this.doubleVocablesKanaTransltionMessages = new ArrayList<String>();
        this.doubleVocablesKanaKanjiMessages = new ArrayList<String>();
        this.vocablesWithEqualKanaAndKanjiMessages = new ArrayList<String>();
        List<Vocable> list = this.createAllVocablesList();
        for (int i = 0; i < list.size() - 1; ++i) {
            Vocable object2 = list.get(i);
            for (int string = i + 1; string < list.size(); ++string) {
                Vocable vocable = list.get(string);
                this.checkIfVocablesAreUniqueWithKeyFromKanaAndFirstTranslations(object2, vocable);
                this.checkIfVocablesAreUniqueWithKanjiAndKana(object2, vocable);
            }
        }
        for (Vocable vocable : list) {
            this.checkIfVocableHasEqualKanaAndKanji(vocable);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (!this.doubleVocablesKanaTransltionMessages.isEmpty()) {
            arrayList.add("Es gibt Vokabeln, welche nach Kana und der ersten \u00dcbersetzung gleich sind:");
            arrayList.addAll(this.doubleVocablesKanaTransltionMessages);
        }
        if (!this.doubleVocablesKanaKanjiMessages.isEmpty()) {
            arrayList.add("Es gibt Vokabeln, welche nach Kana und Kanji gleich sind:");
            arrayList.addAll(this.doubleVocablesKanaKanjiMessages);
        }
        if (!this.vocablesWithEqualKanaAndKanjiMessages.isEmpty()) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add("Es gibt Vokabeln, welche identische Inhalte von Kana und Kanji haben:");
            arrayList3.addAll(this.vocablesWithEqualKanaAndKanjiMessages);
            if (this.options.isInformAboutEqualKanaAndKanjiAtStartup()) {
                arrayList.addAll(arrayList3);
            } else {
                arrayList2.addAll(arrayList3);
            }
        }
        if (!arrayList.isEmpty()) {
            this.errorsInStep(Text.joinWithLineBreak(arrayList));
        }
        if (!arrayList2.isEmpty()) {
            String string = Text.joinWithLineBreak(arrayList2);
            this.appendMessage(string);
            this.warningsInStep(string);
        }
    }

    private List<Vocable> createAllVocablesList() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocabulary vocabulary : this.vocabularies) {
            arrayList.addAll(vocabulary.getVocables());
        }
        return arrayList;
    }

    private void checkIfVocablesAreUniqueWithKeyFromKanaAndFirstTranslations(Vocable vocable, Vocable vocable2) {
        String string = vocable.getKana();
        String string2 = vocable2.getKana();
        String string3 = vocable.getTranslations().get(0);
        String string4 = vocable2.getTranslations().get(0);
        if (string.equals(string2) && string3.equals(string4)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(vocable.toNiceString(12)).append("\n");
            stringBuilder.append("    ").append("und").append("\n");
            stringBuilder.append(vocable2.toNiceString(12)).append("\n");
            this.doubleVocablesKanaTransltionMessages.add(stringBuilder.toString());
        }
    }

    private void checkIfVocablesAreUniqueWithKanjiAndKana(Vocable vocable, Vocable vocable2) {
        String string = vocable.getKana();
        String string2 = vocable2.getKana();
        String string3 = vocable.getKanji();
        String string4 = vocable2.getKanji();
        if (string.equals(string2) && string3.equals(string4)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(vocable.toNiceString(12)).append("\n");
            stringBuilder.append("    ").append("und").append("\n");
            stringBuilder.append(vocable2.toNiceString(12)).append("\n");
            this.doubleVocablesKanaKanjiMessages.add(stringBuilder.toString());
        }
    }

    private void checkIfVocableHasEqualKanaAndKanji(Vocable vocable) {
        String string;
        String string2 = vocable.getKana();
        if (string2.equals(string = vocable.getKanji())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(vocable.toNiceString(12)).append("\n");
            this.vocablesWithEqualKanaAndKanjiMessages.add(stringBuilder.toString());
        }
    }

    private void checkDoubleTranslationAtSameVocabe() {
        this.appendMessage("Pr\u00fcfe die Vokabeln auf doppelte \u00dcbersetzungen bei einer Vokabel ...");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                String string = this.checkDoubleTranslationAtSameVocabel(vocable);
                if (string.isBlank()) continue;
                arrayList.add(string + " (im Vokabular '" + vocabulary.getDescription() + "').");
            }
        }
        if (!arrayList.isEmpty()) {
            this.errorsInStep(Text.joinWithLineBreak(arrayList));
        }
    }

    private String checkDoubleTranslationAtSameVocabel(Vocable vocable) {
        List<String> list = CollectionsHelper.getNotDisjunktTexts(vocable.getTranslations());
        if (list.isEmpty()) {
            return "";
        }
        return "Zur Vokabel '" + vocable.getKanjiKanaRomajiWithJapaneseBraces() + "' gibt es mehrfach vorkommende \u00dcbersetzungen: '" + Text.join("', '", list) + "'";
    }

    private void checkEOrUInVocableFieldAussprache() {
        this.appendMessage("Pr\u00fcfe die Vokabeln auf 'e' oder 'u' in der Aussprache ...");
        if (this.options.isInformAboutEOrUInVocableFieldAusspracheAtStartup()) {
            this.reallyCheckEOrUInVocableFieldAussprache();
        }
    }

    private void reallyCheckEOrUInVocableFieldAussprache() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                String string = vocable.getPronunciation();
                if (!string.contains("e") && !string.contains("u")) continue;
                String string2 = "Die Vokabel '" + vocable.getKanjiKanaRomajiWithJapaneseBraces() + "' (im Vokabular '" + vocabulary.getDescription() + "' enth\u00e4lt 'e' oder 'u' in ihrer Aussprache: '" + string + "'.";
                arrayList.add(string2);
            }
        }
        if (!arrayList.isEmpty()) {
            this.errorsInStep(Text.joinWithLineBreak(arrayList));
        }
    }

    private void checkIchidanVerbs() {
        this.appendMessage("Pr\u00fcfe Ichidan-Verben, die nur \"Ichidan verb\" oder nur \"\u3044\u308b/\u3048\u308b-Verb\" enthalten, aber nicht beides ...");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.isVerbInWoerterbuchform()) continue;
                String string = vocable.getComment();
                boolean bl = string.contains(ICHIDAN_VERB);
                boolean bl2 = string.contains(IRU_ERU_VERB);
                String string2 = "";
                if (bl && !bl2) {
                    string2 = "enth\u00e4lt 'Ichidan verb' aber nicht '\u3044\u308b/\u3048\u308b-Verb'";
                } else if (!bl && bl2) {
                    string2 = "enth\u00e4lt '\u3044\u308b/\u3048\u308b-Verb' aber nicht 'Ichidan verb'";
                }
                if (string2.isBlank()) continue;
                String string3 = "    Die Vokabel " + vocable.getKanjiKanaRomajiWithJapaneseBraces() + " " + string2 + ".\n    Vokabular: " + vocable.getVocabularyDescription();
                arrayList.add(string3);
            }
        }
        if (!arrayList.isEmpty()) {
            arrayList.add(0, "Warnungen bei Ichidan-Verben in W\u00f6rterbuchform:");
            String string = Text.joinWithLineBreak(arrayList);
            this.appendMessage(string);
            this.warningsInStep(string);
        }
    }

    private void checkVerbBaseFormsWithoutGodanIchidanKopulaAndSuruVerb() {
        this.appendMessage("Pr\u00fcfe Verben in W\u00f6rterbuchform ohne \"Godan verb\", \"Ichidan verb\", \"Unregelm\u00e4\u00dfiges Verb\" und \"Kopula\" und \"Suru verb\" ...");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.isVerbInWoerterbuchform()) continue;
                String string = vocable.getComment();
                boolean bl = string.contains(GODAN_VERB);
                boolean bl2 = string.contains(ICHIDAN_VERB);
                boolean bl3 = string.contains(AUSNAHME_VERB);
                boolean bl4 = string.contains(KOPULA) || string.contains(COPULA);
                boolean bl5 = string.contains(SURU_VERB_COMMENT);
                boolean bl6 = string.contains(NIDAN_VERB);
                boolean bl7 = string.contains(YODAN_VERB);
                List<String> list = vocable.getSearchWords();
                boolean bl8 = list.contains(SURU_VERB_SEARCH_WORD);
                boolean bl9 = bl5 || bl8;
                String string2 = "";
                if (!(bl || bl2 || bl3 || bl4 || bl9 || bl6 || bl7)) {
                    string2 = "enth\u00e4lt weder 'Godan verb' noch 'Ichidan verb\" noch eine andere gepr\u00fcfte Verbform";
                }
                if (string2.isBlank()) continue;
                String string3 = "    Die Vokabel " + vocable.getKanjiKanaRomajiWithJapaneseBraces() + " " + string2 + ".\n    Vokabular: " + vocable.getVocabularyDescription();
                arrayList.add(string3);
            }
        }
        if (!arrayList.isEmpty()) {
            arrayList.add(0, "Warnungen bei Verben in W\u00f6rterbuchform:");
            String string = Text.joinWithLineBreak(arrayList);
            this.appendMessage(string);
            this.warningsInStep(string);
        }
    }

    private void checkBaseformVerbsEndingWithRuWithoutGodan() {
        this.appendMessage("Pr\u00fcfe Verben in W\u00f6rterbuchform die auf \u308b enden, aber nicht \"Godan verb\" enthalten...");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.isVerbInWoerterbuchform()) continue;
                String string = vocable.getKana();
                boolean bl = string.endsWith(Hiragana.RU.getCharacter());
                String string2 = vocable.getComment();
                boolean bl2 = string2.contains(GODAN_VERB);
                String string3 = "";
                if (!bl2 && bl) {
                    string3 = "enfdet auf \u308b, enth\u00e4lt aber kein 'Godan verb'";
                }
                if (string3.isBlank()) continue;
                String string4 = "    Die Vokabel " + vocable.getKanjiKanaRomajiWithJapaneseBraces() + " " + string3 + ".\n    Vokabular: " + vocable.getVocabularyDescription();
                arrayList.add(string4);
            }
        }
        if (!arrayList.isEmpty()) {
            arrayList.add(0, "Warnungen bei Verben in W\u00f6rterbuchform die auf \u308b enden:");
            String string = Text.joinWithLineBreak(arrayList);
            this.appendMessage(string);
            this.warningsInStep(string);
        }
    }
}

