/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.DateAndTimeHelper;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.system.SystemTools;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.HtmlTool;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.FontSizeChangable;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.menu.collection.tools.MyMenuItemCollectionHelper;
import de.duehl.swing.ui.text.TextViewer;
import de.duehl.swing.ui.text.html.HtmlDialog;
import de.duehl.vocabulary.japanese.VocabularyTrainerVersion;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.data.VocabularySortOrder;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;
import de.duehl.vocabulary.japanese.common.persistence.data.HistoricalOwnListPersistanceDataList;
import de.duehl.vocabulary.japanese.common.persistence.data.OwnListPersistanceData;
import de.duehl.vocabulary.japanese.common.ui.resources.IconDefinitions;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.grammar.table.GrammarTableCreator;
import de.duehl.vocabulary.japanese.io.ManualVocabularySortOrderFileIo;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.sort.VocableSorter;
import de.duehl.vocabulary.japanese.logic.symbol.kana.html.HiraganaHtmlCreator;
import de.duehl.vocabulary.japanese.logic.symbol.kana.html.KatakanaHtmlCreator;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.HiraganaTesterLogic;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.KatakanaTesterLogic;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.KanjiTestListFromGermanMeaningCreator;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.KanjiTesterLogic;
import de.duehl.vocabulary.japanese.logic.test.VocableListTesterLogic;
import de.duehl.vocabulary.japanese.statistics.VocabularyTrainerStatisticCreator;
import de.duehl.vocabulary.japanese.tools.VocableSubsetCreator;
import de.duehl.vocabulary.japanese.ui.components.TranslationDirectionGuiWithSwitchButton;
import de.duehl.vocabulary.japanese.ui.components.bars.VocabularyBar;
import de.duehl.vocabulary.japanese.ui.creation.menu.MenuCreation;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.data.OwnListInGuiRefresher;
import de.duehl.vocabulary.japanese.ui.dialog.AllVocablesWithSpecificConstraintDialog;
import de.duehl.vocabulary.japanese.ui.dialog.ComplexVocableSearchDialog;
import de.duehl.vocabulary.japanese.ui.dialog.kana.HiraganaTableDialog;
import de.duehl.vocabulary.japanese.ui.dialog.kana.KatakanaTableDialog;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjiset.KanjiSetManagementDialog;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.table.KanjiTableDialog;
import de.duehl.vocabulary.japanese.ui.dialog.options.OptionsDialog;
import de.duehl.vocabulary.japanese.ui.dialog.ownlist.OwnListEditorDialog;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.lister.VocabularyListerDialog;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.sheet.VocableSheetsCreator;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.sheet.VocabularySheetDialog;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.single.SingleVocableVocabularyViewerDialog;
import de.duehl.vocabulary.japanese.ui.listcommander.OwnListCommander;
import de.duehl.vocabulary.japanese.ui.tabs.MainTabs;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VocabularyTrainerGui
extends NonModalFrameDialogBase
implements OwnListInGuiRefresher {
    private static final String DOCUMENTS = "de/duehl/vocabulary/japanese/documents";
    private static final String DIALOG_TITLE = "Fumikos Vokabel-Trainer";
    private static final Image PROGRAM_IMAGE = IconDefinitions.loadProgramImage();
    public static final int MAXIMAL_NUMBER_OF_VOCABULARY_PER_COLUMNN = 5;
    private static final boolean SHOW_TEST_ALL_BUTTON = false;
    private final VocabularyTrainerLogic logic;
    private final JLabel statusBar;
    private final List<FontSizeChangable> fontSizeChangingStringSelections;
    private final List<JPanel> fontSizeChangingPanelsWithTitledBorders;
    private int standardTitledBordersFontSize;
    private int stringSelectionFontSize;
    private int stringSelectionLabelFontSize;
    private final MainTabs mainTabs;
    private final TranslationDirectionGuiWithSwitchButton translationDirectionGui;
    private String oldSearch;
    private String oldKanjiSearch;
    private FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;

    public VocabularyTrainerGui(VocabularyTrainerLogic vocabularyTrainerLogic, Options options) {
        super(PROGRAM_IMAGE, DIALOG_TITLE);
        this.addClosingWindowListener(() -> vocabularyTrainerLogic.quit());
        this.addEscapeBehaviour();
        this.logic = vocabularyTrainerLogic;
        GuiTools.setNiceLayoutManager();
        this.uiObjects = new FumikoUiObjects(string -> this.setMessageLater(string), this.getWindowAsComponent(), this, this.createErrorHandler(), () -> this.actualizeOwnListsPart(), () -> this.getLocation(), this.getProgramImage());
        this.mainTabs = new MainTabs(vocabularyTrainerLogic, this, this.uiObjects);
        this.statusBar = new JLabel(" ");
        this.fontSizeChangingStringSelections = CollectionsHelper.buildListFrom(new FontSizeChangable[0]);
        this.fontSizeChangingPanelsWithTitledBorders = new ArrayList<JPanel>();
        this.translationDirectionGui = new TranslationDirectionGuiWithSwitchButton(options, this);
        this.oldSearch = "";
        this.oldKanjiSearch = "";
        this.fillDialog();
    }

    @Override
    protected void populateDialog() {
        this.add(this.createMainPart(), "Center");
        this.add(this.createButtonPart(), "South");
        this.createMenu();
        this.storeTitledBorderStandardSize();
    }

    private Component createMainPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createUpperButtonPart(), "North");
        jPanel.add(this.mainTabs.getPanel(), "Center");
        jPanel.add(this.createStatusPart(), "South");
        return jPanel;
    }

    private Component createUpperButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createLeftUpperButtonPart(), "West");
        jPanel.add(this.createMiddleUpperButtonPart(), "Center");
        jPanel.add(this.createRightUpperButtonPart(), "East");
        return jPanel;
    }

    private Component createLeftUpperButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        jPanel.add(this.translationDirectionGui.getPanel());
        jPanel.add(this.createImportOwnListsButton());
        jPanel.add(this.createExportButton());
        jPanel.add(this.createTest10RandomVocablesButton());
        jPanel.add(this.createListAllVocablesButton());
        return jPanel;
    }

    private Component createImportOwnListsButton() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("IMPORT_OWN_LIST", actionEvent -> this.importOwnList(), "Vokabelliste importieren");
        return jButton;
    }

    private Component createExportButton() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("NEW_OWN_LIST", actionEvent -> this.createNewOwnList(), "Eine neue Vokabelliste anlegen");
        return jButton;
    }

    public void importOwnList() {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        ownLists.importOwnList();
        this.actualizeOwnListsPart();
    }

    private Component createTestAllVocablesButton() {
        JButton jButton = new JButton(this.buttonHtml("alle Vokabeln\nabfragen"));
        jButton.addActionListener(actionEvent -> this.testAllVocabularies());
        return jButton;
    }

    private String buttonHtml(String string) {
        Object object = string;
        object = ((String)object).replace("\n", "<br>");
        object = "<center>" + (String)object + "</center>";
        object = "<html>" + (String)object + "</html>";
        return object;
    }

    private Component createTest10RandomVocablesButton() {
        JButton jButton = new JButton(this.buttonHtml("10 zuf\u00e4llige\nVokabeln abfragen"));
        jButton.addActionListener(actionEvent -> this.test10RandomVocables());
        return jButton;
    }

    private Component createListAllVocablesButton() {
        JButton jButton = new JButton(this.buttonHtml("Liste aller\nVokabeln anzeigen"));
        jButton.addActionListener(actionEvent -> this.showAllVocablesAsList());
        return jButton;
    }

    private Component createMiddleUpperButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add(this.createSelectAllVocabulariesInTabButton());
        jPanel.add(this.createDeselectedAllVocabulariesInTabButton());
        return GuiTools.centerHorizontal(jPanel);
    }

    private Component createSelectAllVocabulariesInTabButton() {
        JButton jButton = new JButton(this.buttonHtml("alle Vokabulabrien auf dieser\nSeite ausw\u00e4hlen"));
        jButton.addActionListener(actionEvent -> this.selectAllVocabulariesInTab());
        return jButton;
    }

    private Component createDeselectedAllVocabulariesInTabButton() {
        JButton jButton = new JButton(this.buttonHtml("alle Vokabulabrien auf\ndieser Seite abw\u00e4hlen"));
        jButton.addActionListener(actionEvent -> this.deselectAllVocabulariesInTab());
        return jButton;
    }

    public void selectAllVocabulariesInTab() {
        List<VocabularyBar> list = this.determineBarsOfSelectedTab();
        for (VocabularyBar vocabularyBar : list) {
            vocabularyBar.setSelected(true);
        }
    }

    public void deselectAllVocabulariesInTab() {
        List<VocabularyBar> list = this.determineBarsOfSelectedTab();
        for (VocabularyBar vocabularyBar : list) {
            vocabularyBar.setSelected(false);
        }
    }

    private Component createRightUpperButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 5, 5));
        jPanel.add(this.createListSelectedVocabulariesButton());
        jPanel.add(this.createTestSelectedVocabulariesButton());
        jPanel.add(this.createTest10RandomVocablesFromSelectedVocabulariesButton());
        return jPanel;
    }

    private Component createListSelectedVocabulariesButton() {
        JButton jButton = new JButton(this.buttonHtml("ausgew\u00e4hlte\nVokabularien anzeigen"));
        jButton.addActionListener(actionEvent -> this.listSelectedVocabularies());
        return jButton;
    }

    private Component createTestSelectedVocabulariesButton() {
        JButton jButton = new JButton(this.buttonHtml("ausgew\u00e4hlte\nVokabularien abfragen"));
        jButton.addActionListener(actionEvent -> this.testSelectedVocabularies());
        return jButton;
    }

    private Component createTest10RandomVocablesFromSelectedVocabulariesButton() {
        JButton jButton = new JButton(this.buttonHtml("10 zuf\u00e4llige Vokabeln aus den\nausgew\u00e4hlten Vokabularien abfragen"));
        jButton.addActionListener(actionEvent -> this.test10RandomVocablesFromSelectedVocabularies());
        return jButton;
    }

    private Component createStatusPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Status", jPanel);
        this.fontSizeChangingPanelsWithTitledBorders.add(jPanel);
        jPanel.add((Component)this.statusBar, "Center");
        return jPanel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.logic.quit());
        return jButton;
    }

    public int getStringSelectionFontSize() {
        if (!this.fontSizeChangingStringSelections.isEmpty()) {
            FontSizeChangable fontSizeChangable = this.fontSizeChangingStringSelections.get(0);
            return fontSizeChangable.getFontSize();
        }
        return -1;
    }

    public void setStringSelectionFontSize(int n) {
        this.stringSelectionFontSize = n;
        for (FontSizeChangable fontSizeChangable : this.fontSizeChangingStringSelections) {
            fontSizeChangable.setFontSize(this.stringSelectionFontSize);
        }
    }

    public int getStringSelectionLabelFontSize() {
        if (!this.fontSizeChangingStringSelections.isEmpty()) {
            FontSizeChangable fontSizeChangable = this.fontSizeChangingStringSelections.get(0);
            return fontSizeChangable.getLabelFontSize();
        }
        return -1;
    }

    public void setStringSelectionLabelFontSize(int n) {
        this.stringSelectionLabelFontSize = n;
        for (FontSizeChangable object : this.fontSizeChangingStringSelections) {
            object.setLabelFontSize(this.stringSelectionLabelFontSize);
        }
        for (JPanel jPanel : this.fontSizeChangingPanelsWithTitledBorders) {
            GuiTools.setTitledBorderFontSize(jPanel, this.stringSelectionLabelFontSize);
        }
    }

    private void storeTitledBorderStandardSize() {
        if (this.fontSizeChangingPanelsWithTitledBorders.isEmpty()) {
            this.standardTitledBordersFontSize = -1;
        } else {
            JPanel jPanel = this.fontSizeChangingPanelsWithTitledBorders.get(0);
            this.standardTitledBordersFontSize = GuiTools.getTitledBorderFontSizeOfPanel(jPanel);
        }
    }

    public void setMessageLater(String string) {
        String string2 = string.isEmpty() ? " " : string;
        SwingUtilities.invokeLater(() -> this.statusBar.setText(string2));
    }

    public void showOptionDialog() {
        OptionsDialog optionsDialog = new OptionsDialog(this.dataStructures.getOptions(), this.getLocation(), this.uiObjects);
        optionsDialog.populate();
        optionsDialog.setVisible(true);
        if (optionsDialog.wasApplied()) {
            this.runAfterChangingOptions();
        }
    }

    private void runAfterChangingOptions() {
        this.saveOptions();
        this.showVocabularyBarsInWantedOrder();
        this.setCorrectForegroundColorOfVocabularyBarsLater();
        this.setCorrectTextOfVocabularyBarsLater();
        this.showOrHidePercentInVocabularyBars();
    }

    public void saveOptions() {
        this.logic.saveOptions();
    }

    public void about() {
        GuiTools.showAbout(DIALOG_TITLE, "", new VocabularyTrainerVersion().getVersion(), new ImageIcon(this.getProgramImage()), this.getFrame());
    }

    public void help() {
        String string = "de/duehl/vocabulary/japanese/documents/help/hilfe.html";
        URL uRL = this.getClass().getClassLoader().getResource(string);
        this.showHtmlViaUrl("Hilfe", uRL);
    }

    public void todo() {
        String string = "de/duehl/vocabulary/japanese/documents/todo.html";
        URL uRL = this.getClass().getClassLoader().getResource(string);
        this.showHtmlViaUrl("Weiterentwicklung - Todos", uRL);
    }

    public void changes() {
        String string = "de/duehl/vocabulary/japanese/documents/changes.html";
        URL uRL = this.getClass().getClassLoader().getResource(string);
        this.showHtmlViaUrl("\u00c4nderungen", uRL);
    }

    public String getChanges() {
        String string = "de/duehl/vocabulary/japanese/documents/changes.html";
        return this.readResourceToText(string);
    }

    public void keyboardDescription() {
        String string = this.readFormatCssResource();
        MyMenuItemCollectionHelper.generateAndShowMyMenuItemsHtmlDescriptionDialog("Tastaturbelegung im Umbruch-Editor", string, this.getProgramImage(), this.getLocation());
    }

    public void keyboardDescriptionSortByKeys() {
        String string = this.readFormatCssResource();
        MyMenuItemCollectionHelper.generateAndShowMyMenuItemsHtmlDescriptionSortByKeysDialog("Tastaturbelegung im Umbruch-Editor in Reihenfolge der Tasten", string, this.getProgramImage(), this.getLocation());
    }

    private String readFormatCssResource() {
        String string = "de/duehl/vocabulary/japanese/documents/format.css";
        return this.readResourceToText(string);
    }

    private String readResourceToText(String string) {
        URL uRL = this.getClass().getClassLoader().getResource(string);
        return HtmlTool.createContentFromUrl(uRL);
    }

    public void increaseFontSize() {
        for (FontSizeChangable fontSizeChangable : this.fontSizeChangingStringSelections) {
            this.increaseFontSize(fontSizeChangable);
        }
    }

    private void increaseFontSize(FontSizeChangable fontSizeChangable) {
        fontSizeChangable.biggerText(1);
    }

    public void decreaseFontSize() {
        for (FontSizeChangable fontSizeChangable : this.fontSizeChangingStringSelections) {
            this.decreaseFontSize(fontSizeChangable);
        }
    }

    private void decreaseFontSize(FontSizeChangable fontSizeChangable) {
        fontSizeChangable.biggerText(-1);
    }

    public void standardFontSize() {
        for (FontSizeChangable fontSizeChangable : this.fontSizeChangingStringSelections) {
            fontSizeChangable.setToStandardFontSize();
        }
    }

    public void increaseLabelFontSize() {
        for (FontSizeChangable object : this.fontSizeChangingStringSelections) {
            this.increaseLabelFontSize(object);
        }
        for (JPanel jPanel : this.fontSizeChangingPanelsWithTitledBorders) {
            this.increaseTitledBorderFontSize(jPanel);
        }
    }

    private void increaseLabelFontSize(FontSizeChangable fontSizeChangable) {
        fontSizeChangable.biggerLabelText(1);
    }

    private void increaseTitledBorderFontSize(JPanel jPanel) {
        GuiTools.biggerTitledBorderFontOfPanel(jPanel, 1);
    }

    public void decreaseLabelFontSize() {
        for (FontSizeChangable object : this.fontSizeChangingStringSelections) {
            this.decreaseLabelFontSize(object);
        }
        for (JPanel jPanel : this.fontSizeChangingPanelsWithTitledBorders) {
            this.decreaseTitledBorderFontSize(jPanel);
        }
    }

    private void decreaseLabelFontSize(FontSizeChangable fontSizeChangable) {
        fontSizeChangable.biggerLabelText(-1);
    }

    private void decreaseTitledBorderFontSize(JPanel jPanel) {
        GuiTools.biggerTitledBorderFontOfPanel(jPanel, -1);
    }

    public void standardLabelFontSize() {
        for (FontSizeChangable object : this.fontSizeChangingStringSelections) {
            object.setToStandardLabelFontSize();
        }
        for (JPanel jPanel : this.fontSizeChangingPanelsWithTitledBorders) {
            this.defaultTitledBorderFontSize(jPanel);
        }
    }

    private void defaultTitledBorderFontSize(JPanel jPanel) {
        if (this.standardTitledBordersFontSize != -1) {
            GuiTools.setTitledBorderFontSize(jPanel, this.standardTitledBordersFontSize);
        }
    }

    private void createMenu() {
        try {
            this.tryToCreateMenu();
        }
        catch (Exception exception) {
            this.logic.reallyQuit();
            System.out.println("Abbruch wegen Fehler beim Men\u00fcaufbau! exception = " + exception);
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private void tryToCreateMenu() {
        MenuCreation menuCreation = new MenuCreation(this.logic, this);
        menuCreation.addTo(this.getFrame());
    }

    public void quit() {
        this.closeDialog();
    }

    public void initGuiWithDataStructure(FumikoDataStructures fumikoDataStructures) {
        this.dataStructures = fumikoDataStructures;
        this.initWithDataStructures();
    }

    private void initWithDataStructures() {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        ownLists.setOwnListInGuiRefresher(this);
        this.mainTabs.initWithDataStructures(this.dataStructures);
        this.showVocabularyBarsInWantedOrder();
        this.showTranslationDirectionOnBarButtons();
        this.pack();
    }

    public void showAllVocablesAsList() {
        List<Vocable> list = this.logic.collectVocablesOfAllVocabularies();
        this.listVocables(list, "alle Vokabeln");
        this.setMessageLater("Alle Vokabeln wurden als Liste angezeigt.");
    }

    private void listVocables(List<Vocable> list, String string) {
        VocabularyListerDialog vocabularyListerDialog = new VocabularyListerDialog(list, string, this.dataStructures, this.uiObjects, this.getLocation(), this.uiObjects.getInformer());
        vocabularyListerDialog.setVisible(true);
    }

    public void showAllVocablesAsSheet() {
        List<Vocable> list = this.logic.collectVocablesOfAllVocabularies();
        this.sheetWithVocables(list, "alle Vokabeln");
        this.setMessageLater("Alle Vokabeln wurden als Blatt angezeigt.");
    }

    public void sheetWithVocables(List<Vocable> list, String string) {
        this.startLongTimeProcess("\u00d6ffne Blattdarstellung mit " + NumberString.taupu(list.size()) + " Vokabeln");
        new Thread(() -> this.listVocabularyAsSheetInOwnThread(list, string)).start();
    }

    private void listVocabularyAsSheetInOwnThread(List<Vocable> list, String string) {
        try {
            this.tryToListVocabularyAsSheetInOwnThread(list, string);
        }
        catch (Exception exception) {
            GuiTools.informUser("Hier ging etwas schief", "Bei der Erzeugng der Panel f\u00fcr die Blattdarstellung gab es ein Problem.");
            this.endLongTimeProcess();
        }
    }

    private void tryToListVocabularyAsSheetInOwnThread(List<Vocable> list3, String string) {
        VocableSheetsCreator vocableSheetsCreator = new VocableSheetsCreator(list3, this.dataStructures, this.uiObjects, (list, list2) -> this.listVocabularyAsSheetInEdt(list, list2, string), this.getLocation());
        vocableSheetsCreator.create();
    }

    private void listVocabularyAsSheetInEdt(List<Vocable> list, List<Component> list2, String string) {
        try {
            this.tryToListVocabularyAsSheetInEdt(list, list2, string);
        }
        catch (Exception exception) {
            GuiTools.informUser("Hier ging etwas schief", "Bei der Anzeige der Blattdarstellung gab es ein Problem.");
            this.endLongTimeProcess();
        }
    }

    private void tryToListVocabularyAsSheetInEdt(List<Vocable> list, List<Component> list2, String string) {
        VocabularySheetDialog vocabularySheetDialog = new VocabularySheetDialog(list, list2, string, this.dataStructures, this.uiObjects, this.uiObjects.getInformer(), this.getLocation());
        vocabularySheetDialog.setVisible(true);
        vocabularySheetDialog.requestFocus();
        this.endLongTimeProcess();
        this.setMessageLater(Text.firstCharToUpperCase(string) + " wurden als Blatt angezeigt.");
    }

    public void test10RandomVocables() {
        List<Vocable> list = this.logic.collectVocablesOfAllVocabularies();
        List<Vocable> list2 = this.createVocablesSublist(list, 10);
        VocableListTesterLogic vocableListTesterLogic = new VocableListTesterLogic(list2, "Zehn zuf\u00e4llige Vokabeln", this.logic, this.dataStructures, this.uiObjects);
        vocableListTesterLogic.test();
        this.setCorrectForegroundColorOfVocabularyBarsLater();
        this.setMessageLater("Zehn zuf\u00e4llige Vokabeln wurden abgefragt.");
        this.perhapsSaveAsList(list2, "zehn zuf\u00e4llige Vokabeln");
    }

    private List<Vocable> createVocablesSublist(List<Vocable> list, int n) {
        VocableSubsetCreator vocableSubsetCreator = new VocableSubsetCreator(list, n, this.dataStructures);
        vocableSubsetCreator.create();
        return vocableSubsetCreator.getSubset();
    }

    public void testAllVocabularies() {
        List<Vocable> list = this.logic.collectVocablesOfAllVocabularies();
        VocableListTesterLogic vocableListTesterLogic = new VocableListTesterLogic(list, "alle Vokabeln", this.logic, this.dataStructures, this.uiObjects);
        vocableListTesterLogic.test();
        this.setCorrectForegroundColorOfVocabularyBarsLater();
        this.setMessageLater("Alle Vokabeln wurden abgefragt.");
    }

    public void listSelectedVocabularies() {
        List<Vocable> list = this.collectVocablesOfSelectedVocabularies();
        if (!list.isEmpty()) {
            VocabularyListerDialog vocabularyListerDialog = new VocabularyListerDialog(list, "Vokabeln ausgew\u00e4hlter Vokabularien", this.dataStructures, this.uiObjects, this.getLocation(), this.uiObjects.getInformer());
            vocabularyListerDialog.setVisible(true);
            this.setMessageLater("Die Vokabeln ausgew\u00e4hlter Vokabularien wurden als Liste angezeigt.");
        }
    }

    public void testSelectedVocabularies() {
        List<Vocable> list = this.collectVocablesOfSelectedVocabularies();
        if (!list.isEmpty()) {
            VocableListTesterLogic vocableListTesterLogic = new VocableListTesterLogic(list, "Vokabeln ausgew\u00e4hlter Vokabularien", this.logic, this.dataStructures, this.uiObjects);
            vocableListTesterLogic.test();
            this.setCorrectForegroundColorOfVocabularyBarsLater();
            this.setMessageLater("Die ausgew\u00e4hlten Vokabularien wurden abgefragt.");
        }
    }

    private List<Vocable> collectVocablesOfSelectedVocabularies() {
        List<Vocable> list = this.mainTabs.collectVocablesOfSelectedVocabularies();
        if (list.isEmpty()) {
            GuiTools.informUser(this.getWindowAsComponent(), "Keine Vokabularien ausgew\u00e4hlt", "Es wurden leider keine Vokabularien ausgew\u00e4hlt.");
        }
        return list;
    }

    public void test10RandomVocablesFromSelectedVocabularies() {
        List<Vocable> list = this.collectVocablesOfSelectedVocabularies();
        if (!list.isEmpty()) {
            List<Vocable> list2 = this.createVocablesSublist(list, 10);
            VocableListTesterLogic vocableListTesterLogic = new VocableListTesterLogic(list2, "Zehn zuf\u00e4llige Vokabeln aus den ausgew\u00e4hlten Vokabularien", this.logic, this.dataStructures, this.uiObjects);
            vocableListTesterLogic.test();
            this.setCorrectForegroundColorOfVocabularyBarsLater();
            this.setMessageLater("Zehn zuf\u00e4llige Vokabeln aus den ausgew\u00e4hlten Vokabularien wurden abgefragt.");
            this.perhapsSaveAsList(list2, "zehn zuf\u00e4llige Vokabeln");
        }
    }

    public void setVocabularySortOrder(VocabularySortOrder vocabularySortOrder) {
        this.logic.setVocabularySortOrder(vocabularySortOrder);
        this.showVocabularyBarsInWantedOrder();
    }

    private void showVocabularyBarsInWantedOrder() {
        this.mainTabs.showVocabularyBarsInWantedOrder();
        this.setMessageLater(" ");
        this.refresh();
    }

    public void toggleManualVocabularySortMode() {
        VocabularySortOrder vocabularySortOrder = this.dataStructures.getOptions().getVocabularySortOrder();
        if (vocabularySortOrder == VocabularySortOrder.MANUAL_SORT_ORDER) {
            this.mainTabs.showOrHideIndividualVocabularySortModeMoveButtons();
            this.pack();
            this.revalidate();
            this.setMessageLater(" ");
        } else {
            GuiTools.informUser(this.getWindowAsComponent(), "Falscher Sortiermodus", "Das Anzeigen oder Verstecken der Buttons zum Bewegen der Bars funktioniert nur im individuellen Sortiermodus.");
        }
    }

    private List<VocabularyBar> determineBarsOfSelectedTab() {
        return this.mainTabs.determineBarsOfSelectedTab();
    }

    @Override
    public void setCorrectForegroundColorOfVocabularyBarsLater() {
        SwingUtilities.invokeLater(() -> this.setCorrectForegroundColorOfVocabularyBars());
    }

    private void setCorrectForegroundColorOfVocabularyBars() {
        this.mainTabs.setCorrectForegroundColorOfVocabularyBars();
        this.repaint();
        this.revalidate();
    }

    private void setCorrectTextOfVocabularyBarsLater() {
        SwingUtilities.invokeLater(() -> this.setCorrectTextOfVocabularyBars());
    }

    private void setCorrectTextOfVocabularyBars() {
        this.mainTabs.setCorrectTextOfVocabularyBars();
        this.repaintAndPack();
    }

    private void repaintAndPack() {
        this.repaint();
        this.revalidate();
        this.pack();
    }

    private void showOrHidePercentInVocabularyBars() {
        SwingUtilities.invokeLater(() -> this.showOrHidePercentInVocabularyBarsLater());
    }

    private void showOrHidePercentInVocabularyBarsLater() {
        this.mainTabs.showOrHidePercentInVocabularyBarsLater();
        this.repaintAndPack();
    }

    public void saveManualVocabularyOrder() {
        VocabularySortOrder vocabularySortOrder = this.dataStructures.getOptions().getVocabularySortOrder();
        if (vocabularySortOrder == VocabularySortOrder.MANUAL_SORT_ORDER) {
            List<Vocabulary> list = this.mainTabs.getVocabulariesInIndividualOrder();
            ManualVocabularySortOrderFileIo.saveManualVocabularyOrder(list);
            List<OwnList> list2 = this.mainTabs.getOwnListsInIndividualOrder();
            OwnLists ownLists = this.dataStructures.getOwnLists();
            if (null != ownLists) {
                ownLists.setOrderAndStoreOwnLists(list2);
            }
        }
    }

    public void showTabsWeViewedLastTime() {
        this.mainTabs.showTabsWeViewedLastTime();
    }

    public void storeShownTabIndices() {
        Options options = this.dataStructures.getOptions();
        this.mainTabs.storeShownTabIndices(options);
    }

    public void vocableSearch() {
        String string = GuiTools.askUserToEnterAStringValue(this.getWindowAsComponent(), "Bitte den Suchbegriff eigeben", "Bitte geben Sie den Begrif ein, nach dem in den Vokabeln in japanischer\nForm, deutscher Form sowie in den Bemerkungen, den Suchbegriffen und Wortarten\ngesucht werden soll.", this.oldSearch);
        if (!string.isBlank()) {
            this.oldSearch = string = string.strip();
            List<Vocable> list = this.logic.collectVocablesOfAllVocabularies();
            ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
            for (Vocable object : list) {
                if (!object.contains(string)) continue;
                arrayList.add(object);
            }
            if (arrayList.isEmpty()) {
                var4_4 = "Es gibt keine Vokabeln mit dem Suchbegriff '" + string + "'.";
                GuiTools.informUser(this.getWindowAsComponent(), "Hinweis", (String)var4_4);
                this.setMessageLater((String)var4_4);
            } else {
                var4_4 = new VocableSorter(arrayList, string);
                ((VocableSorter)var4_4).sort();
                SingleVocableVocabularyViewerDialog singleVocableVocabularyViewerDialog = new SingleVocableVocabularyViewerDialog(arrayList, "Vokabeln mit dem Suchbegriff '" + string + "'", this.dataStructures, this.uiObjects);
                singleVocableVocabularyViewerDialog.setOpenedFromSimpleSearch();
                singleVocableVocabularyViewerDialog.setVisible(true);
                this.setMessageLater("Die Vokabeln mit dem Suchbegriff '" + string + "' wurden angezeigt.");
            }
        }
    }

    public void complexVocableSearch() {
        ComplexVocableSearchDialog complexVocableSearchDialog = new ComplexVocableSearchDialog(this.logic, this, this.dataStructures, this.uiObjects);
        complexVocableSearchDialog.setVisible(true);
    }

    public void showNotTestedVocables() {
        List<Vocable> list = this.determineNotTestedVocables();
        String string = "noch gar nicht abgefragt wurden";
        String string2 = "Noch nicht abgefragte Vokabeln";
        this.showVocables(list, string, string2);
    }

    public void showNotTestedVocablesAsSheet() {
        List<Vocable> list = this.determineNotTestedVocables();
        this.sheetWithVocables(list, "noch nicht abgefragte Vokabeln");
        this.setMessageLater("Noch nicht abgefragte Vokabeln wurden als Blatt angezeigt.");
    }

    public void showNotTestedVocablesAsList() {
        List<Vocable> list = this.determineNotTestedVocables();
        this.listVocables(list, "noch nicht abgefragte Vokabeln");
        this.setMessageLater("Noch nicht abgefragte Vokabeln wurden als Liste angezeigt.");
    }

    public void testNotTestedVocables() {
        List<Vocable> list = this.determineNotTestedVocables();
        String string = "noch gar nicht abgefragt wurden";
        String string2 = "Noch nicht abgefragte Vokabeln";
        this.testVocables(list, string, string2);
        this.perhapsSaveAsList(list, string);
    }

    private List<Vocable> determineNotTestedVocables() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable vocable : this.logic.collectVocablesOfAllVocabularies()) {
            InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
            InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
            int n = this.getTestCount(internalAdditionalVocableData);
            if (n != 0) continue;
            arrayList.add(vocable);
        }
        return arrayList;
    }

    private int getTestCount(InternalAdditionalVocableData internalAdditionalVocableData) {
        Options options = this.dataStructures.getOptions();
        TranslationDirection translationDirection = options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            return internalAdditionalVocableData.getJapaneseToGermanTestCount();
        }
        if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            return internalAdditionalVocableData.getGermanToJapaneseTestCount();
        }
        throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + translationDirection);
    }

    public void showNotCorrectTestedVocables() {
        List<Vocable> list = this.determineNotCorrectTestedVocables();
        String string = "noch nicht korrekt \u00fcbersetzt wurden";
        String string2 = "Noch nicht korrekt \u00fcbersetzte Vokabeln";
        this.showVocables(list, string, string2);
    }

    public void testNotCorrectTestedVocables() {
        List<Vocable> list = this.determineNotCorrectTestedVocables();
        String string = "noch nicht korrekt \u00fcbersetzt wurden";
        String string2 = "Noch nicht korrekt \u00fcbersetzte Vokabeln";
        this.testVocables(list, string, string2);
        this.perhapsSaveAsList(list, string);
    }

    private List<Vocable> determineNotCorrectTestedVocables() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable vocable : this.logic.collectVocablesOfAllVocabularies()) {
            InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
            InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
            int n = this.getCorrectTestCount(internalAdditionalVocableData);
            if (n != 0) continue;
            arrayList.add(vocable);
        }
        return arrayList;
    }

    private int getCorrectTestCount(InternalAdditionalVocableData internalAdditionalVocableData) {
        Options options = this.dataStructures.getOptions();
        TranslationDirection translationDirection = options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            return internalAdditionalVocableData.getCorrectJapaneseToGermanTestCount();
        }
        if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            return internalAdditionalVocableData.getCorrectGermanToJapaneseTestCount();
        }
        throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + translationDirection);
    }

    public void showNotTestedForAWhileVocables() {
        List<Vocable> list = this.determineNotTestedForAWhileVocables();
        String string = "lange nicht mehr abgefragt wurden";
        String string2 = "Lange nicht mehr abgefragte Vokabeln";
        this.showVocables(list, string, string2);
    }

    public void testNotTestedForAWhileVocables() {
        List<Vocable> list = this.determineNotTestedForAWhileVocables();
        String string = "lange nicht mehr abgefragt wurden";
        String string2 = "Lange nicht mehr abgefragte Vokabeln";
        this.testVocables(list, string, string2);
        this.perhapsSaveAsList(list, string);
    }

    private List<Vocable> determineNotTestedForAWhileVocables() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable vocable : this.logic.collectVocablesOfAllVocabularies()) {
            InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
            InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
            ImmutualDate immutualDate = this.getLastTestDate(internalAdditionalVocableData);
            if (!this.lastDateIsAWhileAgo(immutualDate)) continue;
            arrayList.add(vocable);
        }
        return arrayList;
    }

    private ImmutualDate getLastTestDate(InternalAdditionalVocableData internalAdditionalVocableData) {
        Options options = this.dataStructures.getOptions();
        TranslationDirection translationDirection = options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            return internalAdditionalVocableData.getLastJapaneseToGermanTestDate();
        }
        if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            return internalAdditionalVocableData.getLastGermanToJapaneseTestDate();
        }
        throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + translationDirection);
    }

    public void showNotCorrectTestedForAWhileVocables() {
        List<Vocable> list = this.determineNotCorrectTestedForAWhileVocables();
        String string = "lange nicht mehr korrekt \u00fcbersetzt wurden";
        String string2 = "Lange nicht mehr korrekt \u00fcbersetzt Vokabeln";
        this.showVocables(list, string, string2);
    }

    public void testNotCorrectTestedForAWhileVocables() {
        List<Vocable> list = this.determineNotCorrectTestedForAWhileVocables();
        String string = "lange nicht mehr korrekt \u00fcbersetzt wurden";
        String string2 = "Lange nicht mehr korrekt \u00fcbersetzt Vokabeln";
        this.testVocables(list, string, string2);
        this.perhapsSaveAsList(list, string);
    }

    private List<Vocable> determineNotCorrectTestedForAWhileVocables() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable vocable : this.logic.collectVocablesOfAllVocabularies()) {
            InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
            InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
            ImmutualDate immutualDate = this.getLastCorrectTestDate(internalAdditionalVocableData);
            if (!this.lastDateIsAWhileAgo(immutualDate)) continue;
            arrayList.add(vocable);
        }
        return arrayList;
    }

    private ImmutualDate getLastCorrectTestDate(InternalAdditionalVocableData internalAdditionalVocableData) {
        Options options = this.dataStructures.getOptions();
        TranslationDirection translationDirection = options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            return internalAdditionalVocableData.getLastCorrectJapaneseToGermanTestDate();
        }
        if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            return internalAdditionalVocableData.getLastCorrectGermanToJapaneseTestDate();
        }
        throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + translationDirection);
    }

    private boolean lastDateIsAWhileAgo(ImmutualDate immutualDate) {
        Options options;
        ImmutualDate immutualDate2 = new ImmutualDate();
        int n = immutualDate.difference(immutualDate2);
        return n >= (options = this.dataStructures.getOptions()).getNumberOfDaysForAWhile();
    }

    public void showNewestVocables() {
        List<Vocable> list = this.determineNewestVocables();
        String string = "neu sind";
        String string2 = "Lange nicht mehr korrekt \u00fcbersetzt Vokabeln";
        this.showVocables(list, string, string2);
    }

    public void showNewestVocablesAsSheet() {
        List<Vocable> list = this.determineNewestVocables();
        this.sheetWithVocables(list, "neuste Vokabeln");
        this.setMessageLater("Neuste Vokabeln wurden als Blatt angezeigt.");
    }

    public void showNewestVocablesAsList() {
        List<Vocable> list = this.determineNewestVocables();
        this.listVocables(list, "neuste Vokabeln");
        this.setMessageLater("Neuste Vokabeln wurden als Liste angezeigt.");
    }

    public void testNewestVocables() {
        List<Vocable> list = this.determineNewestVocables();
        String string = "neuste Vokabeln";
        String string2 = "Neuste Vokabeln";
        this.testVocables(list, string, string2);
        this.perhapsSaveAsList(list, string);
    }

    private void perhapsSaveAsList(List<Vocable> list, String string) {
        boolean bl;
        if (!list.isEmpty() && (bl = GuiTools.askUserDefaultNo(this.getWindowAsComponent(), "Abgefragte Liste speichern?", "Wollen sie die Liste mit den gerade abgefragten Vokabeln (" + string + ") als eigene Vokabelliste speichern?"))) {
            this.saveAsList(list, string);
        }
    }

    public void saveAsList(List<Vocable> list, String string) {
        this.startLongTimeProcess("Liste wird gespeichert");
        new Thread(() -> this.saveAsListInOwnThread(list, string)).start();
    }

    private void saveAsListInOwnThread(List<Vocable> list, String string) {
        String string2 = string + " (" + DateAndTimeHelper.now() + ")";
        OwnLists ownLists = this.dataStructures.getOwnLists();
        ownLists.saveAsList(list, string2);
        SwingUtilities.invokeLater(() -> this.saveAsListInEdt());
    }

    private void saveAsListInEdt() {
        this.endLongTimeProcess();
        this.actualizeOwnListsPart();
    }

    private List<Vocable> determineNewestVocables() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable vocable : this.logic.collectVocablesOfAllVocabularies()) {
            InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
            InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
            ImmutualDate immutualDate = internalAdditionalVocableData.getFirstSeenDate();
            if (!this.firstSeenIsNew(immutualDate)) continue;
            arrayList.add(vocable);
        }
        return arrayList;
    }

    private boolean firstSeenIsNew(ImmutualDate immutualDate) {
        Options options;
        ImmutualDate immutualDate2 = new ImmutualDate();
        int n = immutualDate.difference(immutualDate2);
        return n <= (options = this.dataStructures.getOptions()).getNumberOfDaysAVocableIsNew();
    }

    private void showVocables(List<Vocable> list, String string, String string2) {
        if (list.isEmpty()) {
            GuiTools.informUser(this.getWindowAsComponent(), "Hinweis", "Es gibt keine Vokabeln, die " + string + ".");
        } else {
            SingleVocableVocabularyViewerDialog singleVocableVocabularyViewerDialog = new SingleVocableVocabularyViewerDialog(list, string2, this.dataStructures, this.uiObjects);
            singleVocableVocabularyViewerDialog.setVisible(true);
        }
        this.setMessageLater("Angezeigt wurden: " + string2);
    }

    private void testVocables(List<Vocable> list, String string, String string2) {
        if (list.isEmpty()) {
            GuiTools.informUser(this.getWindowAsComponent(), "Hinweis", "Es gibt keine Vokabeln, die " + string + ".");
        } else {
            VocableListTesterLogic vocableListTesterLogic = new VocableListTesterLogic(list, string2, this.logic, this.dataStructures, this.uiObjects);
            vocableListTesterLogic.test();
            this.setCorrectForegroundColorOfVocabularyBarsLater();
            this.setMessageLater("Getestet wurden: " + string2);
        }
    }

    public void showStatstics() {
        this.startLongTimeProcess("Erstelle Statistik");
        new Thread(() -> this.createStatsticsInOwnThread()).start();
    }

    private void createStatsticsInOwnThread() {
        VocabularyTrainerStatisticCreator vocabularyTrainerStatisticCreator = new VocabularyTrainerStatisticCreator(this.dataStructures, this.uiObjects);
        String string = vocabularyTrainerStatisticCreator.createStatisticReport();
        String string2 = this.saveStatistic(string);
        SwingUtilities.invokeLater(() -> this.showStatsticsInEdt(string2));
    }

    private String saveStatistic(String string) {
        String string2 = FileHelper.concatPathes(SessionManager.VOCABLE_TRAINER_DIRECTORY, "statistik.html");
        FileHelper.writeTextToFile(string, string2, Charset.UTF_8);
        return string2;
    }

    private void showStatsticsInEdt(String string) {
        this.endLongTimeProcess();
        URL uRL = this.createUrl(string);
        if (null != uRL) {
            HtmlDialog htmlDialog = new HtmlDialog("Statsitik", this.getProgramImage(), this.getLocation());
            htmlDialog.showHtml(uRL);
            htmlDialog.scrollScrollbarToMinimumLater();
            htmlDialog.setVisible(true);
        }
    }

    private URL createUrl(String string) {
        try {
            return this.tryToCreateUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.createErrorHandler().error("Beim Wandeln der Datei mit der gespeicheren Statistik aus einer URI in eine URL trat ein Fehler auf.", malformedURLException);
            return null;
        }
    }

    private URL tryToCreateUrl(String string) throws MalformedURLException {
        File file = new File(string);
        URI uRI = file.toURI();
        URL uRL = uRI.toURL();
        return uRL;
    }

    public void toggleColorVocabularyDependingOnLastSuccess() {
        Options options = this.dataStructures.getOptions();
        boolean bl = options.isColorVocabularyDependingOnLastSuccess();
        bl = !bl;
        options.setColorVocabularyDependingOnLastSuccess(bl);
        this.runAfterChangingOptions();
    }

    public void toggleShowSuccessPercentInVocabularyBar() {
        Options options = this.dataStructures.getOptions();
        boolean bl = options.isShowSuccessPercentInVocabularyBar();
        bl = !bl;
        options.setShowSuccessPercentInVocabularyBar(bl);
        this.runAfterChangingOptions();
    }

    public void toggleHideStartOfVocabularyDescription() {
        Options options = this.dataStructures.getOptions();
        boolean bl = options.isHideStartOfVocabularyDescription();
        bl = !bl;
        options.setHideStartOfVocabularyDescription(bl);
        this.runAfterChangingOptions();
    }

    @Override
    public void actualizeOwnListsPart() {
        new Thread(() -> this.actualizeOwnListsPartInOwnThread()).start();
    }

    private void actualizeOwnListsPartInOwnThread() {
        this.startLongTimeProcess("Baue die Anzeige der eigenen Listen neu auf");
        this.storeShownTabIndices();
        this.mainTabs.createOwnListsTabFromScratch();
        this.showTabsWeViewedLastTime();
        this.endLongTimeProcess();
    }

    public void exportOwnLists() {
        this.mainTabs.showTabWithOwnLists();
        this.mainTabs.showOwnListExtraButtons();
    }

    public void exportAllOwnLists() {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        ownLists.exportAllOwnLists();
    }

    public void showTranslationDirectionOnBarButtons() {
        this.mainTabs.showTranslationDirectionOnBarButtons();
    }

    public boolean createNewOwnList() {
        String string;
        OwnLists ownLists = this.dataStructures.getOwnLists();
        if (ownLists.nameCheckOk(string = ownLists.createNotExistingName("Neue Liste "))) {
            return this.createAndEditNewOwnList(string);
        }
        throw new RuntimeException("Obwohl in OwnLists der nicht vergebene Name '" + string + "' generiert wurde, besteht er die Pr\u00fcfung mit nameCheckOk() nicht.");
    }

    private boolean createAndEditNewOwnList(String string) {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        OwnList ownList = ownLists.createNewList(string);
        boolean bl = this.editOwnList(ownList);
        if (!bl) {
            this.deleteOwnList(ownList);
        }
        return bl;
    }

    public void toggleShowOwnListButtons() {
        this.mainTabs.toggleShowOwnListButtons();
    }

    public void deleteOwnList(OwnList ownList) {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        ownLists.deleteOwnList(ownList);
        this.actualizeOwnListsPart();
        ownLists.storeOwnLists();
    }

    public boolean editOwnList(OwnList ownList) {
        OwnListPersistanceData ownListPersistanceData = ownList.toOwnListPersistanceData();
        OwnLists ownLists = this.dataStructures.getOwnLists();
        OwnListEditorDialog ownListEditorDialog = new OwnListEditorDialog(ownList, this.dataStructures, this.uiObjects);
        ownListEditorDialog.setVisible(true);
        boolean bl = ownListEditorDialog.isApplied();
        if (bl) {
            this.actualizeOwnListsPart();
            ownLists.storeOwnLists();
            OwnListPersistanceData ownListPersistanceData2 = ownList.toOwnListPersistanceData();
            if (!ownListPersistanceData.equals(ownListPersistanceData2)) {
                this.adjustStoredOwnListPersistanceData(ownListPersistanceData, ownListPersistanceData2);
            }
        }
        return bl;
    }

    private void adjustStoredOwnListPersistanceData(OwnListPersistanceData ownListPersistanceData, OwnListPersistanceData ownListPersistanceData2) {
        Options options = this.dataStructures.getOptions();
        HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList = options.getHistoricalLeftOwnListsInListCommander();
        HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList2 = options.getHistoricalRightOwnListsInListCommander();
        HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList3 = options.getHistoricalOwnLists();
        this.adjustHistoricalOwnLists(ownListPersistanceData, ownListPersistanceData2, historicalOwnListPersistanceDataList);
        this.adjustHistoricalOwnLists(ownListPersistanceData, ownListPersistanceData2, historicalOwnListPersistanceDataList2);
        this.adjustHistoricalOwnLists(ownListPersistanceData, ownListPersistanceData2, historicalOwnListPersistanceDataList3);
    }

    private void adjustHistoricalOwnLists(OwnListPersistanceData ownListPersistanceData, OwnListPersistanceData ownListPersistanceData2, HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList) {
        List<OwnListPersistanceData> list = historicalOwnListPersistanceDataList.getHistoricalOwnLists();
        for (int i = 0; i < list.size(); ++i) {
            OwnListPersistanceData ownListPersistanceData3 = list.get(i);
            if (!ownListPersistanceData3.equals(ownListPersistanceData)) continue;
            list.set(i, ownListPersistanceData2);
        }
    }

    public void exportListOwnList(OwnList ownList) {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        ownLists.exportList(ownList);
    }

    public void showSplashScreenText() {
        String string = "Startup Log";
        String string2 = this.logic.getStartupLog();
        this.viewTextFile(string, string2);
    }

    private void viewTextFile(String string, String string2) {
        TextViewer textViewer = new TextViewer(string, this.getLocation(), new Dimension(1200, 800));
        textViewer.useMonoscpacedText();
        textViewer.setText(string2);
        textViewer.setVisible(true);
        textViewer.scrollScrollbarToMinimumLater();
    }

    public void showShowSplashWarnings() {
        List<String> list = this.logic.getStartupWarnings();
        if (list.isEmpty()) {
            GuiTools.informUser(this.getWindowAsComponent(), "Keine Warnungen", "Beim Startup sind keine Warnungen aufgetreten");
        } else {
            this.reallyShowWarnings(list);
        }
    }

    private void reallyShowWarnings(List<String> list) {
        String string = "Warnungen beim Startup";
        String string2 = Text.join("\n\n", list);
        this.viewTextFile(string, string2);
    }

    public void showKanjiTable() {
        KanjiTableDialog kanjiTableDialog = new KanjiTableDialog(this.dataStructures, this.uiObjects, this.uiObjects.getInformer(), this.uiObjects.getGuiLocation());
        kanjiTableDialog.setVisible(true);
        this.setMessageLater("Die Kanji wurden als Liste angezeigt.");
    }

    public void createKanjiTestFromGermanMeaning() {
        String string = KanjiTestListFromGermanMeaningCreator.createKanjiTestList();
        TextViewer textViewer = new TextViewer("Kanji-\u00dcbungsliste", this.getParentLocation(), new Dimension(1000, 900));
        textViewer.useMonoscpacedText();
        textViewer.setText(string);
        textViewer.setVisible(true);
    }

    public void createKanjiTestFromKanji() {
        KanjiTesterLogic kanjiTesterLogic = new KanjiTesterLogic(this.dataStructures, this.uiObjects);
        kanjiTesterLogic.test();
    }

    public void showHiragana() {
        String string = this.createHiraganaHtml();
        this.showHtmlInDialog("Hiragana", string);
    }

    private String createHiraganaHtml() {
        HiraganaHtmlCreator hiraganaHtmlCreator = new HiraganaHtmlCreator();
        hiraganaHtmlCreator.create();
        return hiraganaHtmlCreator.getHtml();
    }

    public void showKatakana() {
        String string = this.createKatakanaHtml();
        this.showHtmlInDialog("Katakana", string);
    }

    private String createKatakanaHtml() {
        KatakanaHtmlCreator katakanaHtmlCreator = new KatakanaHtmlCreator();
        katakanaHtmlCreator.create();
        return katakanaHtmlCreator.getHtml();
    }

    public void showHiraganaInBrowser() {
        String string = this.createHiraganaHtml();
        String string2 = this.saveKanaTable("hiragana", string);
        SystemTools.openInStandardProgram(string2);
    }

    public void showKatakanaInBrowser() {
        String string = this.createKatakanaHtml();
        String string2 = this.saveKanaTable("katakana", string);
        SystemTools.openInStandardProgram(string2);
    }

    private String saveKanaTable(String string, String string2) {
        String string3 = FileHelper.concatPathes(SessionManager.VOCABLE_TRAINER_DIRECTORY, string + ".html");
        FileHelper.writeTextToFile(string2, string3, Charset.UTF_8);
        return string3;
    }

    public void importGroupsOfOwnListsFromWebsite() {
        this.logic.importGroupsOfOwnListsFromWebsite();
    }

    public void showAllVocablesWithASpecificSearchWord() {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        List<String> list2 = ownLists.getSearchWords();
        AllVocablesWithSpecificConstraintDialog allVocablesWithSpecificConstraintDialog = new AllVocablesWithSpecificConstraintDialog(this.getProgramImage(), this.getLocation(), "Alle Vokabeln mit einem bestimmten Suchbegriff anzeigen.", "Suchbegriff", list2, string -> this.findVocablesWithSpecificSearchWord(string), "Vokabeln mit dem Suchbegriff", (string, list) -> this.showVocablesWithSpecialConstraintAsList(string, list));
        allVocablesWithSpecificConstraintDialog.setVisible(true);
    }

    private List<Vocable> findVocablesWithSpecificSearchWord(String string) {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable vocable : this.logic.collectVocablesOfAllVocabularies()) {
            List<String> list = vocable.getSearchWords();
            if (!list.contains(string)) continue;
            arrayList.add(vocable);
        }
        return arrayList;
    }

    public void showAllAllVocablesWithASpecificPartOfSpeach() {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        List<String> list2 = ownLists.getPartsOfSpeach();
        AllVocablesWithSpecificConstraintDialog allVocablesWithSpecificConstraintDialog = new AllVocablesWithSpecificConstraintDialog(this.getProgramImage(), this.getLocation(), "Alle Vokabeln mit einer bestimmten Wortart anzeigen.", "Wortart", list2, string -> this.findVocablesWithSpecificPartOfSpeach(string), "Vokabeln mit der Wortart", (string, list) -> this.showVocablesWithSpecialConstraintAsList(string, list));
        allVocablesWithSpecificConstraintDialog.setVisible(true);
    }

    private List<Vocable> findVocablesWithSpecificPartOfSpeach(String string) {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable vocable : this.logic.collectVocablesOfAllVocabularies()) {
            List<String> list = vocable.getPartsOfSpeech();
            if (!list.contains(string)) continue;
            arrayList.add(vocable);
        }
        return arrayList;
    }

    private void showVocablesWithSpecialConstraintAsList(String string, List<Vocable> list) {
        this.listVocables(list, string);
        this.setMessageLater(string + " wurden als Liste angezeigt.");
    }

    public void manageKanjiSets() {
        KanjiSetManagementDialog kanjiSetManagementDialog = new KanjiSetManagementDialog(this.logic, this.dataStructures, this.uiObjects, this.getLocation());
        kanjiSetManagementDialog.setVisible(true);
    }

    public void showHiraganaTable() {
        HiraganaTableDialog hiraganaTableDialog = new HiraganaTableDialog(this.dataStructures, this.uiObjects);
        hiraganaTableDialog.setVisible(true);
        this.setMessageLater("Die Hiragana wurden als Liste angezeigt.");
    }

    public void showKatakanaTable() {
        KatakanaTableDialog katakanaTableDialog = new KatakanaTableDialog(this.dataStructures, this.uiObjects);
        katakanaTableDialog.setVisible(true);
        this.setMessageLater("Die Katakana wurden als Liste angezeigt.");
    }

    public void createHiraganaTest() {
        HiraganaTesterLogic hiraganaTesterLogic = new HiraganaTesterLogic(this.dataStructures, this.uiObjects);
        hiraganaTesterLogic.test();
    }

    public void createKatakanaTest() {
        KatakanaTesterLogic katakanaTesterLogic = new KatakanaTesterLogic(this.dataStructures, this.uiObjects);
        katakanaTesterLogic.test();
    }

    public void showVerbsInWoerterbuchformAsList() {
        List<Vocable> list = this.logic.createListOfVerbsInWoerterbuchform();
        this.listVocables(list, "Verben in W\u00f6rterbuchform");
        this.setMessageLater("Die Verben in W\u00f6rterbuchform wurden als Liste angezeigt.");
    }

    public void showAdjectivesInPositivePresenceAsList() {
        List<Vocable> list = this.logic.createListOfAdjectivesInPositivePresence();
        this.listVocables(list, "Adjektive in Grundform (positive Gegenwart)");
        this.setMessageLater("Die Adjektive in Grundform wurden als Liste angezeigt.");
    }

    public void showIAdjectivesInPositivePresenceAsList() {
        List<Vocable> list = this.logic.createListOfIAdjectivesInPositivePresence();
        this.listVocables(list, "\u3044-Adjektive in Grundform (positive Gegenwart)");
        this.setMessageLater("Die \u3044-Adjektive in Grundform wurden als Liste angezeigt.");
    }

    public void showNaAdjectivesInPositivePresenceAsList() {
        List<Vocable> list = this.logic.createListOfNaAdjectivesInPositivePresence();
        this.listVocables(list, "\u306a-Adjektive in Grundform (positive Gegenwart)");
        this.setMessageLater("Die \u306a-Adjektive in Grundform wurden als Liste angezeigt.");
    }

    public void showListOfNaAdjectivesEndingWithI() {
        List<Vocable> list = this.logic.createListOfNaAdjectivesPositivePresenceEndsWithI();
        this.listVocables(list, "\u306a-Adjektive die in Grundform auf \u3044 enden");
        this.setMessageLater("Die \u306a-Adjektive die in Grundform auf \u3044 enden wurden als Liste angezeigt.");
    }

    public void showListOfIruEruExceptionVerbs() {
        List<Vocable> list = this.logic.createListOfIruEruExceptionVerbsInWoerterbuchform();
        this.listVocables(list, "\u3044\u308b/\u3048\u308b-Ausnahme-Verben in W\u00f6rterbuchform");
        this.setMessageLater("Die \u3044\u308b/\u3048\u308b-Ausnahme-Verben in W\u00f6rterbuchform wurden als Liste angezeigt.");
    }

    public void searchKanjiByOnLesung() {
        String string = GuiTools.askUserToEnterAStringValue(this.getWindowAsComponent(), "Bitte eine ON-Lesung eingeben", "Bitte geben Sie die ON-Lesung ein, \u00fcber die nach Kanji gesucht werden soll.");
        if (!string.isBlank()) {
            List<Kanji> list = this.logic.findAllKanjiWithOnLesung(string);
            String string2 = "Alle Kanji mit der ON-Lesung '" + string + "'";
            this.showKanjiList(list, string2);
        }
    }

    public void searchKanjiByKunLesung() {
        String string = GuiTools.askUserToEnterAStringValue(this.getWindowAsComponent(), "Bitte eine kun-Lesung eingeben", "Bitte geben Sie die kun-Lesung ein, \u00fcber die nach Kanji gesucht werden soll.");
        if (!string.isBlank()) {
            List<Kanji> list = this.logic.findAllKanjiWithKunLesung(string);
            String string2 = "Alle Kanji mit der kun-Lesung '" + string + "'";
            this.showKanjiList(list, string2);
        }
    }

    public void searchKanjiByAnyLesung() {
        String string = GuiTools.askUserToEnterAStringValue(this.getWindowAsComponent(), "Bitte eine beliebige Lesung eingeben", "Bitte geben Sie die ON- oder kun-Lesung ein, \u00fcber die nach Kanji gesucht werden soll.");
        if (!string.isBlank()) {
            List<Kanji> list = this.logic.findAllKanjiWithAnyLesung(string);
            String string2 = "Alle Kanji mit der ON- oder kun-Lesung '" + string + "'";
            this.showKanjiList(list, string2);
        }
    }

    public void searchKanjiByGermanMeaning() {
        String string = GuiTools.askUserToEnterAStringValue(this.getWindowAsComponent(), "Bitte eine deutsche Bedeutung eingeben", "Bitte geben Sie die deutsche Bedeutung ein, \u00fcber die nach Kanji gesucht werden soll.");
        if (!string.isBlank()) {
            List<Kanji> list = this.logic.findAllKanjiWithGermanMeaning(string);
            String string2 = "Alle Kanji mit der deutschen Bedeutung '" + string + "'";
            this.showKanjiList(list, string2);
        }
    }

    public void searchKanjiByAny() {
        String string = GuiTools.askUserToEnterAStringValue(this.getWindowAsComponent(), "Bitte einem einen beliebigen Inhalt (Lesung, deutsche Bedeutung) ein", "Bitte geben Sie die ON- oder kun-Lesung oder die deutsche Bedeutung ein, \u00fcber die nach Kanji gesucht werden soll.", this.oldKanjiSearch);
        if (!string.isBlank()) {
            this.oldKanjiSearch = string;
            List<Kanji> list = this.logic.findAllKanjiWithAny(string);
            String string2 = "Alle Kanji mit '" + string + "'";
            this.showKanjiList(list, string2);
        }
    }

    private void showKanjiList(List<Kanji> list, String string) {
        if (list.isEmpty()) {
            GuiTools.informUser("Keine Kanji gefunden", "Es wurden keine Kanji mit den gesuchten Eigenschaften gefunden.");
        } else {
            KanjiTableDialog kanjiTableDialog = new KanjiTableDialog(list, this.dataStructures, this.uiObjects, this.uiObjects.getInformer(), string, this.uiObjects.getGuiLocation());
            kanjiTableDialog.setVisible(true);
        }
    }

    public void openListCommander() {
        OwnListCommander ownListCommander = new OwnListCommander(this, this.dataStructures, this.uiObjects);
        ownListCommander.start();
        this.actualizeOwnListsPart();
        OwnLists ownLists = this.dataStructures.getOwnLists();
        ownLists.storeOwnLists();
    }

    public FumikoUiObjects getUiObjects() {
        return this.uiObjects;
    }

    public void createVerbOrAdjectiveTables() {
        GrammarTableCreator grammarTableCreator = new GrammarTableCreator(this.dataStructures, this.uiObjects);
        grammarTableCreator.create();
        if (grammarTableCreator.isCreationStarted()) {
            this.saveOptions();
        }
    }

    public void showStartupWarningsIfAny() {
        SwingUtilities.invokeLater(() -> this.showStartupWarningsIfAnyInEdt());
    }

    private void showStartupWarningsIfAnyInEdt() {
        List<String> list = this.logic.getStartupWarnings();
        if (!list.isEmpty()) {
            this.reallyShowWarnings(list);
        }
    }
}

